/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.impl.XMLExecutor;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.toolkit.xml.Attribute;
import cn.com.yusys.yusp.bsp.toolkit.xml.Namespace;
import cn.com.yusys.yusp.bsp.toolkit.xml.XMLNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PXMLExecutor
extends XMLExecutor {
    private static final String DATA_FORMAT_SUFFIX = "suffix";
    private static final String DATA_FORMAT_FIELDSUFFIX = "fieldSuffix";
    private static final String DATA_FORMAT_SUPPORTSPLIT = "supportSplit";
    private boolean supportSplit = true;
    private String suffix = "/";
    private Set<String> fieldSuffix;
    protected static final String DATA_FORMAT_NAME = "\u4eba\u884cXML\u6570\u636e\u683c\u5f0f";

    @Override
    public void init(Map<String, String> property) throws Exception {
        super.init(property);
        this.suffix = property.get(DATA_FORMAT_SUFFIX);
        this.supportSplit = Boolean.valueOf(property.get(DATA_FORMAT_SUPPORTSPLIT));
        String fields = property.get(DATA_FORMAT_FIELDSUFFIX);
        this.fieldSuffix = new HashSet<String>();
        this.fieldSuffix.add("Ustrd");
        this.fieldSuffix.add("AddtlInf");
        this.fieldSuffix.add("TxRef");
        this.fieldSuffix.add("PrtryRef");
        if (!StringTools.isEmpty(fields)) {
            String[] arr = fields.split(",");
            if (fields.length() > 0) {
                this.fieldSuffix.addAll(Arrays.asList(arr));
            }
        }
    }

    @Override
    protected void xmlNode2Map(XMLNode xml, Object root) {
        String tempName;
        String name = xml.getName();
        this.nodeList.add(name);
        String value = xml.getValue().trim();
        Map<String, Object> children = xml.getChildren();
        List<Namespace> namespaces = xml.getNamespaces();
        List<Attribute> attributes = xml.getAttrs();
        String cdata = xml.getCDATA();
        HashMap<String, Object> nodeMap = new HashMap<String, Object>();
        if (!StringTools.isEmpty(cdata)) {
            nodeMap.put(this.cdataVariable, cdata);
        }
        if (!StringTools.isEmpty(value)) {
            if (value.startsWith(this.suffix) && this.supportSplit && value.split(this.suffix).length > 2 && this.fieldSuffix.contains(name)) {
                String[] vars = value.split(this.suffix, 3);
                if (!StringTools.isEmpty(vars[1])) {
                    name = vars[1];
                    this.nodeList.removeLast();
                }
                this.nodeList.add(name);
                value = vars[2];
            }
            nodeMap.put(this.valueVariable, value);
        }
        if (!namespaces.isEmpty()) {
            String prefix = null;
            for (Namespace namespace : namespaces) {
                prefix = StringTools.isEmpty(namespace.getPrefix()) ? "xmlns" : namespace.getPrefix();
                prefix = this.convertSign(prefix);
                nodeMap.put(prefix, namespace.getUri());
            }
        }
        if (!attributes.isEmpty()) {
            tempName = null;
            for (Attribute attr : attributes) {
                tempName = this.convertSign(attr.getName());
                nodeMap.put(tempName, attr.getValue());
            }
        }
        tempName = this.convertSign(name);
        if (root instanceof List) {
            ((List)root).add(nodeMap);
        } else if (root instanceof Map) {
            ((Map)root).put(tempName, nodeMap);
        }
        Object obj = null;
        for (String key : children.keySet()) {
            LinkedList childrenList;
            obj = children.get(key);
            if (obj instanceof XMLNode) {
                if (this.validateLoop(this.nodeList, key)) {
                    childrenList = new LinkedList();
                    nodeMap.put(key, childrenList);
                    this.xmlNode2Map((XMLNode)obj, childrenList);
                    continue;
                }
                this.xmlNode2Map((XMLNode)obj, nodeMap);
                continue;
            }
            if (!(obj instanceof List)) continue;
            childrenList = new LinkedList();
            if (!this.supportSplit) {
                nodeMap.put(key, childrenList);
                for (XMLNode tempNode : (List)obj) {
                    this.xmlNode2Map(tempNode, childrenList);
                }
                continue;
            }
            List nodes = (List)obj;
            for (int i = 0; i < nodes.size(); ++i) {
                XMLNode tempNode = (XMLNode)nodes.get(i);
                String tName = tempNode.getName();
                String tValue = tempNode.getValue();
                if (tValue.split(this.suffix).length > 2 && this.fieldSuffix.contains(tName)) {
                    String[] vars = tValue.split(this.suffix, 3);
                    if (!StringTools.isEmpty(vars[1])) {
                        tName = vars[1];
                        this.nodeList.removeLast();
                    }
                    this.nodeList.add(tName);
                    value = vars[2];
                    nodeMap.put(tName, value);
                    this.xmlNode2Map(tempNode, nodeMap);
                    continue;
                }
                nodeMap.put(key, childrenList);
                this.xmlNode2Map(tempNode, childrenList);
            }
        }
        this.nodeList.removeLast();
    }

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    protected XMLNode createNode(XMLNode xml, List<String> nodes) throws Exception {
        LinkedList<String> listNode = new LinkedList<String>();
        listNode.add(nodes.get(0));
        String tempName = null;
        int start = -1;
        int index = -1;
        int end = -1;
        Object obj = null;
        XMLNode root = xml;
        for (int i = 1; i < nodes.size() - 1; ++i) {
            LinkedList<XMLNode> slist;
            XMLNode node;
            List tmpList;
            Object objTmp;
            XMLNode node2;
            List<XMLNode> list;
            index = -1;
            tempName = nodes.get(i);
            start = tempName.indexOf("[");
            end = tempName.indexOf("]");
            if (start != -1 && end != -1) {
                index = Integer.parseInt(tempName.substring(start + 1, end));
                this.logger.info("\u4eba\u884cxml\u8def\u5f84\u5e8f\u53f7\uff1a{}", (Object)tempName.substring(start + 1, end));
                tempName = tempName.substring(0, start);
            }
            if ((obj = root.getChildren().get(tempName)) == null) {
                if (index != -1) {
                    list = new LinkedList();
                    node2 = new XMLNode(tempName);
                    list.add(node2);
                    root.getChildren().put(tempName, list);
                    root = node2;
                    continue;
                }
                XMLNode node3 = new XMLNode(tempName);
                root.getChildren().put(tempName, node3);
                root = node3;
                continue;
            }
            if (obj instanceof XMLNode) {
                root = (XMLNode)obj;
                continue;
            }
            if (!(obj instanceof List)) continue;
            list = (List)obj;
            if (index == list.size()) {
                if (root.getChildren().containsKey(tempName)) {
                    objTmp = root.getChildren().get(tempName);
                    if (objTmp instanceof List) {
                        tmpList = (List)objTmp;
                        node = new XMLNode(tempName);
                        tmpList.add(node);
                        root.getChildren().put(tempName, tmpList);
                        root = node;
                        continue;
                    }
                    if (!(objTmp instanceof XMLNode)) continue;
                    slist = new LinkedList<XMLNode>();
                    node = new XMLNode(tempName);
                    slist.add(node);
                    root.getChildren().put(tempName, slist);
                    root = node;
                    continue;
                }
                node2 = new XMLNode(tempName);
                list.add(node2);
                root = node2;
                continue;
            }
            if (index + 1 == list.size() && i != nodes.size() - 2) {
                XMLNode tmp;
                root = tmp = (XMLNode)list.get(index);
                continue;
            }
            if (index == -1) {
                throw new Exception("[" + this.getExecutorName() + "]\u62fc\u5305\uff0c\u8282\u70b9[" + this.getPath(nodes, i) + "]\u4e3a\u5faa\u73af\u8282\u70b9");
            }
            if (root.getChildren().containsKey(tempName)) {
                objTmp = root.getChildren().get(tempName);
                if (objTmp instanceof List) {
                    tmpList = (List)objTmp;
                    node = new XMLNode(tempName);
                    tmpList.add(node);
                    root.getChildren().put(tempName, tmpList);
                    root = node;
                    continue;
                }
                if (!(objTmp instanceof XMLNode)) continue;
                slist = new LinkedList();
                node = new XMLNode(tempName);
                slist.add(node);
                root.getChildren().put(tempName, slist);
                root = node;
                continue;
            }
            root = (XMLNode)list.get(index);
        }
        return root;
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        String type;
        String path = paras.get("path");
        if (StringTools.isEmpty(path)) {
            throw new Exception("\u4eba\u884cXML\u6570\u636e\u683c\u5f0f\u4e2d[" + item.getName() + "]\u5b57\u6bb5\u7f3a\u5c11\u8def\u5f84\u53c2\u6570\uff01");
        }
        path = OgnlTools.parseXmlPath(path, this.getRootContext());
        path = this.convertSign(path);
        path = this.convertPathToPoint(path);
        if (this.supportSplit) {
            path = path.substring(0, path.lastIndexOf("."));
            path = path + "." + item.getName();
        }
        if ("value".equals(type = paras.get("type"))) {
            path = path + "." + this.valueVariable;
        } else if ("cdata".equals(type)) {
            path = path + "." + this.cdataVariable;
        } else if ("defNamespace".equals(type)) {
            path = path + ".xmlns";
        }
        Object obj = OgnlTools.getValue(path, this.soapMap);
        if ("xml".equals(type)) {
            // empty if block
        }
        return ByteTools.getBytes(obj, this.getEncoding());
    }
}

