/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.ExecutorHelper;
import cn.com.yusys.yusp.bsp.resources.core.BspTools;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;

public class BitmapExecutor
extends AbstractExecutor<byte[]> {
    private static final String DATA_FORMAT_NAME = "Bitmap";
    protected static final String DATA_FORMAT_BITMAP_TYPE = "bitmapType";
    private static final String DATA_FORMAT_BITMAP_LENGTH = "bitmapLen";
    protected static final String DATA_FORMAT_DEFAULT_FILL_STYLE = "defFillStyle";
    protected static final String DATA_FORMAT_DEFAULT_FILLER = "defFiller";
    protected static final String ITEM_ATTRIBUTE_DATA_POSITION = "position";
    protected static final String ITEM_ATTRIBUTE_FILTER_EMPTY = "filterEmpty";
    protected static final String ITEM_ATTRIBUTE_DATA_FIELD_TYPE = "fieldType";
    protected static final String ITEM_ATTRIBUTE_DATA_LENGTH = "length";
    protected static final String ITEM_ATTRIBUTE_DATA_TYPE = "type";
    protected static final String ITEM_ATTRIBUTE_DATA_FILLER = "dataFiller";
    protected static final String ITEM_ATTRIBUTE_DATA_FILL_STYLE = "dataFillStyle";
    protected static final String ITEM_ATTRIBUTE_LENGTH_FIELD_LENGTH = "lenFieldLength";
    protected static final String ITEM_ATTRIBUTE_LENGTH_FIELD_TYPE = "lenFieldType";
    protected static final String ITEM_ATTRIBUTE_LENGTH_FIELD_FILLER = "lenFieldFiller";
    protected static final String ITEM_ATTRIBUTE_LENGTH_FIELD_FILL_STYLE = "lenFieldFillStyle";
    protected static final String DATA_TYPE_ASCII = "ascii";
    protected static final String DATA_TYPE_BCD = "bcd";
    protected static final String DATA_TYPE_BINARY_ASCII = "binaryAscii";
    protected static final String DATA_TYPE_BINARY_BCD = "binaryBcd";
    protected static final String DATA_TYPE_HEXASCII = "hexascii";
    protected static final String DATA_TYPE_HEXBCD = "hexbcd";
    protected static final String FILL_STYLE_LEFT = "left";
    protected static final String FILL_STYLE_RIGHT = "right";
    protected static final String FIELD_TYPE_FIX = "fix";
    protected static final String FIELD_TYPE_UNFIX = "unfix";
    protected String bitmapType;
    private int bitmapLen;
    protected int searchIndex = 0;
    protected String defDataFillStyle;
    protected byte[] defDataFiller;
    protected int bitmapMinPos;
    protected int bitmapMaxPos;
    private boolean isIso8583;
    protected ByteArrayOutputStream output;
    protected int[] bitmap;
    protected LinkedList<Integer> listPosition;
    protected int dataLength;

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        this.bitmapType = property.get(DATA_FORMAT_BITMAP_TYPE);
        this.defDataFillStyle = property.get(DATA_FORMAT_DEFAULT_FILL_STYLE);
        this.defDataFiller = ExecutorHelper.parserFiller(property.get(DATA_FORMAT_DEFAULT_FILLER));
        String str = property.get(DATA_FORMAT_BITMAP_LENGTH);
        try {
            this.bitmapLen = Integer.parseInt(str);
        }
        catch (Exception e) {
            throw new Exception("Incorrect setting of bitmap length [" + this.bitmapLen + "]in [" + this.getExecutorName() + "]");
        }
        this.isIso8583 = false;
        this.searchIndex = 0;
        this.bitmapMinPos = 1;
        this.bitmapMaxPos = this.bitmapLen * 8;
        if (this.getPackType() == DATAFORMAT_PACK) {
            this.output = new ByteArrayOutputStream();
            this.bitmap = new int[this.bitmapLen * 8];
        } else {
            this.listPosition = new LinkedList();
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        this.setInputData(inputData);
        this.dataLength = inputData.length;
        this.unpackBitmap();
    }

    protected void setInputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
    }

    @Override
    public byte[] outputInner() throws Exception {
        byte[] data = this.output.toByteArray();
        this.output.reset();
        this.packBitmap();
        this.output.write(data);
        data = this.output.toByteArray();
        this.output.reset();
        return data;
    }

    protected void packBitmap() throws Exception {
        if (DATA_TYPE_ASCII.equals(this.bitmapType)) {
            int index = this.bitmap.length;
            if (this.isIso8583 && this.bitmap[0] == 0) {
                index /= 2;
            }
            int intBitmap = 0;
            for (int i = 0; i < index; ++i) {
                int intTemp = (i + 1) % 4;
                if (intTemp != 0) {
                    intTemp = -(intTemp - 3);
                    intBitmap += 2 * this.bitmap[i] << intTemp;
                } else {
                    intBitmap += this.bitmap[i] == 0 ? 0 : 1;
                }
                if ((i + 1) % 4 != 0) continue;
                intBitmap = intBitmap > 9 ? intBitmap + 55 : intBitmap + 48;
                this.output.write(intBitmap);
                intBitmap = 0;
            }
        } else if (DATA_TYPE_BCD.equals(this.bitmapType)) {
            int index = this.bitmap.length;
            if (this.isIso8583 && this.bitmap[0] == 0) {
                index /= 2;
            }
            int intBitmap = 0;
            for (int i = 0; i < index; ++i) {
                int intTemp = (i + 1) % 8;
                if (intTemp != 0) {
                    intTemp = -(intTemp - 7);
                    intBitmap += 2 * this.bitmap[i] << intTemp;
                } else {
                    intBitmap += this.bitmap[i] == 0 ? 0 : 1;
                }
                if ((i + 1) % 8 != 0) continue;
                this.output.write(intBitmap);
                intBitmap = 0;
            }
        } else if (DATA_TYPE_BINARY_ASCII.equals(this.bitmapType)) {
            int index = this.bitmap.length;
            if (this.isIso8583 && this.bitmap[0] == 0) {
                index /= 2;
            }
            for (int i = 0; i < index; ++i) {
                int intTemp = this.bitmap[i] + 48;
                this.output.write(intTemp);
            }
        } else if (DATA_TYPE_BINARY_BCD.equals(this.bitmapType)) {
            int index = this.bitmap.length;
            int base2Num = 2;
            if (this.isIso8583 && this.bitmap[0] == 0) {
                index /= base2Num;
            }
            for (int i = 0; i < index; i += base2Num) {
                int intBitmap = this.bitmap[i] * 16 + this.bitmap[i + 1];
                this.output.write(intBitmap);
            }
        } else {
            throw new Exception("The bitmap type [" + this.bitmapType + "] of " + DATA_FORMAT_NAME + " is incorrect!");
        }
    }

    @Override
    protected byte[] prePackItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String fieldType = paras.get(ITEM_ATTRIBUTE_DATA_FIELD_TYPE);
        if (StringTools.isEmpty(fieldType)) {
            throw new Exception("Field type of [" + this.getExecutorName() + "] field [" + item.getName() + "] cannot be empty");
        }
        if (FIELD_TYPE_FIX.equals(fieldType)) {
            String strDataLen = paras.get(ITEM_ATTRIBUTE_DATA_LENGTH);
            return ExecutorHelper.defFillData(this.getExecutorName(), item, data, strDataLen, this.defDataFillStyle, this.defDataFiller, this.getRootContext(), false);
        }
        return data;
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        int position;
        String str = paras.get(ITEM_ATTRIBUTE_DATA_POSITION);
        if (StringTools.isEmpty(str)) {
            throw new Exception("In Bitmap, The Bitmap bit of " + item.getName() + " cannot be empty!");
        }
        try {
            position = Integer.parseInt(str);
        }
        catch (Exception e) {
            throw new Exception("The bitmap bit [" + str + "] of [" + item.getName() + "in" + DATA_FORMAT_NAME + " must be a number!");
        }
        if (position < this.bitmapMinPos || position > this.bitmapMaxPos) {
            throw new Exception("The bitmap bit [" + position + "] of [" + item.getName() + "in" + DATA_FORMAT_NAME + " is incorrect!");
        }
        int base64Num = 64;
        if (this.isIso8583 && position > base64Num) {
            this.bitmap[0] = 1;
        }
        if (this.bitmap[position - 1] != 0) {
            throw new Exception("The bitmap bit [" + position + "] of [" + item.getName() + "in" + DATA_FORMAT_NAME + " is duplicate. It has value before!");
        }
        this.bitmap[position - 1] = 1;
        String fieldType = paras.get(ITEM_ATTRIBUTE_DATA_FIELD_TYPE);
        String dataType = paras.get(ITEM_ATTRIBUTE_DATA_TYPE);
        if (StringTools.isEmpty(dataType)) {
            throw new Exception("Data type of [" + this.getExecutorName() + "] field [" + item.getName() + "] cannot be empty");
        }
        str = paras.get(ITEM_ATTRIBUTE_DATA_FILLER);
        String dataFiller = StringTools.isEmpty(str) ? "0" : str;
        str = paras.get(ITEM_ATTRIBUTE_DATA_FILL_STYLE);
        String dataFillType = StringTools.isEmpty(str) ? FILL_STYLE_LEFT : str;
        str = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_LENGTH);
        int lenFieldLength = StringTools.isEmpty(str) ? 0 : Integer.parseInt(str);
        str = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_TYPE);
        if (StringTools.isEmpty(str)) {
            throw new Exception("The length field type of " + item.getName() + " in " + DATA_FORMAT_NAME + " cannot be empty");
        }
        String lenFieldType = str;
        str = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_FILLER);
        String lenFieldFiller = StringTools.isEmpty(str) ? "0" : str;
        String lenFieldFillStyle = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_FILL_STYLE);
        if (FIELD_TYPE_UNFIX.equals(fieldType)) {
            data = this.packItemFieldTypeIsUnfix(item, data, paras, dataType, dataFiller, dataFillType, lenFieldLength, lenFieldType, lenFieldFiller, lenFieldFillStyle);
        } else if (FIELD_TYPE_FIX.equals(fieldType) && DATA_TYPE_BCD.equals(dataType)) {
            int intFiller = this.parserFiller(dataFiller, item.getName());
            data = ByteTools.asc2Bcd(data, intFiller, FILL_STYLE_LEFT.equals(dataFillType));
        }
        this.output.write(data);
    }

    private byte[] packItemFieldTypeIsUnfix(Item item, byte[] data, Map<String, String> paras, String dataType, String dataFiller, String dataFillType, int lenFieldLength, String lenFieldType, String lenFieldFiller, String lenFieldFillStyle) throws Exception {
        byte[] lenField;
        int lenFieldValue = data.length;
        String str = paras.get(ITEM_ATTRIBUTE_DATA_LENGTH);
        int maxLen = -1;
        if (!StringTools.isEmpty(str)) {
            maxLen = Integer.parseInt(str);
        }
        if (maxLen > 0 && maxLen < lenFieldValue) {
            throw new Exception(this.getExecutorName() + " @ The actual data length [" + lenFieldValue + " of field [" + this.getRealItemPath(item) + "] is greater than the maximum data length [" + maxLen + "]");
        }
        switch (lenFieldType) {
            case "ascii": {
                lenField = ByteTools.int2DecAsciiByte(lenFieldValue);
                if (lenField.length >= lenFieldLength) break;
                if (FILL_STYLE_LEFT.equals(lenFieldFillStyle)) {
                    lenField = ByteTools.leftPad(lenField, lenFieldLength, lenFieldFiller.getBytes());
                    break;
                }
                lenField = ByteTools.rightPad(lenField, lenFieldLength, lenFieldFiller.getBytes());
                break;
            }
            case "bcd": {
                if (!ExecutorHelper.isHexChar(lenFieldFiller)) {
                    throw new Exception("Length field filling character of [" + this.getExecutorName() + "] filed [" + item.getName() + "] must be 0-9 ora-f-F when it is BCD type");
                }
                lenField = ByteTools.int2DecBcdByte(lenFieldValue, true, 0, lenFieldLength);
                break;
            }
            case "hexascii": {
                lenField = ByteTools.int2HexAsciiByte(lenFieldValue);
                if (lenField.length >= lenFieldLength) break;
                if (FILL_STYLE_LEFT.equals(lenFieldFillStyle)) {
                    lenField = ByteTools.leftPad(lenField, lenFieldLength, lenFieldFiller.getBytes());
                    break;
                }
                lenField = ByteTools.rightPad(lenField, lenFieldLength, lenFieldFiller.getBytes());
                break;
            }
            case "hexbcd": {
                if (!ExecutorHelper.isHexChar(lenFieldFiller)) {
                    throw new Exception("Length field filling character of [" + this.getExecutorName() + "] filed [" + item.getName() + "] must be 0-9 ora-f-F when it is HEXBCD type");
                }
                lenField = ByteTools.int2HexBcdByte(lenFieldValue, true, 0, lenFieldLength);
                break;
            }
            default: {
                throw new Exception("The length field type [" + lenFieldType + "] of " + item.getName() + " in " + DATA_FORMAT_NAME);
            }
        }
        this.output.write(lenField);
        if (DATA_TYPE_BCD.equals(dataType)) {
            int intFiller = this.parserFiller(dataFiller, item.getName());
            data = ByteTools.asc2Bcd(data, intFiller, FILL_STYLE_LEFT.equals(dataFillType));
        }
        return data;
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        String str = paras.get(ITEM_ATTRIBUTE_DATA_POSITION);
        if (StringTools.isEmpty(str)) {
            throw new Exception("The bitmap bit [" + str + "] of " + item.getName() + " in " + DATA_FORMAT_NAME + " cannot be empty!");
        }
        int position = Integer.parseInt(str);
        if (position < this.bitmapMinPos || position > this.bitmapMaxPos) {
            throw new Exception("The bitmap bit [" + position + "] of " + item.getName() + "in" + DATA_FORMAT_NAME + " is incorrect!");
        }
        if (this.listPosition.isEmpty() || this.listPosition.getFirst() != position) {
            return null;
        }
        this.listPosition.removeFirst();
        if (this.listPosition.isEmpty()) {
            this.setDataFormatEnd();
        }
        String fieldType = paras.get(ITEM_ATTRIBUTE_DATA_FIELD_TYPE);
        String strDataLen = paras.get(ITEM_ATTRIBUTE_DATA_LENGTH);
        String dataType = paras.get(ITEM_ATTRIBUTE_DATA_TYPE);
        if (StringTools.isEmpty(dataType)) {
            throw new Exception("Data type of " + item.getName() + "in " + DATA_FORMAT_NAME + " cannot be empty");
        }
        str = paras.get(ITEM_ATTRIBUTE_DATA_FILLER);
        String dataFiller = StringTools.isEmpty(str) ? "0" : str;
        str = paras.get(ITEM_ATTRIBUTE_DATA_FILL_STYLE);
        String dataFillType = StringTools.isEmpty(str) ? FILL_STYLE_LEFT : str;
        str = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_LENGTH);
        int lenFieldLength = StringTools.isEmpty(str) ? 0 : Integer.parseInt(str);
        str = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_TYPE);
        if (StringTools.isEmpty(str)) {
            throw new Exception("The length field type of " + item.getName() + "in " + DATA_FORMAT_NAME + " cannot be empty");
        }
        String lenFieldType = str;
        str = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_FILLER);
        String lenFieldFiller = StringTools.isEmpty(str) ? "0" : str;
        String lenFieldFillStyle = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_FILL_STYLE);
        if (FIELD_TYPE_UNFIX.equals(fieldType)) {
            return this.unpackFieldTypeIsUnfix(item, dataType, dataFiller, dataFillType, lenFieldLength, lenFieldType, lenFieldFiller, lenFieldFillStyle);
        }
        if (FIELD_TYPE_FIX.equals(fieldType)) {
            return this.unpackFieldTypeIsFix(item, strDataLen, dataType, dataFiller, dataFillType);
        }
        return null;
    }

    private byte[] unpackFieldTypeIsUnfix(Item item, String dataType, String dataFiller, String dataFillType, int lenFieldLength, String lenFieldType, String lenFieldFiller, String lenFieldFillStyle) throws Exception {
        int intDataLen;
        switch (lenFieldType) {
            case "ascii": {
                byte[] byteLenField = new byte[lenFieldLength];
                System.arraycopy(this.getInputData(), this.searchIndex, byteLenField, 0, lenFieldLength);
                this.searchIndex += lenFieldLength;
                byte[] tempField = FILL_STYLE_RIGHT.equals(lenFieldFillStyle) ? ByteTools.stripEnd(byteLenField, lenFieldFiller.getBytes()) : ByteTools.stripStart(byteLenField, lenFieldFiller.getBytes());
                if (tempField.length == 0) {
                    this.logger.warn("{} @ Length domain [{}] of field [{}] has a length of 0 after removing the separator [{}]", new Object[]{this.getRealItemPath(item), this.getExecutorName(), new String(byteLenField), lenFieldFiller});
                    return new byte[0];
                }
                intDataLen = ByteTools.decAsciiByte2int(tempField);
                break;
            }
            case "bcd": {
                if (!ExecutorHelper.isHexChar(lenFieldFiller)) {
                    throw new Exception("Length field filling character of [" + this.getExecutorName() + "] filed [" + item.getName() + "] must be 0-9 ora-f-F when it is HEXBCD type");
                }
                int len = lenFieldLength % 2 == 0 ? lenFieldLength / 2 : lenFieldLength / 2 + 1;
                byte[] byteLenField = new byte[len];
                System.arraycopy(this.getInputData(), this.searchIndex, byteLenField, 0, len);
                this.searchIndex += len;
                intDataLen = ByteTools.decBcdByte2int(byteLenField, true, 0);
                break;
            }
            case "hexascii": {
                byte[] byteLenField = new byte[lenFieldLength];
                System.arraycopy(this.getInputData(), this.searchIndex, byteLenField, 0, lenFieldLength);
                this.searchIndex += lenFieldLength;
                byte[] tempField = FILL_STYLE_RIGHT.equals(lenFieldFillStyle) ? ByteTools.stripEnd(byteLenField, lenFieldFiller.getBytes()) : ByteTools.stripStart(byteLenField, lenFieldFiller.getBytes());
                if (tempField.length == 0) {
                    this.logger.warn("{} @ Length domain [{}] of field [{}] has a length of 0 after removing the separator [{}]", new Object[]{this.getRealItemPath(item), this.getExecutorName(), new String(byteLenField), lenFieldFiller});
                    return null;
                }
                intDataLen = ByteTools.decAsciiByte2int(tempField);
                break;
            }
            case "hexbcd": {
                int len = lenFieldLength % 2 == 0 ? lenFieldLength / 2 : lenFieldLength / 2 + 1;
                byte[] byteLenField = new byte[len];
                System.arraycopy(this.getInputData(), this.searchIndex, byteLenField, 0, len);
                this.searchIndex += len;
                intDataLen = ByteTools.hexBcdByte2int(byteLenField, true, 0);
                break;
            }
            default: {
                throw new Exception("The length field type [" + lenFieldType + "]" + " of " + item.getName() + " in " + DATA_FORMAT_NAME + "  is wrong!");
            }
        }
        return this.doByDataType(item, dataType, dataFiller, dataFillType, intDataLen);
    }

    private byte[] doByDataType(Item item, String dataType, String dataFiller, String dataFillType, int intDataLen) throws Exception {
        if (DATA_TYPE_BCD.equals(dataType)) {
            int intTemp = intDataLen % 2 == 0 ? intDataLen / 2 : intDataLen / 2 + 1;
            byte[] dataValue = new byte[intTemp];
            System.arraycopy(this.getInputData(), this.searchIndex, dataValue, 0, intTemp);
            this.searchIndex += intTemp;
            int base2Num = 2;
            if (intDataLen % base2Num == 0) {
                dataValue = ByteTools.bcd2Asc(dataValue);
            } else {
                int intFiller = this.parserFiller(dataFiller, item.getName());
                dataValue = ByteTools.bcd2Asc(dataValue, intFiller, FILL_STYLE_LEFT.equals(dataFillType), intDataLen);
            }
            return dataValue;
        }
        if (DATA_TYPE_ASCII.equals(dataType)) {
            byte[] dataValue = new byte[intDataLen];
            System.arraycopy(this.getInputData(), this.searchIndex, dataValue, 0, intDataLen);
            this.searchIndex += intDataLen;
            return dataValue;
        }
        throw new Exception("Data type[" + dataType + "] of " + item.getName() + " in " + DATA_FORMAT_NAME + " is wrong!");
    }

    private byte[] unpackFieldTypeIsFix(Item item, String strDataLen, String dataType, String dataFiller, String dataFillType) throws Exception {
        byte[] dataValue;
        if (StringTools.isEmpty(strDataLen)) {
            throw new Exception("Data length of " + item.getName() + " in " + DATA_FORMAT_NAME + " cannot be empty");
        }
        int intDataLen = Integer.parseInt(strDataLen);
        if (DATA_TYPE_BCD.equals(dataType)) {
            int base2Num = 2;
            int intTemp = intDataLen % base2Num == 0 ? intDataLen / base2Num : intDataLen / base2Num + 1;
            dataValue = new byte[intTemp];
            System.arraycopy(this.getInputData(), this.searchIndex, dataValue, 0, intTemp);
            this.searchIndex += intTemp;
            if (intDataLen % base2Num != 0) {
                int intFiller = this.parserFiller(dataFiller, item.getName());
                dataValue = ByteTools.bcd2Asc(dataValue, intFiller, FILL_STYLE_LEFT.equals(dataFillType), intDataLen);
            } else {
                dataValue = ByteTools.bcd2Asc(dataValue);
            }
        } else {
            dataValue = new byte[intDataLen];
            System.arraycopy(this.getInputData(), this.searchIndex, dataValue, 0, intDataLen);
            this.searchIndex += intDataLen;
        }
        return dataValue;
    }

    @Override
    public void log(int logLevel, Item item, String value, Map<String, String> params, String appendStr) throws Exception {
        String packTypeStr;
        if (this.packType == DATAFORMAT_PACK) {
            packTypeStr = "Pack";
            if (value == null) {
                String logStr = "{} @ {}:[{}]{},ignore {}";
                Object[] logParams = new String[]{this.getExecutorName(), packTypeStr, params.get(ITEM_ATTRIBUTE_DATA_POSITION), OgnlTools.parseXmlPath(this.getRealItemPath(item), this.rootContext), appendStr};
                this.log(logLevel, logStr, logParams);
                return;
            }
        } else {
            packTypeStr = "Unpack";
        }
        if (item.isPwd() && value != null) {
            this.setHiddenInfo(true);
            value = BspTools.pwdTransfer(value);
        }
        String logStr = "{} @ {}:[{}]{}=[{}] {}";
        Object[] logParams = new String[]{this.getExecutorName(), packTypeStr, params.get(ITEM_ATTRIBUTE_DATA_POSITION), OgnlTools.parseXmlPath(this.getRealItemPath(item), this.rootContext), value, appendStr};
        this.log(logLevel, logStr, logParams);
    }

    private void unpackBitmap() {
        if (DATA_TYPE_ASCII.equals(this.bitmapType)) {
            int tempLen = this.bitmapLen * 2;
            byte[] bitmap = new byte[tempLen];
            System.arraycopy(this.getInputData(), this.searchIndex, bitmap, 0, tempLen);
            this.searchIndex += tempLen;
            this.parserAsciiBitmap(bitmap, 4);
        } else if (DATA_TYPE_BCD.equals(this.bitmapType)) {
            byte[] bitmap = new byte[this.bitmapLen];
            System.arraycopy(this.getInputData(), this.searchIndex, bitmap, 0, this.bitmapLen);
            this.searchIndex += this.bitmapLen;
            this.parserBcdBitmap(bitmap, 8);
        } else if (DATA_TYPE_BINARY_ASCII.equals(this.bitmapType)) {
            int tempLen = this.bitmapLen * 8;
            byte[] bitmap = new byte[tempLen];
            System.arraycopy(this.getInputData(), this.searchIndex, bitmap, 0, tempLen);
            this.searchIndex += tempLen;
            this.parserAsciiBitmap(bitmap, 1);
        } else if (DATA_TYPE_BINARY_BCD.equals(this.bitmapType)) {
            int tempLen = this.bitmapLen * 4;
            byte[] bitmap = new byte[tempLen];
            System.arraycopy(this.getInputData(), this.searchIndex, bitmap, 0, tempLen);
            this.searchIndex += tempLen;
            this.parserBcdBitmap(bitmap, 2);
        }
        Collections.sort(this.listPosition);
    }

    protected void parserAsciiBitmap(byte[] bitmap, int len) {
        int i = 0;
        for (byte b : bitmap) {
            int res;
            int n = res = b > 57 ? b - 55 : b - 48;
            if (res == 0) {
                i += len;
                continue;
            }
            for (int j = len; j > 0; --j) {
                int intTemp = res % 2;
                res /= 2;
                if (intTemp != 1) continue;
                this.listPosition.add(i + j);
            }
            i += len;
        }
    }

    protected void parserBcdBitmap(byte[] bitmap, int len) {
        int i = 0;
        for (int n : bitmap) {
            int intTemp;
            int j;
            int res;
            int n2 = res = n < 0 ? 256 + n : n;
            if (res == 0) {
                i += len;
                continue;
            }
            if (len == 8) {
                for (j = len; j > 0; --j) {
                    intTemp = res % 2;
                    res /= 2;
                    if (intTemp != 1) continue;
                    this.listPosition.add(i + j);
                }
            } else if (len == 2) {
                for (j = len; j > 0; --j) {
                    intTemp = res % 16;
                    res /= 16;
                    if (intTemp != 1) continue;
                    this.listPosition.add(i + j);
                }
            }
            i += len;
        }
    }

    private int parserFiller(String filler, String itemName) throws Exception {
        if (ExecutorHelper.isHexChar(filler)) {
            return Integer.parseInt(filler, 16);
        }
        throw new Exception("Data filler [" + filler + "] of field " + itemName + " in " + DATA_FORMAT_NAME + " is wrong, only between 0-f is allowed");
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }

    protected void setIso8583(boolean isIso8583) {
        this.isIso8583 = isIso8583;
    }

    @Override
    public int getSearchIndex() {
        if (this.searchIndex >= this.dataLength) {
            return -1;
        }
        return this.searchIndex;
    }
}

