/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.core;

import cn.com.yusys.yusp.bsp.core.IResponseCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class AsyncResponseCallback
implements IResponseCallback<Map<String, Object>> {
    private final Consumer<Map<String, Object>> onResponse;
    private final Consumer<Map<String, Object>> result;
    private Runnable timeoutCallback;
    private boolean response = false;

    public AsyncResponseCallback(Consumer<Map<String, Object>> onResponse, Consumer<Map<String, Object>> result) {
        this.onResponse = onResponse;
        this.result = result;
    }

    @Override
    public void async(long timeout, Runnable timeoutCallback) {
        this.timeoutCallback = timeoutCallback;
    }

    @Override
    public void response(Map<String, Object> responseData) {
        if (!this.response) {
            this.response = true;
            this.onResponse.accept(responseData);
        }
    }

    @Override
    public void error(Map<String, Object> errorData) {
        if (!this.response) {
            this.response = true;
            this.result.accept(errorData);
        }
    }

    @Override
    public void error(Throwable e) {
        if (!this.response) {
            this.response = true;
            HashMap<String, String> errorData = new HashMap<String, String>(16);
            errorData.put("BSP_RESPONSE_CODE", "500");
            errorData.put("BSP_RESPONSE_MSG", e.getMessage());
            this.result.accept(errorData);
        }
    }

    @Override
    public void timeout() {
        if (!this.response) {
            this.response = true;
            HashMap<String, String> errorData = new HashMap<String, String>(16);
            errorData.put("BSP_RESPONSE_CODE", "504");
            errorData.put("BSP_RESPONSE_MSG", "timeout");
            this.result.accept(errorData);
            if (this.timeoutCallback != null) {
                this.timeoutCallback.run();
                this.timeoutCallback = null;
            }
        }
    }

    @Override
    public void notfound() {
        if (!this.response) {
            this.response = true;
            HashMap<String, String> errorData = new HashMap<String, String>(16);
            errorData.put("BSP_RESPONSE_CODE", "404");
            errorData.put("BSP_RESPONSE_MSG", "service not found");
            this.result.accept(errorData);
        }
    }
}

