/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.out.mq;

import cn.cfit.cnccq.jms.ByteSequence;
import cn.cfit.cnccq.jms.CnccqDestination;
import cn.cfit.cnccq.jms.CnccqJmsContext;
import cn.cfit.cnccq.jms.CnccqJmsProducer;
import cn.cfit.cnccq.jms.CnccqMessage;
import cn.cfit.cnccq.netty.TcpConnection;
import cn.cfit.cnccq.pool.CnccqJmsConnectionPooledFactory;
import cn.com.yusys.yusp.bsp.communication.DataRequest;
import cn.com.yusys.yusp.bsp.communication.IDataAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.out.AbstractOutAdapter;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.time.Duration;
import javax.jms.Destination;
import javax.jms.Message;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class CnccqMqOutAdapter
extends AbstractOutAdapter
implements IDataAdapter {
    private static final String OUT_ADAPTER_NAME = "CNCCQ JMS\u63a5\u51fa\u9002\u914d\u5668";
    private String host;
    private int port;
    private String queueManager;
    private int priority;
    private int maxTotal;
    private int maxIdle;
    private int minIdle;
    private String producerQueueName;
    private String messageId;
    private String correlationId;
    private long timeBetweenEvictionRunsMillis;
    private long maxWaitMillis;
    CnccqJmsContext cnccqJmsContext;
    CnccqJmsConnectionPooledFactory factory;
    GenericObjectPool<TcpConnection> connectPool;
    CnccqJmsProducer producerCustom;
    CnccqDestination cnccqDestination;
    Object lock = new Object();

    @Override
    public String getAdapterTypeName() {
        return OUT_ADAPTER_NAME;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.validateParams();
        this.factory = new CnccqJmsConnectionPooledFactory(this.host, this.port, this.queueManager);
        this.connectPool = this.connectPool(this.factory);
        this.cnccqJmsContext = this.factory.createContext(this.connectPool);
        this.cnccqDestination = new CnccqDestination(this.getProducerQueueName(), this.getQueueManager());
        this.producerCustom = (CnccqJmsProducer)this.cnccqJmsContext.createProducer(this.cnccqDestination, true);
    }

    @Override
    protected IRequest makeRequest(Session session) throws Exception {
        if (!this.isAlive()) {
            throw new Exception(this.getAdapterName() + " @ \u670d\u52a1\u5173\u95ed");
        }
        DataRequest request = new DataRequest();
        request.setOutAdapter(this);
        return request;
    }

    @Override
    protected void unmakeRequest(IRequest request) throws Exception {
    }

    @Override
    public void send(IRequest request) throws Exception {
        DataRequest req = (DataRequest)request;
        CnccqMessage cnccqMessage = new CnccqMessage();
        if (!StringTools.isEmpty(StringTools.getString(OgnlTools.getValue(this.getMessageId(), req.getContext())))) {
            cnccqMessage.setJMSMessageID(StringTools.getString(OgnlTools.getValue(this.getMessageId(), req.getContext())));
        }
        if (!StringTools.isEmpty(this.getCorrelationId())) {
            cnccqMessage.setJMSCorrelationID(StringTools.getString(OgnlTools.getValue(this.getCorrelationId(), req.getContext())));
        }
        try {
            cnccqMessage.setJMSPriority(this.getPriority());
            ByteSequence byteSequence = new ByteSequence(req.getData());
            cnccqMessage.setContent(byteSequence);
            this.producerCustom.send((Destination)this.cnccqDestination, (Message)cnccqMessage);
        }
        catch (Exception e) {
            request.setCloseFlag(true);
            throw new Exception(this.getAdapterTypeName() + " @ \u53d1\u9001\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    @Override
    public byte[] receive(IRequest request) throws Exception {
        throw new Exception(this.getAdapterName() + " @ \u4e0d\u652f\u6301\u63a5\u6536\u64cd\u4f5c");
    }

    @Override
    public void doStop() throws Exception {
        try {
            if (this.producerCustom != null) {
                this.producerCustom.close();
                this.producerCustom = null;
            }
            if (this.cnccqJmsContext != null) {
                this.cnccqJmsContext.close();
            }
        }
        catch (Exception e) {
            this.logger.error(this.getAdapterName() + " @ \u5173\u95ed\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    private void validateParams() throws Exception {
        if (StringTools.isEmpty(this.getHost())) {
            throw new Exception(this.getAdapterName() + " @ \u670d\u52a1\u5730\u5740\u672a\u914d\u7f6e!");
        }
        if (this.getPort() == 0) {
            throw new Exception(this.getAdapterName() + " @ \u76d1\u542c\u7aef\u53e3\u672a\u914d\u7f6e!");
        }
        if (StringTools.isEmpty(this.getQueueManager())) {
            throw new Exception(this.getAdapterName() + " @ \u961f\u5217\u7ba1\u7406\u5668\u672a\u914d\u7f6e!");
        }
        if (StringTools.isEmpty(this.getProducerQueueName())) {
            throw new Exception(this.getAdapterName() + " @ \u53d1\u9001\u961f\u5217\u540d\u79f0\u672a\u914d\u7f6e!");
        }
    }

    public GenericObjectPool<TcpConnection> connectPool(CnccqJmsConnectionPooledFactory pooledFactory) {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(this.getMaxIdle());
        poolConfig.setMaxTotal(this.getMaxTotal());
        poolConfig.setMinIdle(this.getMinIdle());
        poolConfig.setBlockWhenExhausted(true);
        poolConfig.setMaxWait(Duration.ofMinutes(this.getMaxWaitMillis()));
        poolConfig.setTestOnCreate(false);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        poolConfig.setTimeBetweenEvictionRuns(Duration.ofMinutes(this.getTimeBetweenEvictionRunsMillis()));
        poolConfig.setTestWhileIdle(false);
        poolConfig.setJmxEnabled(false);
        return new GenericObjectPool((PooledObjectFactory)pooledFactory, poolConfig);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public String getProducerQueueName() {
        return this.producerQueueName;
    }

    public void setProducerQueueName(String producerQueueName) {
        this.producerQueueName = producerQueueName;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public CnccqJmsContext getCnccqJmsContext() {
        return this.cnccqJmsContext;
    }

    public void setCnccqJmsContext(CnccqJmsContext cnccqJmsContext) {
        this.cnccqJmsContext = cnccqJmsContext;
    }

    public CnccqJmsConnectionPooledFactory getFactory() {
        return this.factory;
    }

    public void setFactory(CnccqJmsConnectionPooledFactory factory) {
        this.factory = factory;
    }

    public GenericObjectPool<TcpConnection> getConnectPool() {
        return this.connectPool;
    }

    public void setConnectPool(GenericObjectPool<TcpConnection> connectPool) {
        this.connectPool = connectPool;
    }

    public CnccqJmsProducer getProducerCustom() {
        return this.producerCustom;
    }

    public void setProducerCustom(CnccqJmsProducer producerCustom) {
        this.producerCustom = producerCustom;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }
}

