/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.in.impl;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.component.exception.ComponentException;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.core.VarDef;
import cn.com.yusys.yusp.bsp.toolkit.common.BCCPTools;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.comm.in.AbstractCommIn;
import java.io.File;
import java.util.Map;

public class BccpCommIn
extends AbstractCommIn {
    protected String unitName = "Bccp Comm";
    private String version;
    private String applicationCode;
    private String tradeCode;
    private String recvFileDir;
    private String sendFile;
    private String relativeDir;
    private String supportFile;
    private String reserveField;

    @Override
    public void processSend(Map<String, Object> context, byte[] data, AbstractRequest request) throws Exception {
        String strVersion = BccpCommIn.getInExpressStringValue(this.version, context);
        if (StringTools.isEmpty(strVersion)) {
            strVersion = "1.0";
        }
        int intVersion = Integer.parseInt(strVersion);
        Object applicationCode = this.getInExpressObjectValue(this.applicationCode, context);
        Object tradeCode = this.getInExpressObjectValue(this.tradeCode, context);
        Object bizSerialNumber = this.getInExpressObjectValue(this.reserveField, context);
        byte[] bsn = ByteTools.getBytes(bizSerialNumber);
        if (bsn == null || bsn.length == 0) {
            Session session = (Session)context.get("T_SESSION");
            bsn = session.getSessionId().getBytes();
        }
        BCCPTools tool = new BCCPTools();
        tool.setVersion(intVersion);
        int option = BCCPTools.DATA_OPTION;
        try {
            String encodeProtocol = "GBK";
            byte[] bodyData = new byte[]{};
            byte[] encode = new byte[]{71, 66, 75};
            if (data != null && data.length != 0) {
                int len = data[0] & 0xFF;
                encode = new byte[len];
                System.arraycopy(data, 1, encode, 0, len);
                encodeProtocol = new String(encode);
                bodyData = new byte[data.length - len - 1];
                System.arraycopy(data, len + 1, bodyData, 0, bodyData.length);
            }
            String isSupportFile = BccpCommIn.getInExpressStringValue(this.supportFile, context);
            String sFile = null;
            String simpleFileName = null;
            String relativeDir = null;
            String trueFlag = "true";
            if (trueFlag.equals(isSupportFile)) {
                sFile = BccpCommIn.getInExpressStringValue(this.sendFile, context);
                relativeDir = BccpCommIn.getInExpressStringValue(this.relativeDir, context);
                if (!StringTools.isEmpty(sFile)) {
                    File f = new File(sFile);
                    if (!f.isFile()) {
                        throw new ComponentException("Sending file does not exist:" + sFile);
                    }
                    simpleFileName = f.getName();
                }
            }
            StreamRequest sr = (StreamRequest)request;
            BCCPTools.BCCPProtocol pro = tool.sendProtocol(sr.getSocketWrapper().getBos(), ByteTools.getBytes(applicationCode, encodeProtocol), ByteTools.getBytes(tradeCode, encodeProtocol), bsn, ByteTools.getBytes(simpleFileName, encodeProtocol), ByteTools.getBytes(relativeDir, encodeProtocol), bodyData, option, encode);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ Send protocol header[{}]:\n{}", new Object[]{this.getUnitName(), pro.getHeadData().length, StringTools.toHexTable(pro.getHeadData())});
                if (VarDef.LOGMESSAGE) {
                    this.logger.info("{} @ Send data[{}]:\n{}", new Object[]{this.getUnitName(), bodyData.length, StringTools.toHexTable(bodyData)});
                } else {
                    this.logger.info("{} @ Send data [{}], message data will not be recorded!", new Object[]{this.getUnitName(), bodyData.length});
                }
                byte[] crcData = pro.getCrcData();
                if (crcData != null && crcData.length != 0) {
                    this.logger.info("{} @ Send data CRC[{}]:\n{}", new Object[]{this.getUnitName(), crcData.length, StringTools.toHexTable(crcData)});
                }
            }
            if (!StringTools.isEmpty(sFile)) {
                tool.sendFile(sr.getSocketWrapper().getBos(), sFile);
                this.logger.debug("{} @ Send file [{}] successfully", new Object[]{this.getUnitName(), sFile});
            }
        }
        catch (Exception e) {
            throw new ComponentException("Send data abnormal:", (Throwable)e, this.getUnitName(), this.getUnitName());
        }
    }

    @Override
    public byte[] processRecv(Map<String, Object> context, AbstractRequest request) throws Exception {
        byte[] data;
        BCCPTools.BCCPProtocol pro;
        BCCPTools tool = new BCCPTools();
        StreamRequest sr = (StreamRequest)request;
        try {
            pro = tool.receiveProtocol(sr.getSocketWrapper().getBis());
            byte[] encode = pro.getEncode().getBytes();
            data = new byte[encode.length + pro.getData().length + 1];
            data[0] = (byte)encode.length;
            System.arraycopy(encode, 0, data, 1, encode.length);
            System.arraycopy(pro.getData(), 0, data, encode.length + 1, pro.getData().length);
        }
        catch (Exception e) {
            throw new ComponentException();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} @ Receive protocol header[{}]:\n{}", new Object[]{this.getUnitName(), pro.getHeadData().length, StringTools.toHexTable(pro.getHeadData())});
            if (VarDef.LOGMESSAGE) {
                this.logger.info("{} @ Receive data body[{}]:\n{}", new Object[]{this.getUnitName(), pro.getData().length, StringTools.toHexTable(pro.getData())});
            } else {
                this.logger.info("{} @ Receive data body [{}], message data will not be recorded!", new Object[]{this.getUnitName(), pro.getData().length});
            }
            if (pro.getCrcData() != null) {
                this.logger.info("{} @ CRC check code[{}]:\n{}", new Object[]{this.getUnitName(), pro.getCrcData().length, StringTools.toHexTable(pro.getCrcData())});
            }
        }
        if (pro.getApplicationCode() != null && pro.getApplicationCode().length != 0) {
            context.put(this.getApplicationCode(), pro.getApplicationCode());
        }
        if (pro.getTradeCode() != null && pro.getTradeCode().length != 0) {
            context.put(this.getTradeCode(), pro.getTradeCode());
        }
        if (pro.getReserveField() != null && pro.getReserveField().length != 0) {
            context.put("G_BSN", pro.getReserveField());
            context.put(this.getReserveField(), pro.getReserveField());
        }
        if (pro.getPackageType() != 0) {
            try {
                String localDir = BccpCommIn.getInExpressStringValue(this.recvFileDir, context);
                if (StringTools.isEmpty(localDir)) {
                    throw new ComponentException("The received file is abnormal, the local path cannot be empty");
                }
                File dir = new File(localDir);
                if (!dir.exists() && !dir.mkdirs()) {
                    throw new ComponentException("The Receive file directory create failed");
                }
                String fp = tool.receiveFile(sr.getSocketWrapper().getBis(), pro.getFilePath(), pro.getRelativeDir(), localDir);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} @ File received successfully:[{}]", new Object[]{this.getUnitName(), fp});
                }
            }
            catch (Exception e) {
                throw new ComponentException("File received abnormal:", (Throwable)e, this.getUnitName(), this.getUnitName());
            }
        }
        return data;
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getApplicationCode() {
        return this.applicationCode;
    }

    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public String getTradeCode() {
        return this.tradeCode;
    }

    public void setTradeCode(String tradeCode) {
        this.tradeCode = tradeCode;
    }

    public String getRecvFileDir() {
        return this.recvFileDir;
    }

    public void setRecvFileDir(String recvFileDir) {
        this.recvFileDir = recvFileDir;
    }

    public String getSendFile() {
        return this.sendFile;
    }

    public void setSendFile(String sendFile) {
        this.sendFile = sendFile;
    }

    public String getRelativeDir() {
        return this.relativeDir;
    }

    public void setRelativeDir(String relativeDir) {
        this.relativeDir = relativeDir;
    }

    public String getSupportFile() {
        return this.supportFile;
    }

    public void setSupportFile(String supportFile) {
        this.supportFile = supportFile;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getReserveField() {
        return this.reserveField;
    }

    public void setReserveField(String reserveField) {
        this.reserveField = reserveField;
    }
}

