/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.channelout.host.domain.repo;

import cn.com.yusys.yusp.bsp.communication.BspTemplate;
import cn.com.yusys.yusp.bsp.component.impl.dataformat.DataFormatComponent;
import cn.com.yusys.yusp.bsp.core.IResponseCallback;
import cn.com.yusys.yusp.bsp.resources.BspContextHolder;
import cn.com.yusys.yusp.bsp.resources.BspDataContext;
import cn.com.yusys.yusp.channelout.host.domain.vo.UiDTradeinfoVo;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ExchangeHostRepo {
    public static final String ATTR_REQUEST_HOST = "requestHost";
    public static final String ATTR_REQUEST_PORT = "requestPort";
    public static final String ATTR_ERR_CODE = "G_EXCEPTION_CODE";
    public static final String ATTR_ERR_MSG = "G_EXCEPTION_MESSAGE";
    private static final String MFD_PATH = "classpath*:config/commOut/hostOut/pub/";
    public static final String unpackname = "unpackjson.mfd";
    public static final String UN_PACK_RSP = "rsprecv";
    public static final String PACK_RSP_NAME = "PACK_RSP_NAME";
    private static final Logger logger = LoggerFactory.getLogger(ExchangeHostRepo.class);

    public void exchangeOutAdapter(Map<String, Object> attributes, @Nullable IResponseCallback<Map<String, Object>> callback, UiDTradeinfoVo uiDTradeinfoVo) throws Exception {
        block4: {
            logger.info("--------\u4ea4\u6613\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\u4e3a\uff1a" + DateUtils.getCurrDateTimeStr() + "-----");
            String functionKey = uiDTradeinfoVo.getSvccode();
            String requestUrl = "http://" + uiDTradeinfoVo.getSvcname() + uiDTradeinfoVo.getSvcurl();
            attributes.put("workdate", DateUtils.getCurrDateStr());
            attributes.put("worktime", DateUtils.getCurrTime());
            attributes.put(ATTR_REQUEST_HOST, requestUrl);
            attributes.put(ATTR_REQUEST_PORT, requestUrl);
            ResponseCallbackPackWrapper wrapperCallback = null;
            if (callback != null) {
                wrapperCallback = new ResponseCallbackPackWrapper(callback);
            }
            try {
                String systemName = uiDTradeinfoVo.getTradename();
                BspTemplate.exchange((String)systemName, (String)functionKey, attributes, (IResponseCallback)wrapperCallback);
            }
            catch (Exception e) {
                if (!attributes.containsKey(ATTR_ERR_CODE)) {
                    attributes.put(ATTR_ERR_CODE, "E010");
                    attributes.put(ATTR_ERR_MSG, "\u4e1a\u52a1\u5e73\u53f0\u53d1\u9001\u6e20\u9053\u6d41\u7a0b\u5f02\u5e38");
                }
                if (callback == null) break block4;
                logger.error("BspTemplate invoke exception", (Throwable)e);
                callback.error((Throwable)e);
            }
        }
    }

    public static void unpackRsp(Map<String, Object> attributes, String unpackname) throws Exception {
        DataFormatComponent dataFormatComponent = new DataFormatComponent();
        dataFormatComponent.setUseConfig(true);
        dataFormatComponent.setUnpackVarName(UN_PACK_RSP);
        String xmlUrl = MFD_PATH + unpackname;
        dataFormatComponent.executeComponent(attributes, xmlUrl);
    }

    public static Map<String, Object> rspPack(Map<String, Object> attributes, String packname) throws Exception {
        logger.info("-------\u5e94\u7b54\u62fc\u5305-------");
        if (StringUtils.isEmpty((Object)packname)) {
            throw new Exception("\u67e5\u627e\u4e0d\u5230\u62fc\u5305\u6587\u4ef6");
        }
        DataFormatComponent dataFormatComponent = new DataFormatComponent();
        dataFormatComponent.setUseConfig(true);
        dataFormatComponent.setPackVarName("send");
        dataFormatComponent.setPackType(0);
        String packXml = MFD_PATH + packname;
        dataFormatComponent.executeComponent(attributes, packXml);
        logger.info("-------\u62fc\u5305-------");
        return attributes;
    }

    static class ResponseCallbackPackWrapper
    extends ResponseCallbackWrapper<Map<String, Object>> {
        private final IResponseCallback<Map<String, Object>> callback;

        protected ResponseCallbackPackWrapper(IResponseCallback<Map<String, Object>> callback) {
            super(callback);
            this.callback = callback;
        }

        public void response(Map<String, Object> map) {
            try {
                BspDataContext context = BspContextHolder.getInstance().getBspDataContext();
                String responseData = ObjectMapperUtils.instance().writeValueAsString(map);
                HashMap attributes = new HashMap();
                context.setData(ExchangeHostRepo.UN_PACK_RSP, (Object)responseData);
                ExchangeHostRepo.unpackRsp(context.getContext(), ExchangeHostRepo.unpackname);
                ExchangeHostRepo.rspPack(context.getContext(), context.getData(ExchangeHostRepo.PACK_RSP_NAME).toString());
            }
            catch (Exception e) {
                logger.error("response", (Throwable)e);
                this.error(e);
            }
        }
    }

    static abstract class ResponseCallbackWrapper<T>
    implements IResponseCallback<T> {
        private final IResponseCallback<?> callback;

        protected ResponseCallbackWrapper(IResponseCallback<?> callback) {
            this.callback = callback;
        }

        public void async(long timeout, Runnable timeoutCallback) {
            this.callback.async(timeout, timeoutCallback);
        }

        public void error(Throwable throwable) {
            this.callback.error(throwable);
        }

        public void timeout() {
            this.callback.timeout();
        }

        public void notfound() {
            this.callback.notfound();
        }

        public void error(T t) {
        }
    }
}

