/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.channelout.host.application.service;

import cn.com.yusys.yusp.bsp.communication.BspTemplate;
import cn.com.yusys.yusp.channelout.host.application.service.IOutExchangeService;
import cn.com.yusys.yusp.channelout.host.domain.repo.CheckPurviewRepo;
import cn.com.yusys.yusp.channelout.host.domain.repo.ReqPackRepo;
import cn.com.yusys.yusp.channelout.host.domain.repo.RespUnpackRepo;
import cn.com.yusys.yusp.channelout.host.domain.repo.SaveOutReqRepo;
import cn.com.yusys.yusp.channelout.host.domain.repo.SecretOrSignRepo;
import cn.com.yusys.yusp.channelout.host.domain.repo.UiDModuleinfoRepo;
import cn.com.yusys.yusp.channelout.host.domain.vo.UiDModuleinfoVo;
import cn.com.yusys.yusp.front.common.constant.JavaDict;
import cn.com.yusys.yusp.front.common.constant.YuinResult;
import cn.com.yusys.yusp.front.common.repo.FiledMapCompent;
import cn.com.yusys.yusp.front.common.util.YuinLogUtils;
import cn.com.yusys.yusp.front.host.dao.po.UcPCominfoPo;
import cn.com.yusys.yusp.front.host.domain.repo.UcPCominfoRepo;
import cn.com.yusys.yusp.front.host.domain.vo.HostReqCommInfo;
import cn.com.yusys.yusp.front.host.domain.vo.RspCommInfo;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HostOutExchangeService
implements IOutExchangeService {
    private String MODULECODE = "modulecode";
    private String SUCCESS_CODE = "000000";
    @Autowired
    private ReqPackRepo reqPackRepo;
    @Autowired
    private SecretOrSignRepo secretOrSignRepo;
    @Autowired
    private UiDModuleinfoRepo uiDModuleinfoRepo;
    @Autowired
    private SaveOutReqRepo saveOutReqRepo;
    @Autowired
    private CheckPurviewRepo checkPurviewRepo;
    @Autowired
    private RespUnpackRepo respUnpackRepo;
    @Autowired
    private UcPCominfoRepo ucPCominfoRepo;
    @Autowired
    private FiledMapCompent filedMapCompent;

    @Override
    public RspCommInfo hostOutExchange(HostReqCommInfo hostReqCommInfo) throws Exception {
        Map attributes = hostReqCommInfo.getSender();
        YuinLogUtils.getInst((Object)this).info("\u6838\u5fc3\u901a\u8baf\u5f00\u59cb");
        RspCommInfo rspCommInfo = new RspCommInfo();
        String sysid = hostReqCommInfo.getSysid();
        String appid = hostReqCommInfo.getAppid();
        String commid = hostReqCommInfo.getHostcommid();
        String bspno = hostReqCommInfo.getBspno();
        String url = hostReqCommInfo.getUrl();
        YuinLogUtils.getInst((Object)this).info("sysid:" + sysid);
        YuinLogUtils.getInst((Object)this).info("appid:" + appid);
        YuinLogUtils.getInst((Object)this).info("commid:" + commid);
        String servicecode = hostReqCommInfo.getSender().getOrDefault("servicecode", "").toString();
        attributes.put("PACK_NAME", servicecode);
        YuinResult result = this.reqPackRepo.reqPack(attributes, servicecode);
        if (!result.isSuccess()) {
            rspCommInfo.setErrcode(result.getErrorCode());
            rspCommInfo.setErrmsg(result.getErrorMsg());
            return rspCommInfo;
        }
        String modulecode = (String)attributes.get(this.MODULECODE);
        UiDModuleinfoVo uiDModuleinfoVo = this.uiDModuleinfoRepo.getById(modulecode);
        result = this.secretOrSignRepo.secretOrSign(attributes, uiDModuleinfoVo);
        if (!result.isSuccess()) {
            rspCommInfo.setErrcode(result.getErrorCode());
            rspCommInfo.setErrmsg(result.getErrorMsg());
            return rspCommInfo;
        }
        result = this.saveOutReqRepo.saveReqData(attributes, uiDModuleinfoVo.getIssave());
        if (!result.isSuccess()) {
            rspCommInfo.setErrcode(result.getErrorCode());
            rspCommInfo.setErrmsg(result.getErrorMsg());
            return rspCommInfo;
        }
        result = this.checkPurviewRepo.checkPurview(attributes);
        if (!result.isSuccess()) {
            rspCommInfo.setErrcode(result.getErrorCode());
            rspCommInfo.setErrmsg(result.getErrorMsg());
            return rspCommInfo;
        }
        UcPCominfoPo ucPCominfoPo = this.ucPCominfoRepo.getComminfo(sysid, appid, commid, bspno);
        HashMap info = new HashMap();
        info.put("send", attributes.get("send"));
        info.put("host_ip", ucPCominfoPo.getComip());
        info.put("host_port", ucPCominfoPo.getComport());
        info.put("host_url", url);
        info.put("servicecode", servicecode);
        Map resultData = null;
        try {
            resultData = BspTemplate.exchange((String)"hostOut", null, info);
        }
        catch (Exception e) {
            rspCommInfo.setErrcode("HOST8888");
            rspCommInfo.setErrmsg("\u6838\u5fc3\u901a\u8baf\u5f02\u5e38");
            return rspCommInfo;
        }
        result = this.respUnpackRepo.respUnpack(resultData);
        result = this.respUnpackRepo.mapPack(resultData);
        JavaDict sourDict = new JavaDict();
        sourDict.setMap(resultData);
        JavaDict dstDict = new JavaDict();
        result = this.filedMapCompent.B_Fld_AccMap(sourDict, dstDict, sysid, appid, servicecode, "HOST->IN", "1", sysid);
        if (result.isSuccess()) {
            rspCommInfo.setRecv(dstDict.get());
            rspCommInfo.setErrcode(this.SUCCESS_CODE);
            rspCommInfo.setErrmsg("\u901a\u8baf\u6210\u529f");
        } else {
            rspCommInfo.setErrcode("HOST0007");
            rspCommInfo.setErrmsg("\u62fc\u5e94\u7b54\u62a5\u6587\u5f02\u5e38");
        }
        return rspCommInfo;
    }
}

