/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.channelout.host.application.service;

import cn.com.yusys.yusp.channelout.host.application.service.IOutExchangeService;
import cn.com.yusys.yusp.channelout.host.domain.repo.UiMOutinfoRepo;
import cn.com.yusys.yusp.channelout.host.domain.vo.UiMOutinfoVo;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.front.host.domain.vo.HostReqCommInfo;
import cn.com.yusys.yusp.front.host.domain.vo.RspCommInfo;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class BeginOutService {
    private static final String MODULECODE = "modulecode";
    private static final String SERVICECODE = "servicecode";
    private static final String PUBLICSERVICE = "hostOutService";
    private static final Logger logger = LoggerFactory.getLogger(BeginOutService.class);
    @Autowired
    private UiMOutinfoRepo uiMOutinfoRepo;
    @Autowired
    private ApplicationContext applicationContext;

    public RspCommInfo startHostOutExchange(HostReqCommInfo hostReqCommInfo) throws Exception {
        RspCommInfo rspCommInfo = new RspCommInfo();
        Map attributes = hostReqCommInfo.getSender();
        String modulecode = (String)attributes.get(MODULECODE);
        String servicecode = (String)attributes.get(SERVICECODE);
        if (StringUtils.isEmpty((CharSequence)modulecode) && StringUtils.isEmpty((CharSequence)servicecode)) {
            rspCommInfo.setErrcode("HOST0007");
            rspCommInfo.setErrmsg("\u83b7\u53d6\u6620\u5c04\u914d\u7f6e\u53c2\u6570\u9519\u8bef");
            return rspCommInfo;
        }
        UiMOutinfoVo uiMOutinfoVo = this.uiMOutinfoRepo.getByTradeCode(modulecode, servicecode);
        if (Objects.isNull(uiMOutinfoVo)) {
            logger.info("\u6267\u884c\u516c\u5171\u6d41\u7a0b");
            IOutExchangeService IOutExchangeService2 = (IOutExchangeService)this.applicationContext.getBean(PUBLICSERVICE);
            rspCommInfo = IOutExchangeService2.hostOutExchange(hostReqCommInfo);
        } else {
            logger.info("\u6267\u884c\u5206\u652f\u6d41\u7a0b");
            String transcode = uiMOutinfoVo.getTranscode();
            IOutExchangeService IOutExchangeService3 = (IOutExchangeService)this.applicationContext.getBean(transcode);
            rspCommInfo = IOutExchangeService3.hostOutExchange(hostReqCommInfo);
        }
        return rspCommInfo;
    }
}

