/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import cn.com.yusys.yusp.commons.security.headers.HeadersSecurityProperties;
import cn.com.yusys.yusp.commons.security.util.WebSecurityUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.header.Header;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.StaticHeadersWriter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

@EnableWebSecurity
@ConditionalOnClass(value={DefaultAuthenticationEventPublisher.class})
@Order(value=99)
@ConditionalOnProperty(prefix="yusp", name={"security.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={HeadersSecurityProperties.class})
public class HeadersSecurityAutoConfiguration
extends WebSecurityConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(HeadersSecurityAutoConfiguration.class);
    private final HeadersSecurityProperties headersSecurityProperties;
    private final List<WebSecurityConfigurerAdapter> securityConfigurerAdapters;

    public HeadersSecurityAutoConfiguration(HeadersSecurityProperties HeadersSecurityProperties2, ObjectProvider<List<WebSecurityConfigurerAdapter>> securityProvider) {
        this.headersSecurityProperties = HeadersSecurityProperties2;
        this.securityConfigurerAdapters = (List)securityProvider.getIfAvailable();
    }

    protected void configure(HttpSecurity http) {
        if (this.securityConfigurerAdapters != null && !this.securityConfigurerAdapters.isEmpty()) {
            this.securityConfigurerAdapters.forEach(securityConfigurerAdapter -> {
                try {
                    this.appendSecurityConfigurer(securityConfigurerAdapter.getHttp());
                }
                catch (Exception e) {
                    log.error("Add Yusp Security Framework exception", (Throwable)e);
                }
            });
        }
        log.debug("Loaded Yusp Security framework Success");
    }

    private void appendSecurityConfigurer(HttpSecurity http) throws Exception {
        http.csrf().csrfTokenRepository((CsrfTokenRepository)new CookieCsrfTokenRepository()).requireCsrfProtectionMatcher(this.requestMatcher());
        List<Header> headers = WebSecurityUtils.parseSecurityHeaders(this.headersSecurityProperties);
        http.headers().contentTypeOptions().disable().frameOptions().disable().xssProtection().disable().cacheControl().disable().addHeaderWriter((HeaderWriter)new StaticHeadersWriter(headers));
    }

    private RequestMatcher requestMatcher() {
        boolean csrfAccess = false;
        List requestMatchers = null;
        if (!StringUtils.isEmpty((Object)this.headersSecurityProperties.getCsrf())) {
            String[] patterns = this.headersSecurityProperties.getCsrf().split(",");
            requestMatchers = Arrays.stream(patterns).map(AntPathRequestMatcher::new).collect(Collectors.toList());
            csrfAccess = true;
        }
        boolean finalCsrfAccess = csrfAccess;
        List finalRequestMatchers = requestMatchers;
        return request -> finalCsrfAccess && finalRequestMatchers != null && finalRequestMatchers.stream().anyMatch(antPathRequestMatcher -> antPathRequestMatcher.matches(request));
    }
}

