/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.security.config;

import cn.com.yusys.yusp.commons.security.config.SQLInjectionProperties;
import cn.com.yusys.yusp.commons.security.headers.HeadersSecurityProperties;
import cn.com.yusys.yusp.commons.security.util.WebSecurityUtils;
import cn.com.yusys.yusp.commons.security.web.filter.SQLInjectionServletFilter;
import cn.com.yusys.yusp.commons.security.web.filter.WebSecurityFilter;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.security.web.header.Header;
import org.springframework.security.web.header.writers.StaticHeadersWriter;

@EnableConfigurationProperties(value={HeadersSecurityProperties.class, SQLInjectionProperties.class})
public class WebSecurityAutoConfiguration {
    private final HeadersSecurityProperties headersSecurityProperties;
    private final SQLInjectionProperties sqlInjectionProperties;

    public WebSecurityAutoConfiguration(HeadersSecurityProperties HeadersSecurityProperties2, SQLInjectionProperties sqlInjectionProperties) {
        this.headersSecurityProperties = HeadersSecurityProperties2;
        this.sqlInjectionProperties = sqlInjectionProperties;
    }

    @Bean
    public FilterRegistrationBean<Filter> webSecurityFilterFilter() {
        WebSecurityFilter webSecurityFilter = new WebSecurityFilter();
        List<Header> headers = WebSecurityUtils.parseSecurityHeaders(this.headersSecurityProperties);
        StaticHeadersWriter headersWriter = new StaticHeadersWriter(headers);
        webSecurityFilter.setHeaderWriters(headersWriter);
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)webSecurityFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.addInitParameter("overrideSecurityHeader", String.valueOf(this.headersSecurityProperties.isOverrideSecurityHeader()));
        registration.setOrder(this.headersSecurityProperties.getOrder());
        return registration;
    }

    @Bean
    @ConditionalOnProperty(name={"yusp.security.sql-injection.enabled"}, havingValue="true")
    public FilterRegistrationBean<Filter> sqlInjectionFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)new SQLInjectionServletFilter(), new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.addInitParameter("regex", this.sqlInjectionProperties.getRegex());
        return registration;
    }
}

