/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelpdf.metadata;

import java.io.File;

public class WaterMarker {
    private final String filePath;
    private final File file;
    private final float positionX;
    private final float positionY;
    private final float opacity;
    private final float rotation;
    private final float rotationDegrees;
    private final float scale;
    private final float customWidth;
    private final float customHeight;
    private final boolean eachPage;
    private final int[] assignPage;
    private final boolean belowContent;
    private final float awayFromLeftPercent;
    private final float awayFromTopPercent;

    public static MarkerBuilder builder() {
        return new MarkerBuilder();
    }

    public WaterMarker(MarkerBuilder builder) {
        this.positionX = builder.positionX;
        this.rotation = builder.rotation;
        this.customHeight = builder.customHeight;
        this.eachPage = builder.eachPage;
        this.file = builder.file;
        this.positionY = builder.positionY;
        this.rotationDegrees = builder.rotationDegrees;
        this.filePath = builder.filePath;
        this.assignPage = builder.assignPage;
        this.customWidth = builder.customWidth;
        this.opacity = builder.opacity;
        this.scale = builder.scale;
        this.belowContent = builder.belowContent;
        this.awayFromLeftPercent = builder.awayFromLeftPercent;
        this.awayFromTopPercent = builder.awayFromTopPercent;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public File getFile() {
        return this.file;
    }

    public float getPositionX() {
        return this.positionX;
    }

    public float getPositionY() {
        return this.positionY;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getRotationDegrees() {
        return this.rotationDegrees;
    }

    public float getScale() {
        return this.scale;
    }

    public float getCustomWidth() {
        return this.customWidth;
    }

    public float getCustomHeight() {
        return this.customHeight;
    }

    public boolean isEachPage() {
        return this.eachPage;
    }

    public int[] getAssignPage() {
        return this.assignPage;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public boolean isBelowContent() {
        return this.belowContent;
    }

    public float getAwayFromLeftPercent() {
        return this.awayFromLeftPercent;
    }

    public float getAwayFromTopPercent() {
        return this.awayFromTopPercent;
    }

    public static final class MarkerBuilder {
        private String filePath;
        private File file;
        private float positionX = 0.0f;
        private float positionY = 0.0f;
        private float opacity = 1.0f;
        private float rotation = 0.0f;
        private float rotationDegrees = 0.0f;
        private float customWidth;
        private float customHeight;
        private boolean eachPage = Boolean.FALSE;
        private int[] assignPage;
        private float scale = 100.0f;
        private boolean belowContent = Boolean.FALSE;
        private float awayFromLeftPercent;
        private float awayFromTopPercent;

        public MarkerBuilder awayFromLeftPercent(float awayFromLeftPercent) {
            this.awayFromLeftPercent = awayFromLeftPercent;
            return this;
        }

        public MarkerBuilder awayFromTopPercent(float awayFromTopPercent) {
            this.awayFromTopPercent = awayFromTopPercent;
            return this;
        }

        public MarkerBuilder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public MarkerBuilder file(File file) {
            this.file = file;
            return this;
        }

        public MarkerBuilder positionX(float positionX) {
            this.positionX = positionX;
            return this;
        }

        public MarkerBuilder positionY(float positionY) {
            this.positionY = positionY;
            return this;
        }

        public MarkerBuilder opacity(float opacity) {
            this.opacity = opacity;
            return this;
        }

        public MarkerBuilder rotation(float rotation) {
            this.rotation = rotation;
            return this;
        }

        public MarkerBuilder rotationDegrees(float rotationDegrees) {
            this.rotationDegrees = rotationDegrees;
            return this;
        }

        public MarkerBuilder scale(float scale) {
            this.scale = scale;
            return this;
        }

        public MarkerBuilder customWidth(float customWidth) {
            this.customWidth = customWidth;
            return this;
        }

        public MarkerBuilder customHeight(float customHeight) {
            this.customHeight = customHeight;
            return this;
        }

        public MarkerBuilder eachPage(boolean eachPage) {
            this.eachPage = eachPage;
            return this;
        }

        public MarkerBuilder assignPage(int[] assignPage) {
            this.assignPage = assignPage;
            return this;
        }

        public MarkerBuilder belowContent(boolean belowContent) {
            this.belowContent = belowContent;
            return this;
        }

        public WaterMarker build() {
            if ((this.filePath == null || this.filePath.isEmpty()) && this.file == null) {
                throw new IllegalArgumentException("Must assign file path or file");
            }
            if (this.file == null) {
                this.file = new File(this.filePath);
                if (!this.file.exists() || this.file.isDirectory()) {
                    throw new IllegalStateException("The mark image file does not exists or its an directory");
                }
            }
            if (this.opacity < 0.0f || this.opacity > 1.0f) {
                throw new IllegalArgumentException("The opacity must between 0.0f and 1.0f");
            }
            if (this.scale <= 0.0f) {
                throw new IllegalArgumentException("The scale must greater than zero");
            }
            return new WaterMarker(this);
        }
    }
}

