/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.xml;

import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.xml.SuperXmlNode;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XmlFileTools {
    private static XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private String encoding = "utf-8";
    private boolean endFlag = false;
    private boolean haveValue = false;
    private byte[] defNamespace = "xmlns".getBytes();
    private byte[] startCData = "<![CDATA[".getBytes();
    private byte[] endCData = "]]>".getBytes();
    private FileOutputStream output;
    private static byte[] digits = new byte[]{60, 62, 61, 34, 58, 32, 47, 38};
    private static byte[] ltEscape = "&lt;".getBytes();
    private static byte[] andEscape = "&amp;".getBytes();

    public XmlFileTools() {
    }

    public XmlFileTools(FileOutputStream fileOutputStream, String encoding) {
        this.output = fileOutputStream;
        this.encoding = encoding;
    }

    public void writeStartDocument(boolean packXml) throws Exception {
        if (packXml) {
            String xml = "<?xml version=\"1.0\" encoding=\"" + this.encoding + "\" ?>";
            this.output.write(xml.getBytes(this.encoding));
        }
    }

    public void writeStartElement(String prefix, String name) throws Exception {
        if (this.endFlag) {
            this.output.write(digits[1]);
        }
        this.output.write(digits[0]);
        if (!StringTools.isEmpty(prefix)) {
            this.output.write(prefix.getBytes(this.encoding));
            this.output.write(digits[4]);
        }
        this.output.write(name.getBytes(this.encoding));
        this.endFlag = true;
    }

    public void writeAttribute(String prefix, String name, byte[] value) throws Exception {
        this.output.write(digits[5]);
        if (!StringTools.isEmpty(prefix)) {
            this.output.write(prefix.getBytes(this.encoding));
            this.output.write(digits[4]);
        }
        this.output.write(name.getBytes(this.encoding));
        this.output.write(digits[2]);
        this.output.write(digits[3]);
        this.output.write(value);
        this.output.write(digits[3]);
    }

    public void writeNamespace(String name, byte[] value) throws Exception {
        this.output.write(digits[5]);
        this.output.write(this.defNamespace);
        this.output.write(digits[4]);
        this.output.write(name.getBytes(this.encoding));
        this.output.write(digits[2]);
        this.output.write(digits[3]);
        this.output.write(value);
        this.output.write(digits[3]);
    }

    public void writeDefaultNamespace(byte[] value) throws Exception {
        this.output.write(digits[5]);
        this.output.write(this.defNamespace);
        this.output.write(digits[2]);
        this.output.write(digits[3]);
        this.output.write(value);
        this.output.write(digits[3]);
    }

    public void writeCData(byte[] data) throws Exception {
        if (this.endFlag) {
            this.output.write(digits[1]);
        }
        this.output.write(this.startCData);
        this.output.write(data);
        this.output.write(this.endCData);
        this.haveValue = true;
        this.endFlag = false;
    }

    public void writeXML(byte[] data) throws Exception {
        if (this.endFlag) {
            this.output.write(digits[1]);
        }
        this.output.write(data);
        this.haveValue = true;
        this.endFlag = false;
    }

    public void writeCharacters(byte[] value) throws Exception {
        if (this.endFlag) {
            this.output.write(digits[1]);
        }
        this.output.write(this.escapeCharacter(value));
        this.haveValue = true;
        this.endFlag = false;
    }

    public void writeEndElement(String prefix, String name, boolean haveChildren) throws Exception {
        if (this.haveValue || haveChildren) {
            this.output.write(digits[0]);
            this.output.write(digits[6]);
            if (!StringTools.isEmpty(prefix)) {
                this.output.write(prefix.getBytes(this.encoding));
                this.output.write(digits[4]);
            }
            this.output.write(name.getBytes(this.encoding));
            this.output.write(digits[1]);
        } else {
            this.output.write(digits[6]);
            this.output.write(digits[1]);
        }
        this.haveValue = false;
        this.endFlag = false;
    }

    public byte[] escapeCharacter(byte[] data) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int index = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == digits[0]) {
                os.write(data, index, i - index);
                os.write(ltEscape);
                index = i + 1;
                continue;
            }
            if (data[i] != digits[7]) continue;
            os.write(data, index, i - index);
            os.write(andEscape);
            index = i + 1;
        }
        if (index != 0) {
            os.write(data, index, data.length - index);
            data = os.toByteArray();
        }
        os.close();
        return data;
    }

    public void writeXMLNode(SuperXmlNode xmlNode) throws Exception {
        this.writeStartElement(xmlNode.getPrefix(), xmlNode.getName());
        for (String key : xmlNode.getNamespaces().keySet()) {
            if (StringTools.isEmpty(key)) {
                this.writeDefaultNamespace(xmlNode.getNamespaceValue("", this.encoding));
                continue;
            }
            this.writeNamespace(key, xmlNode.getNamespaceValue(key, this.encoding));
        }
        for (String key : xmlNode.getAttrs().keySet()) {
            this.writeAttribute(xmlNode.getAttrs().get(key).getPrefix(), key, xmlNode.getAttributeValue(key, this.encoding));
        }
        if (!StringTools.isEmpty(xmlNode.getCData())) {
            this.writeCData(xmlNode.getCData(this.encoding));
        }
        if (!StringTools.isEmpty(xmlNode.getValue())) {
            this.writeCharacters(xmlNode.getValue(this.encoding));
        }
        Object obj = null;
        List tempList = null;
        boolean haveChildren = false;
        for (String key : xmlNode.getChildren().keySet()) {
            haveChildren = true;
            obj = xmlNode.getChildren().get(key);
            if (obj instanceof SuperXmlNode) {
                this.writeXMLNode((SuperXmlNode)obj);
                continue;
            }
            if (!(obj instanceof List)) continue;
            tempList = (List)obj;
            for (SuperXmlNode node : tempList) {
                this.writeXMLNode(node);
            }
        }
        this.writeEndElement(xmlNode.getPrefix(), xmlNode.getName(), haveChildren);
    }

    public SuperXmlNode readerXML(XMLEventReader reader, List<String> xmlNodes, List<String> endPath) throws Exception {
        String str = null;
        XMLEvent event = null;
        SuperXmlNode xml = null;
        SuperXmlNode node = null;
        int startIndex = xmlNodes.size() + 1;
        try {
            while (reader.hasNext()) {
                event = reader.nextEvent();
                if (event.isStartElement()) {
                    StartElement startElement = event.asStartElement();
                    String nodeName = startElement.getName().getLocalPart();
                    node = new SuperXmlNode(nodeName);
                    Iterator<Namespace> nameSpaces = startElement.getNamespaces();
                    Namespace nameSpace = null;
                    while (nameSpaces.hasNext()) {
                        nameSpace = nameSpaces.next();
                        node.addNamespace(nameSpace.getPrefix(), nameSpace.getNamespaceURI());
                    }
                    Iterator<Attribute> attrs = startElement.getAttributes();
                    Attribute attr = null;
                    while (attrs.hasNext()) {
                        attr = attrs.next();
                        node.addAttrs(attr.getName().getPrefix(), attr.getName().getLocalPart(), attr.getValue());
                    }
                    if (xml == null) {
                        xml = node;
                        xmlNodes.add(nodeName);
                        continue;
                    }
                    this.getCurrentNode(xml, startIndex, xmlNodes).addChild(node);
                    xmlNodes.add(nodeName);
                    continue;
                }
                if (event.isCharacters()) {
                    Characters character = event.asCharacters();
                    if (character.isWhiteSpace()) continue;
                    if (character.isCData()) {
                        str = event.asCharacters().getData();
                        node.setCdata(str);
                        continue;
                    }
                    str = event.asCharacters().getData();
                    node.setValue(str);
                    continue;
                }
                if (!event.isEndElement()) continue;
                if (xmlNodes.equals(endPath)) {
                    xmlNodes.remove(xmlNodes.size() - 1);
                    return xml;
                }
                xmlNodes.remove(xmlNodes.size() - 1);
            }
        }
        catch (Exception e) {
            throw new Exception("\u4f7f\u7528Stax\u89e3\u6790XML\u7684\u65f6\u5019\u5f02\u5e38", e);
        }
        return xml;
    }

    public SuperXmlNode readerTemplate(File templateFile, String encoding) throws Exception {
        String str = null;
        XMLEvent event = null;
        SuperXmlNode xml = null;
        SuperXmlNode node = null;
        int startIndex = 1;
        ArrayList<String> xmlNodes = new ArrayList<String>();
        try (XMLEventReader reader = null;){
            reader = inputFactory.createXMLEventReader(new FileInputStream(templateFile), encoding);
            while (reader.hasNext()) {
                event = reader.nextEvent();
                if (event.isStartDocument()) continue;
                if (event.isStartElement()) {
                    StartElement startElement = event.asStartElement();
                    String nodeName = startElement.getName().getLocalPart();
                    node = new SuperXmlNode(nodeName);
                    Iterator<Namespace> nameSpaces = startElement.getNamespaces();
                    Namespace nameSpace = null;
                    while (nameSpaces.hasNext()) {
                        nameSpace = nameSpaces.next();
                        node.addNamespace(nameSpace.getPrefix(), nameSpace.getNamespaceURI());
                    }
                    Iterator<Attribute> attrs = startElement.getAttributes();
                    Attribute attr = null;
                    while (attrs.hasNext()) {
                        attr = attrs.next();
                        node.addAttrs(attr.getName().getPrefix(), attr.getName().getLocalPart(), attr.getValue());
                    }
                    if (xml == null) {
                        xml = node;
                        xmlNodes.add(nodeName);
                        continue;
                    }
                    this.getCurrentNode(xml, startIndex, xmlNodes).addChild(node);
                    xmlNodes.add(nodeName);
                    continue;
                }
                if (event.isCharacters()) {
                    Characters character = event.asCharacters();
                    if (character.isWhiteSpace()) continue;
                    if (character.isCData()) {
                        str = event.asCharacters().getData();
                        node.setCdata(str);
                        continue;
                    }
                    str = event.asCharacters().getData();
                    node.setValue(str);
                    continue;
                }
                if (event.isEndElement()) {
                    xmlNodes.remove(xmlNodes.size() - 1);
                    continue;
                }
                if (!event.isEndDocument()) continue;
                break;
            }
        }
        return xml;
    }

    private SuperXmlNode getCurrentNode(SuperXmlNode xml, int index, List<String> nodeList) {
        SuperXmlNode root = xml;
        Object obj = null;
        String nodeName = null;
        if (nodeList == null) {
            return root;
        }
        for (int i = index; i < nodeList.size(); ++i) {
            nodeName = nodeList.get(i);
            obj = root.getChildren().get(nodeName);
            if (obj instanceof SuperXmlNode) {
                root = (SuperXmlNode)obj;
                continue;
            }
            if (!(obj instanceof List)) continue;
            root = (SuperXmlNode)((LinkedList)obj).getLast();
        }
        return root;
    }
}

