/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method.util;

import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.DesTools;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesEncrypAndDecrypUtil {
    private static final String APPEND = "AppendToTail";
    private static final String REPLACE = "ReplaceToTail";
    private static final String RETVAR = "RetVar";
    private static final String FILE = "File";
    private static final String VAR = "Var";
    private static final String ENCODE = "ENCODE";
    private static final String DECODE = "DECODE";
    private static final String DES1 = "DES1";
    private static final String CIRCLE = "CIRCLE";
    private static final String DES3 = "DES3";
    protected static final String PARA_DATASTARTPOS = "dataStartPos";
    protected static final String PARA_DATALENGTH = "dataLength";
    protected static final String PARA_KEYTYPE = "keyType";
    protected static final String PARA_KEYVAR = "keyVar";
    protected static final String PARA_KEYFILE = "keyFile";
    protected static final String PARA_OPERATION = "operation";
    protected static final String PARA_METHOD = "method";
    protected static final String PARA_MODE = "mode";
    protected static final String PARA_PADDING = "padding";
    protected static final String PARA_RETWAY = "retWay";
    private static final Logger logger = LoggerFactory.getLogger(DesEncrypAndDecrypUtil.class);

    public static byte[] des(Object srcDataObject, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        byte[] encryptData;
        int dataStartPos;
        byte[] dataSrc = ByteTools.getBytes(srcDataObject);
        String inputDataStartPos = StringTools.getString(paras.get(PARA_DATASTARTPOS));
        if (StringTools.isEmpty(inputDataStartPos)) {
            throw new Exception("Starting position is empty");
        }
        try {
            dataStartPos = Integer.parseInt(inputDataStartPos);
        }
        catch (Exception e) {
            throw new Exception("Exception in parsing the interception location of the encrypting and decrypting source data:" + inputDataStartPos);
        }
        String inputDataLength = StringTools.getString(paras.get(PARA_DATALENGTH));
        if (StringTools.isEmpty(inputDataLength)) {
            throw new Exception("Data length is empty");
        }
        int dataLength = Integer.parseInt(inputDataLength);
        if (logger.isDebugEnabled()) {
            logger.debug(" The encrypting and decrypting source data: \n{}", (Object)StringTools.toHexTable(dataSrc));
        }
        try {
            encryptData = ByteTools.subBytes(dataSrc, dataStartPos, true, dataLength, true);
            int base8Num = 8;
            if (encryptData.length % base8Num != 0) {
                int length = (encryptData.length / base8Num + 1) * base8Num;
                byte[] tmpArray = new byte[length];
                System.arraycopy(encryptData, 0, tmpArray, 0, encryptData.length);
                encryptData = tmpArray;
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to get the encrypting and decrypting source data", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Intercepted encrypting and decrypting data: \n{}", (Object)StringTools.toHexTable(encryptData));
        }
        return DesEncrypAndDecrypUtil.encryptedOrDecrypted(paras, dataSrc, encryptData);
    }

    private static byte[] encryptedOrDecrypted(Map<String, Object> paras, byte[] dataSrc, byte[] encryptData) throws Exception {
        byte[] keyData;
        String keyType = (String)paras.get(PARA_KEYTYPE);
        if (VAR.equals(keyType)) {
            Object keyVar = paras.get(PARA_KEYVAR);
            keyData = ByteTools.getBytes(keyVar);
        } else if (FILE.equals(keyType)) {
            Object keyFile = paras.get(PARA_KEYFILE);
            String keyPath = StringTools.getString(keyFile);
            try {
                keyData = FileTools.readFileContent(keyPath);
            }
            catch (Exception e) {
                throw new Exception("Failed to read key file", e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(" Key file content:\n{}", (Object)StringTools.toHexTable(keyData));
            }
        } else {
            throw new Exception("Type not supported");
        }
        String operation = (String)paras.get(PARA_OPERATION);
        String method = (String)paras.get(PARA_METHOD);
        String mode = (String)paras.get(PARA_MODE);
        String padding = (String)paras.get(PARA_PADDING);
        padding = StringTools.isEmpty(padding) ? "NoPadding" : padding;
        mode = StringTools.isEmpty(mode) ? "ECB" : mode;
        byte[] result = null;
        if (ENCODE.equals(operation)) {
            if (DES1.equals(method)) {
                result = DesTools.des1Encode(encryptData, keyData, mode, padding);
            } else if (CIRCLE.equals(method)) {
                result = DesTools.cirEncode(encryptData, keyData, mode, padding);
            } else if (DES3.equals(method)) {
                result = DesTools.des3Encode(encryptData, keyData, mode, padding);
            }
        } else if (DECODE.equals(operation)) {
            if (DES1.equals(method)) {
                result = DesTools.des1Decode(encryptData, keyData, mode, padding);
            } else if (CIRCLE.equals(method)) {
                result = DesTools.cirDecode(encryptData, keyData, mode, padding);
            } else if (DES3.equals(method)) {
                result = DesTools.des3Decode(encryptData, keyData, mode, padding);
            }
        }
        return DesEncrypAndDecrypUtil.des(paras, dataSrc, result);
    }

    private static byte[] des(Map<String, Object> paras, byte[] dataSrc, byte[] result) throws Exception {
        if (result == null) {
            return null;
        }
        String retWay = (String)paras.get(PARA_RETWAY);
        if (RETVAR.equals(retWay)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Encryption and decryption results: \n{}", (Object)StringTools.toHexTable(result));
            }
            return result;
        }
        if (APPEND.equals(retWay)) {
            byte[] tmpArray = new byte[dataSrc.length + result.length];
            System.arraycopy(dataSrc, 0, tmpArray, 0, dataSrc.length);
            System.arraycopy(result, 0, tmpArray, dataSrc.length, result.length);
            if (logger.isDebugEnabled()) {
                logger.debug(" Encryption and decryption result:\n{} ", (Object)StringTools.toHexTable(tmpArray));
            }
            return tmpArray;
        }
        if (REPLACE.equals(retWay)) {
            if (dataSrc.length > result.length) {
                System.arraycopy(result, 0, dataSrc, dataSrc.length - -result.length, result.length);
                if (logger.isDebugEnabled()) {
                    logger.debug(" Encryption and decryption result:\n{} ", (Object)StringTools.toHexTable(dataSrc));
                }
                return dataSrc;
            }
            throw new Exception("The byte length of encrypting and decrypting source data is too short");
        }
        return result;
    }
}

