/*
 * Decompiled with CFR 0.152.
 */
package cn.cfit.cnccq.utils;

import cn.cfit.cnccq.commons.CnccqResultEnum;
import cn.cfit.cnccq.exceptions.CnccqJmsRuntimeException;
import cn.cfit.cnccq.jms.ByteSequence;
import cn.cfit.cnccq.jms.CnccqDestination;
import cn.cfit.cnccq.jms.CnccqJmsConsumer;
import cn.cfit.cnccq.jms.CnccqJmsContext;
import cn.cfit.cnccq.jms.CnccqJmsProducer;
import cn.cfit.cnccq.jms.CnccqMessage;
import cn.cfit.cnccq.netty.TcpConnection;
import cn.cfit.cnccq.pool.CnccqJmsConnectionPooledFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Scanner;
import javax.jms.Destination;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class TestUtils {
    private void cnccqSendMsg(String[] args) {
        if (args.length < 4) {
            System.out.println("\u4f7f\u7528\u65b9\u6cd5:");
            System.out.println("cnccqSendMsg qmName queName ip port filePath");
            System.out.println("\u5fc5\u586b\u53c2\u6570, \u9700\u6309\u987a\u5e8f\u586b\u5199:");
            System.out.println("qmName");
            System.out.println("queName");
            System.out.println("ip");
            System.out.println("port");
            System.out.println("\u9009\u586b\u53c2\u6570:");
            System.out.println("filePath, \u9009\u70b9\u53c2\u6570\u7684\u7b2c\u4e00\u4e2a\u53c2\u6570\uff0c\u540e\u7eed\u53c2\u6570\u987a\u5e8f\u968f\u610f\uff0c\u4f46\u8be5\u53c2\u6570\u5fc5\u987b\u4e3a\u7b2c4\u4e2a\u53c2\u6570");
            return;
        }
        try {
            String qmName = args[0];
            String queName = args[1];
            String ip = args[2];
            int port = Integer.parseInt(args[3]);
            CnccqJmsConnectionPooledFactory connectionPooledFactory = null;
            try {
                connectionPooledFactory = new CnccqJmsConnectionPooledFactory(ip, port, qmName);
            }
            catch (Exception e) {
                System.out.println("ip address error");
                return;
            }
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxIdle(5);
            poolConfig.setMaxTotal(5);
            poolConfig.setMinIdle(5);
            poolConfig.setBlockWhenExhausted(true);
            poolConfig.setMaxWaitMillis(3000L);
            poolConfig.setTestOnCreate(false);
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            poolConfig.setTimeBetweenEvictionRunsMillis(1800000L);
            poolConfig.setTestWhileIdle(false);
            poolConfig.setJmxEnabled(false);
            CnccqJmsProducer cnccqJmsProducer = null;
            CnccqDestination destination = new CnccqDestination(queName, qmName);
            GenericObjectPool<TcpConnection> genericObjectPool = new GenericObjectPool<TcpConnection>(connectionPooledFactory, poolConfig);
            CnccqJmsContext cnccqJmsContext = new CnccqJmsContext(qmName, genericObjectPool);
            try {
                cnccqJmsProducer = (CnccqJmsProducer)cnccqJmsContext.createProducer(destination, false);
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("create connection fail:" + cnccqJmsRuntimeException.getMessage());
                if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.CONNECT_FULL.getCode()) {
                    System.out.println("create connection fail:connect full");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.UNKNOWN_ERROR.getCode()) {
                    System.out.println("create connection fail:queueManager stop");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUEMANAGER_NOT_EXIST.getCode()) {
                    System.out.println("create connection fail:queManager not exists");
                }
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("create connection fail:" + e.getMessage());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            String msgInfo = "test java";
            byte[] bytes = msgInfo.getBytes();
            if (args.length == 5) {
                System.out.println("read file start");
                File file = new File(args[4]);
                if (!file.exists()) {
                    System.out.println("file not exists");
                    System.exit(-1);
                    return;
                }
                if (args[4].indexOf("txt") == -1 && args[4].indexOf("json") == -1 && args[4].indexOf("xml") == -1) {
                    System.out.println("not txt or folder:" + args[4]);
                    System.exit(-1);
                    return;
                }
                try {
                    bytes = this.readFileByLines(args[4]);
                }
                catch (Exception e) {
                    System.out.println("read file fail:" + args[4]);
                    System.exit(-1);
                }
                System.out.println("read file complate");
            }
            CnccqMessage cnccqMessage = new CnccqMessage();
            try {
                ByteSequence byteSequence = new ByteSequence(bytes);
                cnccqMessage.setJMSPriority(1);
                cnccqMessage.setContent(byteSequence);
                cnccqJmsProducer.send((Destination)destination, cnccqMessage);
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("send message fail:" + cnccqJmsRuntimeException.getMessage());
                System.out.println("errCode:" + cnccqJmsRuntimeException.getErrorCode());
                if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.MESSAGE_OVER_LENGTH.getCode()) {
                    System.out.println("message length oversize");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUE_NOT_EXIST.getCode()) {
                    System.out.println("queue not exists");
                }
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("send message fail:" + e.getMessage());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            try {
                cnccqJmsProducer.commit();
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("commit message fail:" + cnccqJmsRuntimeException.getMessage());
                System.out.println("errCode:" + cnccqJmsRuntimeException.getErrorCode());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
            }
            catch (Exception e) {
                System.out.println("commit message fail:" + e.getMessage());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
            }
            System.out.println("send message success");
            System.out.println("errCode:0");
            try {
                int msgNum = cnccqJmsProducer.getMessageCount(queName);
                System.out.println("msgNum:" + msgNum);
            }
            catch (CnccqJmsRuntimeException e) {
                System.out.println("get message num fail:" + e.getMessage());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
            }
            System.out.println("getMsgPrior:" + cnccqMessage.getJMSPriority());
            cnccqJmsProducer.close();
            cnccqJmsContext.close();
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(-1);
        }
    }

    private byte[] readFileByLines(String fileName) throws IOException {
        File file = new File(fileName);
        byte[] bytes = new byte[(int)file.length()];
        FileInputStream fileInputStream = new FileInputStream(fileName);
        int ret = fileInputStream.read(bytes);
        return bytes;
    }

    private void cnccqRecvMsg(String[] args) {
        if (args.length < 4) {
            System.out.println("\u4f7f\u7528\u65b9\u6cd5:");
            System.out.println("cnccqRecvMsg qmName queName tcp://ip:port filePath num -wWaitname");
            System.out.println("\u5fc5\u586b\u53c2\u6570, \u9700\u6309\u987a\u5e8f\u586b\u5199:");
            System.out.println("qmName");
            System.out.println("queName");
            System.out.println("ip");
            System.out.println("port");
            System.out.println("\u9009\u586b\u53c2\u6570:");
            System.out.println("filePath, \u9009\u586b\u53c2\u6570\u7684\u7b2c\u4e00\u4e2a\u53c2\u6570\uff0c\u540e\u7eed\u53c2\u6570\u987a\u5e8f\u968f\u610f\uff0c\u4f46\u8be5\u53c2\u6570\u5fc5\u987b\u4e3a\u7b2c5\u4e2a\u53c2\u6570");
            System.out.println("num, \u8be5\u53c2\u6570\u4e0d\u586b\u65f6\uff0c\u83b7\u53d6\u5168\u90e8\u6d88\u606f");
            System.out.println("-cClose, \u6d4b\u8bd5\u53c2\u6570, \u524d\u7f00-c, 0:\u4e0d\u5173\u95ed\u7a0b\u5e8f\u81ea\u5df1\u9000\u51fa, 1:\u53ea\u5173\u95edsession, 2:\u53ea\u5173\u95edconnect, 3:\u5148session\u540econnect\u5173\u95ed");
            return;
        }
        try {
            int msgNum;
            CnccqJmsConsumer consumer;
            CnccqJmsContext cnccqJmsContext;
            int waitTime;
            int numTmp;
            String fileName;
            String queName;
            block54: {
                String qmName = args[0];
                queName = args[1];
                String ip = args[2];
                int port = Integer.parseInt(args[3]);
                fileName = "";
                numTmp = -1;
                waitTime = 0;
                boolean fileNameFlag = false;
                int closeFlag = 0;
                if (args.length >= 5) {
                    fileName = args[4];
                    fileNameFlag = true;
                    int index = fileName.lastIndexOf(47);
                    String newFilePath = fileName.substring(0, index);
                    System.out.println(newFilePath);
                    File file = new File(newFilePath);
                    if (!file.exists()) {
                        System.out.println("file not exists");
                        System.exit(-1);
                        return;
                    }
                    if (fileName.endsWith("/")) {
                        fileName = fileName + queName;
                    }
                }
                for (int i = 5; i < args.length; ++i) {
                    if (args[i].startsWith("-w")) {
                        waitTime = Integer.parseInt(args[i].substring(2));
                        continue;
                    }
                    if (args[i].startsWith("-c")) {
                        closeFlag = Integer.parseInt(args[i].substring(2));
                        continue;
                    }
                    numTmp = Integer.parseInt(args[i]);
                }
                boolean sesCloseFlag = false;
                boolean connCloseFlag = false;
                if (closeFlag == 0) {
                    sesCloseFlag = false;
                    connCloseFlag = false;
                } else if (closeFlag == 1) {
                    sesCloseFlag = true;
                } else if (closeFlag == 2) {
                    connCloseFlag = true;
                } else if (closeFlag == 3) {
                    sesCloseFlag = true;
                    connCloseFlag = true;
                } else {
                    System.out.println("-c\u53c2\u6570\u9519\u8bef");
                    return;
                }
                CnccqJmsConnectionPooledFactory connectionPooledFactory = null;
                try {
                    connectionPooledFactory = new CnccqJmsConnectionPooledFactory(ip, port, qmName);
                }
                catch (Exception e) {
                    System.out.println("ip address error");
                    return;
                }
                GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
                poolConfig.setMaxIdle(5);
                poolConfig.setMaxTotal(5);
                poolConfig.setMinIdle(5);
                poolConfig.setBlockWhenExhausted(true);
                poolConfig.setMaxWaitMillis(3000L);
                poolConfig.setTestOnCreate(false);
                poolConfig.setTestOnBorrow(true);
                poolConfig.setTestOnReturn(true);
                poolConfig.setTimeBetweenEvictionRunsMillis(1800000L);
                poolConfig.setTestWhileIdle(false);
                poolConfig.setJmxEnabled(false);
                GenericObjectPool<TcpConnection> genericObjectPool = new GenericObjectPool<TcpConnection>(connectionPooledFactory, poolConfig);
                cnccqJmsContext = new CnccqJmsContext(qmName, genericObjectPool);
                CnccqDestination destination = new CnccqDestination(queName, qmName);
                consumer = null;
                try {
                    consumer = (CnccqJmsConsumer)cnccqJmsContext.createConsumer((Destination)destination, false);
                }
                catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                    System.out.println("create connection fail:" + cnccqJmsRuntimeException.getMessage());
                    if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.CONNECT_FULL.getCode()) {
                        System.out.println("create connection fail:connect full");
                    } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.UNKNOWN_ERROR.getCode()) {
                        System.out.println("create connection fail:queueManager stop");
                    } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUEMANAGER_NOT_EXIST.getCode()) {
                        System.out.println("create connection fail:queManager not exists");
                    }
                    if (consumer != null) {
                        consumer.close();
                    }
                    cnccqJmsContext.close();
                    return;
                }
                catch (Exception e) {
                    System.out.println("create connection fail:" + e.getMessage());
                    if (consumer != null) {
                        consumer.close();
                    }
                    cnccqJmsContext.close();
                    return;
                }
                if (!fileNameFlag) {
                    try {
                        CnccqMessage cnccqMessage = consumer.receive();
                        if (cnccqMessage != null) {
                            String msg = new String(cnccqMessage.getContent().getData());
                            System.out.println(msg);
                            System.out.println("recv success,num:1");
                        } else {
                            System.out.println("recv fail,queue empty");
                        }
                        consumer.commit();
                    }
                    catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                        System.out.println("recv fail,successNum:0,failNum:1,actCode:" + cnccqJmsRuntimeException.getMessage());
                        if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUE_NOT_EXIST.getCode()) {
                            System.out.println("queue not exists");
                        }
                        if (consumer != null) {
                            consumer.close();
                        }
                        cnccqJmsContext.close();
                        return;
                    }
                    catch (Exception e) {
                        System.out.println("recv fail,successNum:0,failNum:1,actCode:" + e.getMessage());
                        if (consumer != null) {
                            consumer.close();
                        }
                        cnccqJmsContext.close();
                        return;
                    }
                    consumer.close();
                    cnccqJmsContext.close();
                    return;
                }
                System.out.println("\u8bf7\u786e\u8ba4" + fileName + "_0\u4e0d\u5b58\u5728\uff0c\u5426\u5219\u4f1a\u8986\u76d6\u5199\u5165");
                while (true) {
                    System.out.println("\u8bf7\u8f93\u5165 y \u6216 n \u51b3\u5b9a\u662f\u5426\u7ee7\u7eed");
                    Scanner scanner = new Scanner(System.in);
                    String str = scanner.next();
                    if (str.length() != 1) continue;
                    if ("y".equals(str) || "Y".equals(str)) break block54;
                    if ("n".equals(str) || "N".equals(str)) break;
                }
                consumer.close();
                cnccqJmsContext.close();
                return;
            }
            try {
                msgNum = consumer.getMessageCount(queName);
            }
            catch (CnccqJmsRuntimeException e) {
                System.out.println("get message num fail:" + e.getMessage());
                if (Integer.valueOf(e.getErrorCode()).intValue() == CnccqResultEnum.QUEUE_NOT_EXIST.getCode()) {
                    System.out.println("queue not exists");
                }
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            if (msgNum > 0) {
                System.out.println("msg num:" + msgNum);
            } else if (msgNum == 0) {
                if (waitTime > 0) {
                    System.out.println("queue empty,wait put message...");
                } else {
                    System.out.println("queue empty message");
                    if (consumer != null) {
                        consumer.close();
                    }
                    cnccqJmsContext.close();
                    return;
                }
            }
            if (numTmp == -1) {
                numTmp = msgNum;
            }
            int i = 0;
            boolean errCount = false;
            for (i = 0; i < numTmp; ++i) {
                try {
                    CnccqMessage cnccqMessage = consumer.receive();
                    String msg = new String(cnccqMessage.getContent().getData());
                    FileWriter fw = new FileWriter(fileName + "_" + i);
                    fw.write(msg);
                    fw.close();
                    consumer.commit();
                    continue;
                }
                catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                    System.out.println("recv fail!errorCode:" + cnccqJmsRuntimeException.getMessage());
                    if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() != CnccqResultEnum.QUEUE_NOT_EXIST.getCode()) break;
                    System.out.println("queue not exists");
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            System.out.println("recv success!num:" + i);
            consumer.close();
            cnccqJmsContext.close();
            return;
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(-1);
            return;
        }
    }

    private void cnccqRecvMsg_notcommit(String[] args) {
        if (args.length < 4) {
            System.out.println("\u4f7f\u7528\u65b9\u6cd5:");
            System.out.println("cnccqRecvMsg_notcommit qmName queName ip port");
            System.out.println("\u5fc5\u586b\u53c2\u6570, \u9700\u6309\u987a\u5e8f\u586b\u5199:");
            System.out.println("qmName");
            System.out.println("queName");
            System.out.println("ip");
            System.out.println("port");
            return;
        }
        try {
            String qmName = args[0];
            String queName = args[1];
            String ip = args[2];
            int port = Integer.parseInt(args[3]);
            CnccqJmsConnectionPooledFactory connectionPooledFactory = null;
            try {
                connectionPooledFactory = new CnccqJmsConnectionPooledFactory(ip, port, qmName);
            }
            catch (Exception e) {
                System.out.println("ip address error");
                return;
            }
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxIdle(5);
            poolConfig.setMaxTotal(5);
            poolConfig.setMinIdle(5);
            poolConfig.setBlockWhenExhausted(true);
            poolConfig.setMaxWaitMillis(3000L);
            poolConfig.setTestOnCreate(false);
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            poolConfig.setTimeBetweenEvictionRunsMillis(1800000L);
            poolConfig.setTestWhileIdle(false);
            poolConfig.setJmxEnabled(false);
            GenericObjectPool<TcpConnection> genericObjectPool = new GenericObjectPool<TcpConnection>(connectionPooledFactory, poolConfig);
            CnccqJmsContext cnccqJmsContext = new CnccqJmsContext(qmName, genericObjectPool);
            CnccqDestination destination = new CnccqDestination(queName, qmName);
            CnccqJmsConsumer consumer = null;
            try {
                consumer = (CnccqJmsConsumer)cnccqJmsContext.createConsumer((Destination)destination, false);
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("create connection fail:" + cnccqJmsRuntimeException.getMessage());
                if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.CONNECT_FULL.getCode()) {
                    System.out.println("create connection fail:connect full");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.UNKNOWN_ERROR.getCode()) {
                    System.out.println("create connection fail:queueManager stop");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUEMANAGER_NOT_EXIST.getCode()) {
                    System.out.println("create connection fail:queManager not exists");
                }
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("create connection fail:" + e.getMessage());
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            try {
                CnccqMessage message = consumer.receive();
                System.out.println("result:0");
                System.out.println(new String(message.getContent().getData()));
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("recv fail,successNum:0,failNum:1,actCode:" + cnccqJmsRuntimeException.getMessage());
                if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUE_NOT_EXIST.getCode()) {
                    System.out.println("queue not exists");
                }
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("recv fail,successNum:0,failNum:1,actCode:" + e.getMessage());
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            consumer.close();
            cnccqJmsContext.close();
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(-1);
        }
    }

    private void cnccqRecvMsg_rollback(String[] args) {
        if (args.length < 4) {
            System.out.println("\u4f7f\u7528\u65b9\u6cd5:");
            System.out.println("cnccqRecvMsg_rollback qmName queName ip port");
            System.out.println("\u5fc5\u586b\u53c2\u6570, \u9700\u6309\u987a\u5e8f\u586b\u5199:");
            System.out.println("qmName");
            System.out.println("queName");
            System.out.println("ip");
            System.out.println("port");
            return;
        }
        try {
            String qmName = args[0];
            String queName = args[1];
            String ip = args[2];
            int port = Integer.parseInt(args[3]);
            CnccqJmsConnectionPooledFactory connectionPooledFactory = null;
            try {
                connectionPooledFactory = new CnccqJmsConnectionPooledFactory(ip, port, qmName);
            }
            catch (Exception e) {
                System.out.println("ip address error");
                return;
            }
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxIdle(5);
            poolConfig.setMaxTotal(5);
            poolConfig.setMinIdle(5);
            poolConfig.setBlockWhenExhausted(true);
            poolConfig.setMaxWaitMillis(3000L);
            poolConfig.setTestOnCreate(false);
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            poolConfig.setTimeBetweenEvictionRunsMillis(1800000L);
            poolConfig.setTestWhileIdle(false);
            poolConfig.setJmxEnabled(false);
            GenericObjectPool<TcpConnection> genericObjectPool = new GenericObjectPool<TcpConnection>(connectionPooledFactory, poolConfig);
            CnccqJmsContext cnccqJmsContext = new CnccqJmsContext(qmName, genericObjectPool);
            CnccqDestination destination = new CnccqDestination(queName, qmName);
            CnccqJmsConsumer consumer = null;
            try {
                consumer = (CnccqJmsConsumer)cnccqJmsContext.createConsumer((Destination)destination, false);
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("create connection fail:" + cnccqJmsRuntimeException.getMessage());
                if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.CONNECT_FULL.getCode()) {
                    System.out.println("create connection fail:connect full");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.UNKNOWN_ERROR.getCode()) {
                    System.out.println("create connection fail:queueManager stop");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUEMANAGER_NOT_EXIST.getCode()) {
                    System.out.println("create connection fail:queManager not exists");
                }
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("create connection fail:" + e.getMessage());
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            try {
                CnccqMessage message = consumer.receive();
                System.out.println("result:0");
                System.out.println(new String(message.getContent().getData()));
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("recv fail,successNum:0,failNum:1,actCode:" + cnccqJmsRuntimeException.getMessage());
                if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUE_NOT_EXIST.getCode()) {
                    System.out.println("queue not exists");
                }
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("recv fail,successNum:0,failNum:1,actCode:" + e.getMessage());
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            try {
                consumer.rollback();
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("rollback fail,successNum:0,failNum:1,actCode:" + cnccqJmsRuntimeException.getMessage());
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("rollback fail,successNum:0,failNum:1,actCode:" + e.getMessage());
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            consumer.close();
            cnccqJmsContext.close();
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(-1);
        }
    }

    private void cnccqSendMsg_notcommit(String[] args) {
        if (args.length < 4) {
            System.out.println("\u4f7f\u7528\u65b9\u6cd5:");
            System.out.println("cnccqSendMsg_notcommit qmName queName ip port");
            System.out.println("\u5fc5\u586b\u53c2\u6570, \u9700\u6309\u987a\u5e8f\u586b\u5199:");
            System.out.println("qmName");
            System.out.println("queName");
            System.out.println("ip");
            System.out.println("port");
            return;
        }
        try {
            String qmName = args[0];
            String queName = args[1];
            String ip = args[2];
            int port = Integer.parseInt(args[3]);
            CnccqJmsConnectionPooledFactory connectionPooledFactory = null;
            try {
                connectionPooledFactory = new CnccqJmsConnectionPooledFactory(ip, port, qmName);
            }
            catch (Exception e) {
                System.out.println("ip address error");
                return;
            }
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxIdle(5);
            poolConfig.setMaxTotal(5);
            poolConfig.setMinIdle(5);
            poolConfig.setBlockWhenExhausted(true);
            poolConfig.setMaxWaitMillis(3000L);
            poolConfig.setTestOnCreate(false);
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            poolConfig.setTimeBetweenEvictionRunsMillis(1800000L);
            poolConfig.setTestWhileIdle(false);
            poolConfig.setJmxEnabled(false);
            GenericObjectPool<TcpConnection> genericObjectPool = new GenericObjectPool<TcpConnection>(connectionPooledFactory, poolConfig);
            CnccqJmsContext cnccqJmsContext = new CnccqJmsContext(qmName, genericObjectPool);
            CnccqDestination destination = new CnccqDestination(queName, qmName);
            CnccqJmsProducer cnccqJmsProducer = null;
            try {
                cnccqJmsProducer = (CnccqJmsProducer)cnccqJmsContext.createProducer(destination, false);
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("create connection fail:" + cnccqJmsRuntimeException.getMessage());
                if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.CONNECT_FULL.getCode()) {
                    System.out.println("create connection fail:connect full");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.UNKNOWN_ERROR.getCode()) {
                    System.out.println("create connection fail:queueManager stop");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUEMANAGER_NOT_EXIST.getCode()) {
                    System.out.println("create connection fail:queManager not exists");
                }
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("create connection fail:" + e.getMessage());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            String msgInfo = "test java";
            CnccqMessage cnccqMessage = new CnccqMessage();
            try {
                ByteSequence byteSequence = new ByteSequence(msgInfo.getBytes(StandardCharsets.UTF_8));
                cnccqMessage.setJMSPriority(1);
                cnccqMessage.setContent(byteSequence);
                cnccqJmsProducer.send((Destination)destination, cnccqMessage);
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("send message fail:" + cnccqJmsRuntimeException.getMessage());
                if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUE_NOT_EXIST.getCode()) {
                    System.out.println("queue not exists");
                }
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("send message fail:" + e.getMessage());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            System.out.println("send message success");
            System.out.println("result:" + cnccqJmsProducer.getResult() + " errCode:" + cnccqJmsProducer.getResult());
            try {
                int msgNum = cnccqJmsProducer.getMessageCount(queName);
                System.out.println("msgNum:" + msgNum);
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("get message num fail:" + cnccqJmsRuntimeException.getMessage());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("get message num fail:" + e.getMessage());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            cnccqJmsProducer.close();
            cnccqJmsContext.close();
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(-1);
        }
    }

    private void cnccqSendMsg_rollback(String[] args) {
        if (args.length < 4) {
            System.out.println("\u4f7f\u7528\u65b9\u6cd5:");
            System.out.println("cnccqSendMsg_rollback qmName queName ip port");
            System.out.println("\u5fc5\u586b\u53c2\u6570, \u9700\u6309\u987a\u5e8f\u586b\u5199:");
            System.out.println("qmName");
            System.out.println("queName");
            System.out.println("ip");
            System.out.println("port");
            return;
        }
        try {
            String qmName = args[0];
            String queName = args[1];
            String ip = args[2];
            int port = Integer.parseInt(args[3]);
            CnccqJmsConnectionPooledFactory connectionPooledFactory = null;
            try {
                connectionPooledFactory = new CnccqJmsConnectionPooledFactory(ip, port, qmName);
            }
            catch (Exception e) {
                System.out.println("ip address error");
                return;
            }
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxIdle(5);
            poolConfig.setMaxTotal(5);
            poolConfig.setMinIdle(5);
            poolConfig.setBlockWhenExhausted(true);
            poolConfig.setMaxWaitMillis(3000L);
            poolConfig.setTestOnCreate(false);
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            poolConfig.setTimeBetweenEvictionRunsMillis(1800000L);
            poolConfig.setTestWhileIdle(false);
            poolConfig.setJmxEnabled(false);
            GenericObjectPool<TcpConnection> genericObjectPool = new GenericObjectPool<TcpConnection>(connectionPooledFactory, poolConfig);
            CnccqJmsContext cnccqJmsContext = new CnccqJmsContext(qmName, genericObjectPool);
            CnccqDestination destination = new CnccqDestination(queName, qmName);
            CnccqJmsProducer cnccqJmsProducer = null;
            try {
                cnccqJmsProducer = (CnccqJmsProducer)cnccqJmsContext.createProducer(destination, false);
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("create connection fail:" + cnccqJmsRuntimeException.getMessage());
                if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.CONNECT_FULL.getCode()) {
                    System.out.println("create connection fail:connect full");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.UNKNOWN_ERROR.getCode()) {
                    System.out.println("create connection fail:queueManager stop");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUEMANAGER_NOT_EXIST.getCode()) {
                    System.out.println("create connection fail:queManager not exists");
                }
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("create connection fail:" + e.getMessage());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            String msgInfo = "test java";
            CnccqMessage cnccqMessage = new CnccqMessage();
            try {
                ByteSequence byteSequence = new ByteSequence(msgInfo.getBytes(StandardCharsets.UTF_8));
                cnccqMessage.setJMSPriority(1);
                cnccqMessage.setContent(byteSequence);
                cnccqJmsProducer.send((Destination)destination, cnccqMessage);
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("send message fail:" + cnccqJmsRuntimeException.getMessage());
                if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUE_NOT_EXIST.getCode()) {
                    System.out.println("queue not exists");
                }
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("send message fail:" + e.getMessage());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            System.out.println("send message success");
            cnccqJmsProducer.rollback();
            System.out.println("result:" + cnccqJmsProducer.getResult() + " errCode:" + cnccqJmsProducer.getResult());
            try {
                int msgNum = cnccqJmsProducer.getMessageCount(queName);
                System.out.println("msgNum:" + msgNum);
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("get message num fail:" + cnccqJmsRuntimeException.getMessage());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("get message num fail:" + e.getMessage());
                if (cnccqJmsProducer != null) {
                    cnccqJmsProducer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            cnccqJmsProducer.close();
            cnccqJmsContext.close();
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(-1);
        }
    }

    private void putMsgTest(String[] args) throws IOException {
        if (args.length < 8) {
            System.out.println("\u4f7f\u7528\u65b9\u6cd5:");
            System.out.println("putMsgTest qmName queName ip port filePath sendTime num proity");
            System.out.println("\u5fc5\u586b\u53c2\u6570, \u9700\u6309\u987a\u5e8f\u586b\u5199:");
            System.out.println("qmName");
            System.out.println("queName");
            System.out.println("ip");
            System.out.println("port");
            System.out.println("filePath,\u6587\u4ef6\u8def\u5f84");
            System.out.println("sendTime,\u53d1\u5305\u65f6\u95f4");
            System.out.println("num,\u53d1\u5305\u6570\u91cf");
            System.out.println("proity,\u4f18\u5148\u7ea7");
            return;
        }
        try {
            long startTime;
            FileWriter fileWriter;
            CnccqJmsProducer cnccqJmsProducer;
            CnccqJmsContext cnccqJmsContext;
            block46: {
                String qmName = args[0];
                String queName = args[1];
                String ip = args[2];
                int port = Integer.parseInt(args[3]);
                String fileName = args[4];
                File file = new File(fileName);
                if (!file.exists()) {
                    System.out.println("file not exists");
                    System.exit(-1);
                    return;
                }
                if (args[4].indexOf("txt") == -1 && args[4].indexOf("json") == -1 && args[4].indexOf("xml") == -1) {
                    System.out.println("not txt or folder:" + args[4]);
                    System.exit(-1);
                    return;
                }
                CnccqJmsConnectionPooledFactory connectionPooledFactory = null;
                try {
                    connectionPooledFactory = new CnccqJmsConnectionPooledFactory(ip, port, qmName);
                }
                catch (Exception e) {
                    System.out.println("ip address error");
                    return;
                }
                GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
                poolConfig.setMaxIdle(5);
                poolConfig.setMaxTotal(5);
                poolConfig.setMinIdle(5);
                poolConfig.setBlockWhenExhausted(true);
                poolConfig.setMaxWaitMillis(3000L);
                poolConfig.setTestOnCreate(false);
                poolConfig.setTestOnBorrow(true);
                poolConfig.setTestOnReturn(true);
                poolConfig.setTimeBetweenEvictionRunsMillis(1800000L);
                poolConfig.setTestWhileIdle(false);
                poolConfig.setJmxEnabled(false);
                GenericObjectPool<TcpConnection> genericObjectPool = new GenericObjectPool<TcpConnection>(connectionPooledFactory, poolConfig);
                cnccqJmsContext = new CnccqJmsContext(qmName, genericObjectPool);
                CnccqDestination destination = new CnccqDestination(queName, qmName);
                cnccqJmsProducer = null;
                try {
                    cnccqJmsProducer = (CnccqJmsProducer)cnccqJmsContext.createProducer(destination, false);
                }
                catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                    System.out.println("create connection fail:" + cnccqJmsRuntimeException.getMessage());
                    if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.CONNECT_FULL.getCode()) {
                        System.out.println("create connection fail:connect full");
                    } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.UNKNOWN_ERROR.getCode()) {
                        System.out.println("create connection fail:queueManager stop");
                    } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUEMANAGER_NOT_EXIST.getCode()) {
                        System.out.println("create connection fail:queManager not exists");
                    } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.CONNECT_ENOUGH.getCode()) {
                        System.out.println("create connection fail:connect full");
                    }
                    if (cnccqJmsProducer != null) {
                        cnccqJmsProducer.close();
                    }
                    cnccqJmsContext.close();
                    return;
                }
                catch (Exception e) {
                    System.out.println("create connection fail:" + e.getMessage());
                    if (cnccqJmsProducer != null) {
                        cnccqJmsProducer.close();
                    }
                    cnccqJmsContext.close();
                    return;
                }
                fileWriter = new FileWriter("./putMsgInfo.csv");
                int getTime = Integer.parseInt(args[5]);
                int getNum = Integer.parseInt(args[6]);
                int interval = 0;
                if (args.length == 9 && args[8].startsWith("-i")) {
                    interval = Integer.parseInt(args[8].substring(2));
                }
                startTime = System.nanoTime();
                int count = 0;
                byte[] msgInfo = this.readFileByLines(args[4]);
                if (getTime != 0) {
                    int i = 0;
                    while (true) {
                        long pkgWatch = System.nanoTime();
                        CnccqMessage cnccqMessage = new CnccqMessage();
                        ByteSequence byteSequence = new ByteSequence(msgInfo);
                        cnccqMessage.setContent(byteSequence);
                        int priorss = Integer.parseInt(args[7]);
                        cnccqMessage.setJMSPriority(priorss);
                        try {
                            cnccqJmsProducer.send((Destination)destination, cnccqMessage);
                        }
                        catch (CnccqJmsRuntimeException jmsRuntimeException) {
                            if (Integer.valueOf(jmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUE_NOT_EXIST.getCode()) {
                                System.out.println("queue not exists");
                            }
                            System.out.println("send message fail:" + jmsRuntimeException.getErrorCode());
                            System.out.println("result:-1 errCode:" + jmsRuntimeException.getErrorCode());
                            if (cnccqJmsProducer != null) {
                                cnccqJmsProducer.close();
                            }
                            cnccqJmsContext.close();
                            return;
                        }
                        catch (Exception e) {
                            System.out.println("send message fail");
                            System.out.println("result:-1 errCode:-1");
                            if (cnccqJmsProducer != null) {
                                cnccqJmsProducer.close();
                            }
                            cnccqJmsContext.close();
                            return;
                        }
                        try {
                            cnccqJmsProducer.commit();
                        }
                        catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                            System.out.println("commit message fail:" + cnccqJmsRuntimeException.getMessage());
                            if (cnccqJmsProducer != null) {
                                cnccqJmsProducer.close();
                            }
                            cnccqJmsContext.close();
                            return;
                        }
                        if (++count == 100) {
                            count = 0;
                            try {
                                Thread.currentThread();
                                Thread.sleep(interval);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        String tmp = i + " " + (System.nanoTime() - pkgWatch) / 1000L + "\n";
                        fileWriter.append(tmp);
                        if ((System.nanoTime() - startTime) / 1000000000L < (long)getTime) {
                            ++i;
                            continue;
                        }
                        break block46;
                        break;
                    }
                }
                if (getNum != 0) {
                    for (int i = 0; i < getNum; ++i) {
                        long pkgWatch = System.nanoTime();
                        CnccqMessage cnccqMessage = new CnccqMessage();
                        ByteSequence byteSequence = new ByteSequence(msgInfo);
                        cnccqMessage.setContent(byteSequence);
                        int priorss = Integer.parseInt(args[7]);
                        cnccqMessage.setJMSPriority(priorss);
                        try {
                            cnccqJmsProducer.send((Destination)destination, cnccqMessage);
                        }
                        catch (CnccqJmsRuntimeException jmsRuntimeException) {
                            System.out.println("send message fail:" + jmsRuntimeException.getErrorCode());
                            System.out.println("result:-1 errCode:" + jmsRuntimeException.getErrorCode());
                            if (cnccqJmsProducer != null) {
                                cnccqJmsProducer.close();
                            }
                            cnccqJmsContext.close();
                            return;
                        }
                        catch (Exception e) {
                            System.out.println("send message fail");
                            System.out.println("result:-1 errCode:-1");
                            if (cnccqJmsProducer != null) {
                                cnccqJmsProducer.close();
                            }
                            cnccqJmsContext.close();
                            return;
                        }
                        try {
                            cnccqJmsProducer.commit();
                        }
                        catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                            System.out.println("commit message fail:" + cnccqJmsRuntimeException.getMessage());
                            if (cnccqJmsProducer != null) {
                                cnccqJmsProducer.close();
                            }
                            cnccqJmsContext.close();
                            return;
                        }
                        String tmp = i + " " + (System.nanoTime() - pkgWatch) / 1000L + "\n";
                        fileWriter.append(tmp);
                    }
                } else {
                    System.out.println("\u53d1\u9001\u65f6\u95f4\u548c\u6b21\u6570\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\uff0c\u53e6\u4e00\u4e2a\u8bbe\u7f6e\u4e3a0");
                }
            }
            System.out.printf("execution duration:%d s\n", (System.nanoTime() - startTime) / 1000000000L);
            fileWriter.close();
            cnccqJmsProducer.close();
            cnccqJmsContext.close();
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(-1);
        }
    }

    private void putMsgTestNotInterrupt(String[] args) throws IOException {
        if (args.length < 10) {
            System.out.println("\u4f7f\u7528\u65b9\u6cd5:");
            System.out.println("putMsgTest qmName queName ip port filePath sendTime num proity");
            System.out.println("\u5fc5\u586b\u53c2\u6570, \u9700\u6309\u987a\u5e8f\u586b\u5199:");
            System.out.println("qmName");
            System.out.println("queName");
            System.out.println("ip");
            System.out.println("port");
            System.out.println("filePath,\u6587\u4ef6\u8def\u5f84");
            System.out.println("sendTime,\u53d1\u5305\u65f6\u95f4");
            System.out.println("num,\u53d1\u5305\u6570\u91cf");
            System.out.println("proity,\u4f18\u5148\u7ea7");
            System.out.println("logFilePath,\u65e5\u5fd7\u8def\u5f84");
            System.out.println("sleepTime -i,\u95f4\u9694\u65f6\u95f4");
            return;
        }
        try {
            long startTime;
            FileWriter fileWriter;
            CnccqJmsProducer cnccqJmsProducer;
            CnccqJmsContext cnccqJmsContext;
            block41: {
                String qmName = args[0];
                String queName = args[1];
                String ip = args[2];
                int port = Integer.parseInt(args[3]);
                String fileName = args[4];
                File file = new File(fileName);
                if (!file.exists()) {
                    System.out.println("file not exists");
                    System.exit(-1);
                    return;
                }
                if (args[4].indexOf("txt") == -1 && args[4].indexOf("json") == -1 && args[4].indexOf("xml") == -1) {
                    System.out.println("not txt or folder:" + args[4]);
                    System.exit(-1);
                    return;
                }
                String logFilePath = args[8];
                int index = fileName.lastIndexOf(47);
                String newFilePath = logFilePath.substring(0, index);
                System.out.println(newFilePath);
                File logFile = new File(newFilePath);
                if (!logFile.exists()) {
                    System.out.println("file not exists");
                    System.exit(-1);
                    return;
                }
                int sleepTime = 0;
                String sleepTimeStr = args[9];
                sleepTimeStr = sleepTimeStr.replace("-i", "");
                try {
                    sleepTime = Integer.valueOf(sleepTimeStr);
                }
                catch (Exception e) {
                    System.out.println("sleepTime is not int");
                    System.exit(-1);
                    return;
                }
                CnccqJmsConnectionPooledFactory connectionPooledFactory = null;
                try {
                    connectionPooledFactory = new CnccqJmsConnectionPooledFactory(ip, port, qmName);
                }
                catch (Exception e) {
                    System.out.println("ip address error");
                    return;
                }
                GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
                poolConfig.setMaxIdle(5);
                poolConfig.setMaxTotal(5);
                poolConfig.setMinIdle(5);
                poolConfig.setBlockWhenExhausted(true);
                poolConfig.setMaxWaitMillis(3000L);
                poolConfig.setTestOnCreate(false);
                poolConfig.setTestOnBorrow(true);
                poolConfig.setTestOnReturn(true);
                poolConfig.setTimeBetweenEvictionRunsMillis(1800000L);
                poolConfig.setTestWhileIdle(false);
                poolConfig.setJmxEnabled(false);
                GenericObjectPool<TcpConnection> genericObjectPool = new GenericObjectPool<TcpConnection>(connectionPooledFactory, poolConfig);
                cnccqJmsContext = new CnccqJmsContext(qmName, genericObjectPool);
                CnccqDestination destination = new CnccqDestination(queName, qmName);
                cnccqJmsProducer = null;
                try {
                    cnccqJmsProducer = (CnccqJmsProducer)cnccqJmsContext.createProducer(destination, false);
                }
                catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                    System.out.println("create connection fail:" + cnccqJmsRuntimeException.getMessage());
                    if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.CONNECT_FULL.getCode()) {
                        System.out.println("create connection fail:connect full");
                    } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.UNKNOWN_ERROR.getCode()) {
                        System.out.println("create connection fail:queueManager stop");
                    } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUEMANAGER_NOT_EXIST.getCode()) {
                        System.out.println("create connection fail:queManager not exists");
                    }
                    if (cnccqJmsProducer != null) {
                        cnccqJmsProducer.close();
                    }
                    cnccqJmsContext.close();
                    return;
                }
                catch (Exception e) {
                    System.out.println("create connection fail:" + e.getMessage());
                    if (cnccqJmsProducer != null) {
                        cnccqJmsProducer.close();
                    }
                    cnccqJmsContext.close();
                    return;
                }
                fileWriter = new FileWriter(logFilePath);
                int getTime = Integer.parseInt(args[5]);
                int getNum = Integer.parseInt(args[6]);
                boolean interval = false;
                byte[] msgInfo = this.readFileByLines(args[4]);
                startTime = System.nanoTime();
                boolean count = false;
                if (getTime != 0) {
                    int i = 0;
                    while (true) {
                        StringBuffer sb = new StringBuffer("\u7b2c" + (i + 1) + "\u6b21\uff1a");
                        boolean isSuccess = true;
                        long pkgWatch = System.nanoTime();
                        CnccqMessage cnccqMessage = new CnccqMessage();
                        ByteSequence byteSequence = new ByteSequence(msgInfo);
                        cnccqMessage.setContent(byteSequence);
                        int priorss = Integer.parseInt(args[7]);
                        cnccqMessage.setJMSPriority(priorss);
                        try {
                            cnccqJmsProducer.send((Destination)destination, cnccqMessage);
                        }
                        catch (CnccqJmsRuntimeException jmsRuntimeException) {
                            isSuccess = false;
                            if (Integer.valueOf(jmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUE_NOT_EXIST.getCode()) {
                                System.out.println("queue not exists");
                                sb.append("queue not exists");
                            }
                            sb.append("send message fail:" + jmsRuntimeException.getErrorCode());
                            sb.append("result:-1 errCode:" + jmsRuntimeException.getErrorCode());
                        }
                        catch (Exception e) {
                            isSuccess = false;
                            sb.append("send message fail");
                            sb.append("result:-1 errCode:-1");
                        }
                        if (isSuccess) {
                            try {
                                cnccqJmsProducer.commit();
                                sb.append("\u53d1\u9001\u6210\u529f");
                            }
                            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                                isSuccess = false;
                                sb.append("send message fail:" + cnccqJmsRuntimeException.getMessage());
                                sb.append("result:-1 errCode:" + cnccqJmsRuntimeException.getErrorCode());
                            }
                            catch (Exception e) {
                                isSuccess = false;
                                sb.append("send message fail");
                                sb.append("result:-1 errCode:-1");
                            }
                        }
                        sb.append("\n");
                        fileWriter.append(sb);
                        if ((System.nanoTime() - startTime) / 1000000000L < (long)getTime) {
                            Thread.sleep(sleepTime);
                            ++i;
                            continue;
                        }
                        break block41;
                        break;
                    }
                }
                if (getNum != 0) {
                    for (int i = 0; i < getNum; ++i) {
                        boolean isSuccess = true;
                        StringBuffer sb = new StringBuffer("\u7b2c" + (i + 1) + "\u6b21\uff1a");
                        long pkgWatch = System.nanoTime();
                        CnccqMessage cnccqMessage = new CnccqMessage();
                        ByteSequence byteSequence = new ByteSequence(msgInfo);
                        cnccqMessage.setContent(byteSequence);
                        int priorss = Integer.parseInt(args[7]);
                        cnccqMessage.setJMSPriority(priorss);
                        try {
                            cnccqJmsProducer.send((Destination)destination, cnccqMessage);
                        }
                        catch (CnccqJmsRuntimeException jmsRuntimeException) {
                            sb.append("send message fail:" + jmsRuntimeException.getErrorCode());
                            sb.append("result:-1 errCode:" + jmsRuntimeException.getErrorCode());
                            isSuccess = false;
                        }
                        catch (Exception e) {
                            sb.append("send message fail");
                            sb.append("result:-1 errCode:-1");
                            isSuccess = false;
                        }
                        if (isSuccess) {
                            try {
                                cnccqJmsProducer.commit();
                                sb.append("\u53d1\u9001\u6210\u529f");
                            }
                            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                                isSuccess = false;
                                sb.append("send message fail:" + cnccqJmsRuntimeException.getMessage());
                                sb.append("result:-1 errCode:" + cnccqJmsRuntimeException.getErrorCode());
                            }
                            catch (Exception e) {
                                isSuccess = false;
                                sb.append("send message fail");
                                sb.append("result:-1 errCode:-1");
                            }
                        }
                        sb.append("\n");
                        fileWriter.append(sb);
                        Thread.sleep(sleepTime);
                    }
                } else {
                    System.out.println("\u53d1\u9001\u65f6\u95f4\u548c\u6b21\u6570\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\uff0c\u53e6\u4e00\u4e2a\u8bbe\u7f6e\u4e3a0");
                }
            }
            System.out.printf("execution duration:%d s\n", (System.nanoTime() - startTime) / 1000000000L);
            fileWriter.close();
            cnccqJmsProducer.close();
            cnccqJmsContext.close();
            System.exit(-1);
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(-1);
        }
    }

    private void cnccqRecvMsgNotWrite(String[] args) {
        if (args.length < 4) {
            System.out.println("\u4f7f\u7528\u65b9\u6cd5:");
            System.out.println("cnccqRecvMsg qmName queName tcp://ip:port filePath num -wWaitname");
            System.out.println("\u5fc5\u586b\u53c2\u6570, \u9700\u6309\u987a\u5e8f\u586b\u5199:");
            System.out.println("qmName");
            System.out.println("queName");
            System.out.println("ip");
            System.out.println("port");
            System.out.println("\u9009\u586b\u53c2\u6570:");
            System.out.println("num, \u8be5\u53c2\u6570\u4e0d\u586b\u65f6\uff0c\u83b7\u53d6\u5168\u90e8\u6d88\u606f");
            return;
        }
        try {
            int msgNum;
            String qmName = args[0];
            String queName = args[1];
            String ip = args[2];
            int port = Integer.parseInt(args[3]);
            String fileName = "";
            int numTmp = -1;
            int waitTime = 0;
            boolean fileNameFlag = false;
            boolean closeFlag = false;
            if (args.length >= 5) {
                numTmp = Integer.parseInt(args[4]);
            }
            CnccqJmsConnectionPooledFactory connectionPooledFactory = null;
            try {
                connectionPooledFactory = new CnccqJmsConnectionPooledFactory(ip, port, qmName);
            }
            catch (Exception e) {
                System.out.println("ip address error");
                return;
            }
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxIdle(5);
            poolConfig.setMaxTotal(5);
            poolConfig.setMinIdle(5);
            poolConfig.setBlockWhenExhausted(true);
            poolConfig.setMaxWaitMillis(3000L);
            poolConfig.setTestOnCreate(false);
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            poolConfig.setTimeBetweenEvictionRunsMillis(1800000L);
            poolConfig.setTestWhileIdle(false);
            poolConfig.setJmxEnabled(false);
            GenericObjectPool<TcpConnection> genericObjectPool = new GenericObjectPool<TcpConnection>(connectionPooledFactory, poolConfig);
            CnccqJmsContext cnccqJmsContext = new CnccqJmsContext(qmName, genericObjectPool);
            CnccqDestination destination = new CnccqDestination(queName, qmName);
            CnccqJmsConsumer consumer = null;
            try {
                consumer = (CnccqJmsConsumer)cnccqJmsContext.createConsumer((Destination)destination, false);
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                System.out.println("create connection fail:" + cnccqJmsRuntimeException.getMessage());
                if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.CONNECT_FULL.getCode()) {
                    System.out.println("create connection fail:connect full");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.UNKNOWN_ERROR.getCode()) {
                    System.out.println("create connection fail:queueManager stop");
                } else if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() == CnccqResultEnum.QUEUEMANAGER_NOT_EXIST.getCode()) {
                    System.out.println("create connection fail:queManager not exists");
                }
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            catch (Exception e) {
                System.out.println("create connection fail:" + e.getMessage());
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            try {
                msgNum = consumer.getMessageCount(queName);
            }
            catch (CnccqJmsRuntimeException e) {
                System.out.println("get message num fail:" + e.getMessage());
                if (Integer.valueOf(e.getErrorCode()).intValue() == CnccqResultEnum.QUEUE_NOT_EXIST.getCode()) {
                    System.out.println("queue not exists");
                }
                if (consumer != null) {
                    consumer.close();
                }
                cnccqJmsContext.close();
                return;
            }
            if (msgNum > 0) {
                System.out.println("msg num:" + msgNum);
            } else if (msgNum == 0) {
                if (waitTime > 0) {
                    System.out.println("queue empty,wait put message...");
                } else {
                    System.out.println("queue empty message");
                    if (consumer != null) {
                        consumer.close();
                    }
                    cnccqJmsContext.close();
                    return;
                }
            }
            if (numTmp == -1) {
                numTmp = msgNum;
            }
            int i = 0;
            boolean errCount = false;
            for (i = 0; i < numTmp; ++i) {
                try {
                    CnccqMessage cnccqMessage = consumer.receive();
                    consumer.commit();
                    continue;
                }
                catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                    System.out.println("recv fail!errorCode:" + cnccqJmsRuntimeException.getMessage());
                    if (Integer.valueOf(cnccqJmsRuntimeException.getErrorCode()).intValue() != CnccqResultEnum.QUEUE_NOT_EXIST.getCode()) break;
                    System.out.println("queue not exists");
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            System.out.println("recv success!num:" + i);
            consumer.close();
            cnccqJmsContext.close();
            return;
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(-1);
            return;
        }
    }

    public static void main(String[] args) throws IOException {
        Date date = new Date();
        TestUtils utils = new TestUtils();
        utils.cnccqRecvMsg_notcommit(args);
        System.out.println(new Date().getTime() - date.getTime());
    }
}

