/*
 * Decompiled with CFR 0.152.
 */
package cn.cfit.cnccq.utils;

import cn.cfit.cnccq.netty.NettyMessage;
import cn.cfit.cnccq.utils.StringToBytesUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CnccqEncode
extends MessageToByteEncoder {
    protected void encode(ChannelHandlerContext channelHandlerContext, Object object, ByteBuf byteBuf) throws Exception {
        String[] dateStr;
        NettyMessage nettyMessage = (NettyMessage)object;
        if (nettyMessage == null) {
            return;
        }
        int bodyLength = 0;
        if (nettyMessage.getByteSequence() != null) {
            bodyLength = nettyMessage.getByteSequence().getLength();
        }
        UnpooledByteBufAllocator allocator = new UnpooledByteBufAllocator(false);
        ByteBuf producerByteBuf = allocator.heapBuffer(576 + bodyLength);
        producerByteBuf.order(ByteOrder.LITTLE_ENDIAN);
        producerByteBuf.writeInt(576);
        producerByteBuf.writeInt(nettyMessage.getCommand().getCode());
        byte[] sockfd = new byte[4];
        producerByteBuf.writeBytes(sockfd);
        byte[] pid = new byte[4];
        producerByteBuf.writeBytes(pid);
        byte[] svrToken = new byte[4];
        producerByteBuf.writeBytes(svrToken);
        byte[] svrId = new byte[4];
        producerByteBuf.writeBytes(svrId);
        producerByteBuf.writeInt(nettyMessage.getToken());
        byte[] waitTime = new byte[4];
        producerByteBuf.writeBytes(waitTime);
        byte[] queueMangerBytes = new byte[64];
        if (nettyMessage.getQueueManager() != null) {
            queueMangerBytes = StringToBytesUtils.stringToBytes(nettyMessage.getQueueManager(), 64);
        }
        producerByteBuf.writeBytes(queueMangerBytes);
        byte[] queueNameBytes = new byte[64];
        if (nettyMessage.getQueueName() != null) {
            queueNameBytes = StringToBytesUtils.stringToBytes(nettyMessage.getQueueName(), 64);
        }
        producerByteBuf.writeBytes(queueNameBytes);
        byte[] queueType = new byte[4];
        producerByteBuf.writeBytes(queueType);
        byte[] chanName = new byte[64];
        producerByteBuf.writeBytes(chanName);
        byte[] fromAddr = new byte[64];
        producerByteBuf.writeBytes(fromAddr);
        byte[] msgId = new byte[64];
        if (nettyMessage.getMsgId() != null) {
            msgId = StringToBytesUtils.stringToBytes(nettyMessage.getMsgId(), 64);
        }
        producerByteBuf.writeBytes(msgId);
        byte[] corelationId = new byte[64];
        producerByteBuf.writeBytes(corelationId);
        byte[] crc = new byte[4];
        producerByteBuf.writeBytes(crc);
        producerByteBuf.writeInt(nettyMessage.getPriority());
        byte[] persistant = new byte[4];
        producerByteBuf.writeBytes(persistant);
        byte[] transacted = new byte[4];
        producerByteBuf.writeBytes(transacted);
        byte[] tranId = new byte[4];
        producerByteBuf.writeBytes(tranId);
        producerByteBuf.writeInt(bodyLength);
        byte[] msgMaxSize = new byte[4];
        producerByteBuf.writeBytes(msgMaxSize);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String putDateStr = "";
        byte[] putDate = new byte[64];
        byte[] putTime = new byte[64];
        if (nettyMessage.getSendTime() == 0L) {
            putDateStr = formatter.format(new Date());
            if (putDateStr != null && (dateStr = putDateStr.split(" ")) != null && dateStr.length == 2) {
                putDate = StringToBytesUtils.stringToBytes(dateStr[0], 64);
                putTime = StringToBytesUtils.stringToBytes(dateStr[1], 64);
            }
        } else {
            putDateStr = formatter.format(nettyMessage.getSendTime());
            if (putDateStr != null && (dateStr = putDateStr.split(" ")) != null && dateStr.length == 2) {
                putDate = StringToBytesUtils.stringToBytes(dateStr[0], 64);
                putTime = StringToBytesUtils.stringToBytes(dateStr[1], 64);
            }
        }
        producerByteBuf.writeBytes(putDate);
        producerByteBuf.writeBytes(putTime);
        if (bodyLength > 0) {
            byte[] bodyBytes = nettyMessage.getByteSequence().getData();
            producerByteBuf.writeBytes(bodyBytes);
        }
        byteBuf.writeBytes(producerByteBuf);
        producerByteBuf.release();
    }
}

