/*
 * Decompiled with CFR 0.152.
 */
package cn.cfit.cnccq.utils;

import cn.cfit.cnccq.jms.ByteSequence;
import cn.cfit.cnccq.netty.NettyMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class CnccqDecoder
extends ByteToMessageDecoder {
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        Date date;
        SimpleDateFormat formatter;
        if (byteBuf.readableBytes() < 704) {
            return;
        }
        int bodyLength = byteBuf.getInt(696);
        if (byteBuf.readableBytes() < 704 + bodyLength) {
            return;
        }
        int readLength = byteBuf.readableBytes();
        byte[] unknowData_1 = new byte[16];
        byteBuf.readBytes(unknowData_1);
        int actOut = byteBuf.readInt();
        int errorcode = byteBuf.readInt();
        int token = byteBuf.readInt();
        byte[] queueBytes = new byte[64];
        byteBuf.readBytes(queueBytes);
        String queue = new String(queueBytes, StandardCharsets.UTF_8);
        byte[] unknowData_2 = new byte[196];
        byteBuf.readBytes(unknowData_2);
        int msgNum = byteBuf.readInt();
        byte[] msgIdBytes = new byte[64];
        byteBuf.readBytes(msgIdBytes);
        String msgId = new String(msgIdBytes, StandardCharsets.UTF_8);
        byte[] cmsgIdBytes = new byte[64];
        byteBuf.readBytes(cmsgIdBytes);
        String cmsgId = new String(cmsgIdBytes, StandardCharsets.UTF_8);
        byte[] unknowData_3 = new byte[4];
        byteBuf.readBytes(unknowData_3);
        int priority = byteBuf.readInt();
        byte[] sendDateBytes = new byte[64];
        byteBuf.readBytes(sendDateBytes);
        String sendDate = new String(sendDateBytes, StandardCharsets.UTF_8);
        byte[] sendTimeBytes = new byte[64];
        byteBuf.readBytes(sendTimeBytes);
        String sendTime = new String(sendTimeBytes, StandardCharsets.UTF_8);
        byte[] transDateBytes = new byte[64];
        byteBuf.readBytes(transDateBytes);
        String transDate = new String(transDateBytes, StandardCharsets.UTF_8);
        byte[] transTimeBytes = new byte[64];
        byteBuf.readBytes(transTimeBytes);
        String transTime = new String(transTimeBytes, StandardCharsets.UTF_8);
        byte[] unknowData_4 = new byte[12];
        byteBuf.readBytes(unknowData_4);
        int length = byteBuf.readInt();
        byte[] unknowData_5 = new byte[4];
        byteBuf.readBytes(unknowData_5);
        byte[] bodyBytes = new byte[bodyLength];
        byteBuf.readBytes(bodyBytes);
        NettyMessage nettyMessage = new NettyMessage();
        nettyMessage.setMsgId(msgId);
        nettyMessage.setCmsgId(cmsgId);
        nettyMessage.setPriority(priority);
        if (transDate != null && !transDate.trim().isEmpty()) {
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String transTimeStr = transDate + " " + transTime.substring(0, 8);
            date = formatter.parse(transTimeStr);
            nettyMessage.setTransTime(date.getTime());
        }
        if (sendDate != null && !sendDate.trim().isEmpty()) {
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String sendTimeStr = sendDate.trim() + " " + sendTime.trim().substring(0, 8);
            date = formatter.parse(sendTimeStr);
            nettyMessage.setSendTime(date.getTime());
        }
        ByteSequence byteSequence = new ByteSequence(bodyBytes);
        nettyMessage.setByteSequence(byteSequence);
        nettyMessage.setMsgLength(byteSequence.length);
        nettyMessage.setActCode(actOut);
        nettyMessage.setErrorCode(errorcode);
        nettyMessage.setToken(token);
        nettyMessage.setMsgNum(msgNum);
        list.add(nettyMessage);
        byteBuf.clear();
    }
}

