/*
 * Decompiled with CFR 0.152.
 */
package cn.cfit.cnccq.pool;

import cn.cfit.cnccq.jms.CnccqJmsContext;
import cn.cfit.cnccq.netty.NettyClient;
import cn.cfit.cnccq.netty.TcpConnection;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import org.apache.commons.pool2.DestroyMode;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import sun.net.util.IPAddressUtil;

public class CnccqJmsConnectionPooledFactory
implements PooledObjectFactory<TcpConnection>,
ConnectionFactory {
    private final String ip;
    private final int port;
    private String queueManager;

    @Override
    public CnccqJmsContext createContext() {
        return null;
    }

    public CnccqJmsContext createContext(GenericObjectPool<TcpConnection> connectPool) {
        CnccqJmsContext context = new CnccqJmsContext(this.queueManager, connectPool);
        return context;
    }

    public CnccqJmsConnectionPooledFactory(String ip, int port, String queueManager) {
        if (!IPAddressUtil.isIPv4LiteralAddress(ip)) {
            throw new JMSRuntimeException("IP Format Error");
        }
        this.ip = ip;
        this.port = port;
        this.queueManager = queueManager;
    }

    @Override
    public void activateObject(PooledObject<TcpConnection> p) throws Exception {
    }

    @Override
    public void destroyObject(PooledObject<TcpConnection> p) throws Exception {
        p.getObject().release();
    }

    @Override
    public void destroyObject(PooledObject<TcpConnection> p, DestroyMode destroyMode) throws Exception {
        p.getObject().release();
    }

    @Override
    public PooledObject<TcpConnection> makeObject() throws Exception {
        NettyClient connection = NettyClient.getInstance(this.ip, this.port, this.queueManager);
        connection.start();
        return new DefaultPooledObject<TcpConnection>(connection);
    }

    @Override
    public void passivateObject(PooledObject<TcpConnection> p) throws Exception {
    }

    @Override
    public boolean validateObject(PooledObject<TcpConnection> p) {
        return true;
    }

    public static void main(String[] args) throws Exception {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(5);
        poolConfig.setMaxTotal(20);
        poolConfig.setMinIdle(2);
        poolConfig.setBlockWhenExhausted(true);
        poolConfig.setMaxWaitMillis(3000L);
        poolConfig.setTestOnCreate(false);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        poolConfig.setTimeBetweenEvictionRunsMillis(1800000L);
        poolConfig.setTestWhileIdle(false);
        poolConfig.setJmxEnabled(false);
        CnccqJmsConnectionPooledFactory objectFactory = new CnccqJmsConnectionPooledFactory("", 2003, "");
        GenericObjectPool<TcpConnection> objectPool = new GenericObjectPool<TcpConnection>(objectFactory, poolConfig);
        TcpConnection connection = objectPool.borrowObject();
    }

    @Override
    public Connection createConnection() throws JMSException {
        return null;
    }

    @Override
    public Connection createConnection(String userName, String password) throws JMSException {
        return null;
    }

    @Override
    public JMSContext createContext(String userName, String password) {
        return null;
    }

    @Override
    public JMSContext createContext(String userName, String password, int sessionMode) {
        return null;
    }

    @Override
    public JMSContext createContext(int sessionMode) {
        return null;
    }
}

