/*
 * Decompiled with CFR 0.152.
 */
package cn.cfit.cnccq.netty;

import cn.cfit.cnccq.exceptions.CnccqJmsRuntimeException;
import cn.cfit.cnccq.logging.Log;
import cn.cfit.cnccq.logging.LogFactory;
import cn.cfit.cnccq.netty.NettyClient;
import cn.cfit.cnccq.netty.NettyMessage;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class NettyClientHandler
extends ChannelInboundHandlerAdapter {
    private final Log log = LogFactory.getLog(NettyClientHandler.class);
    private LinkedBlockingDeque<NettyMessage> resultDeque = new LinkedBlockingDeque();
    private NettyClient nettyClient;

    public NettyClientHandler(NettyClient nettyClient) {
        this.nettyClient = nettyClient;
    }

    public synchronized NettyMessage sendMessage(NettyMessage message, Channel channel) {
        channel.writeAndFlush(message);
        NettyMessage res = null;
        try {
            res = this.resultDeque.poll(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.log.info(e.getMessage());
            throw new CnccqJmsRuntimeException(e.getMessage());
        }
        finally {
            if (res == null) {
                this.log.info("[INFO] Return Timeout");
                throw new CnccqJmsRuntimeException("Return Timeout");
            }
        }
        return res;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        NettyMessage message = null;
        if (msg instanceof NettyMessage) {
            message = (NettyMessage)msg;
        }
        if (message == null) {
            this.log.info("[INFO] Receive Null Message");
            return;
        }
        this.resultDeque.add(message);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        boolean active = ctx.channel().isActive();
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
    }
}

