/*
 * Decompiled with CFR 0.152.
 */
package cn.cfit.cnccq.netty;

import cn.cfit.cnccq.commons.CnccqCommandEnum;
import cn.cfit.cnccq.commons.CnccqResultEnum;
import cn.cfit.cnccq.exceptions.CnccqJmsRuntimeException;
import cn.cfit.cnccq.jms.CnccqDestination;
import cn.cfit.cnccq.jms.CnccqMessage;
import cn.cfit.cnccq.jms.CnccqResult;
import cn.cfit.cnccq.logging.Log;
import cn.cfit.cnccq.logging.LogFactory;
import cn.cfit.cnccq.netty.NettyClientHandler;
import cn.cfit.cnccq.netty.NettyClientInitiallizer;
import cn.cfit.cnccq.netty.NettyMessage;
import cn.cfit.cnccq.netty.TcpConnection;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class NettyClient
implements TcpConnection {
    private static final Log log = LogFactory.getLog(NettyClient.class);
    private EventLoopGroup group;
    private Bootstrap bootstrap;
    private static final int maxRetry = 5;
    private static final int maxRetryTime = 60;
    private String ip;
    private int port;
    private int retryNum = 0;
    private Channel channel;
    private int token;
    private String queueManager;
    private boolean isClose;
    private ScheduledExecutorService scheduledExecutorService;

    public static NettyClient getInstance(String ip, int port, String queueManager) {
        try {
            Bootstrap bootstrap = new Bootstrap();
            NioEventLoopGroup group = new NioEventLoopGroup(1);
            NettyClient client = new NettyClient(ip, port, queueManager, bootstrap, group);
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.RCVBUF_ALLOCATOR, new AdaptiveRecvByteBufAllocator(2048, 10240, 0x100000))).handler(new NettyClientInitiallizer(client));
            return client;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new CnccqJmsRuntimeException("Connect Fail", String.valueOf(CnccqResultEnum.UNKNOWN_ERROR.getCode()));
        }
    }

    private NettyClient(String ip, int port, String queueManager, Bootstrap bootstrap, EventLoopGroup group) {
        this.ip = ip;
        this.port = port;
        this.queueManager = queueManager;
        this.bootstrap = bootstrap;
        this.group = group;
    }

    @Override
    public void start() {
        this.doConnect();
    }

    public void doConnect() {
        this.channel = null;
        try {
            ChannelFuture future = this.bootstrap.connect(this.ip, this.port).sync();
            this.channel = future.channel();
            this.createSession();
            this.retryNum = 0;
            this.sendHeart();
            log.info("[INFO] Connect Success");
        }
        catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
            log.info("[INFO] Failed to connect to server. Will retry..." + cnccqJmsRuntimeException.getMessage());
            if (this.retryNum < 5) {
                ++this.retryNum;
                this.doConnect();
            }
            this.group.shutdownGracefully();
            throw new CnccqJmsRuntimeException(cnccqJmsRuntimeException.getMessage(), cnccqJmsRuntimeException.getErrorCode());
        }
        catch (Exception e) {
            log.info("[INFO] Failed to connect to server. Will retry..." + e.getMessage());
            if (this.retryNum < 5) {
                ++this.retryNum;
                this.doConnect();
            }
            this.group.shutdownGracefully();
            throw new CnccqJmsRuntimeException("Connect Fail", String.valueOf(CnccqResultEnum.UNKNOWN_ERROR.getCode()));
        }
    }

    public void reConnect() {
        if (this.isClose) {
            return;
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
        this.channel = null;
        ChannelFuture channelFuture = this.bootstrap.connect(this.ip, this.port);
        channelFuture.addListener(future -> {
            Throwable cause = future.cause();
            if (cause != null) {
                log.info("[INFO] Failed to reConnect to server. Will retry..." + cause.getMessage());
                channelFuture.channel().eventLoop().schedule(this::reConnect, 5L, TimeUnit.SECONDS);
            } else {
                this.channel = future.channel();
                this.reCreateSession();
            }
        });
    }

    private void createSession() {
        CnccqDestination cnccqDestination = new CnccqDestination(null, this.queueManager);
        CnccqResult cnccqConnectResult = this.sendCmd(CnccqCommandEnum.CONNECT_SERVER, cnccqDestination);
        if (cnccqConnectResult.getCode() != CnccqResultEnum.SUCCESS.getCode()) {
            throw new CnccqJmsRuntimeException("Connect Server Fail, ErrorCode" + cnccqConnectResult.getCode(), String.valueOf(cnccqConnectResult.getCode()));
        }
        CnccqResult cnccqSessionResult = this.sendCmd(CnccqCommandEnum.CREATE_SESSION, cnccqDestination);
        if (cnccqSessionResult.getCode() != CnccqResultEnum.SUCCESS.getCode()) {
            throw new CnccqJmsRuntimeException("Create Session Fail, ErrorCode" + cnccqSessionResult.getCode(), String.valueOf(cnccqConnectResult.getCode()));
        }
    }

    private void reCreateSession() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    CnccqDestination cnccqDestination = new CnccqDestination(null, NettyClient.this.queueManager);
                    CnccqResult cnccqConnectResult = NettyClient.this.sendCmd(CnccqCommandEnum.CONNECT_SERVER, cnccqDestination);
                    if (cnccqConnectResult.getCode() != CnccqResultEnum.SUCCESS.getCode()) {
                        log.error("[ERROR] Connect Server Fail, ErrorCode" + cnccqConnectResult.getCode());
                        throw new CnccqJmsRuntimeException("Connect Server Fail, ErrorCode" + cnccqConnectResult.getCode(), String.valueOf(cnccqConnectResult.getCode()));
                    }
                    CnccqResult cnccqSessionResult = NettyClient.this.sendCmd(CnccqCommandEnum.CREATE_SESSION, cnccqDestination);
                    if (cnccqSessionResult.getCode() != CnccqResultEnum.SUCCESS.getCode()) {
                        log.error("[ERROR] Create Session Fail, ErrorCode" + cnccqSessionResult.getCode());
                        throw new CnccqJmsRuntimeException("Create Session Fail, ErrorCode" + cnccqSessionResult.getCode(), String.valueOf(cnccqConnectResult.getCode()));
                    }
                    NettyClient.this.retryNum = 0;
                    NettyClient.this.sendHeart();
                    log.info("[INFO] ReConnect Success");
                }
                catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                    log.error("[ERROR] Connect Server Fail,Will try..." + cnccqJmsRuntimeException.getMessage());
                    NettyClient.this.reConnect();
                }
                catch (Exception e) {
                    log.error("[ERROR] Connect Server Fail,Will try..." + e.getMessage());
                    NettyClient.this.reConnect();
                }
            }
        };
        this.scheduledExecutorService.schedule(task, 0L, TimeUnit.SECONDS);
    }

    public void sendHeart() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    CnccqDestination cnccqDestination = new CnccqDestination(null, NettyClient.this.queueManager);
                    NettyClient.this.sendCmd(CnccqCommandEnum.GET_MESSAGE_NUMBER, cnccqDestination);
                }
                catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                    log.error("[ERROR] Send Heartbeat Fail,Will try..." + cnccqJmsRuntimeException.getMessage());
                    NettyClient.this.reConnect();
                }
                catch (Exception e) {
                    log.error("[ERROR] Send Heartbeat Fail,Will try..." + e.getMessage());
                    NettyClient.this.reConnect();
                }
            }
        };
        this.scheduledExecutorService.scheduleAtFixedRate(task, 0L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public CnccqResult sendCmd(CnccqCommandEnum command, CnccqDestination cnccqDestination) {
        try {
            this.check();
            NettyMessage nettyMessage = new NettyMessage(command, cnccqDestination.getQueueManager(), cnccqDestination.getQueueName(), this.token, "");
            NettyClientHandler nettyClientHandler = this.channel.pipeline().get(NettyClientHandler.class);
            ChannelId id = this.channel.id();
            NettyMessage nettyReturnMessage = nettyClientHandler.sendMessage(nettyMessage, this.channel);
            this.token = nettyReturnMessage.getToken();
            if (nettyReturnMessage.getActCode() == 0) {
                return new CnccqResult<Object>(nettyReturnMessage.getActCode(), null);
            }
            return CnccqResult.fail(nettyReturnMessage.getErrorCode());
        }
        catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
            log.error(cnccqJmsRuntimeException.getMessage());
            throw cnccqJmsRuntimeException;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new CnccqJmsRuntimeException(e.getMessage());
        }
    }

    @Override
    public CnccqResult sendMessage(CnccqDestination cnccqDestination, CnccqMessage message) {
        try {
            this.check();
            NettyClientHandler nettyClientHandler = this.channel.pipeline().get(NettyClientHandler.class);
            ChannelId id = this.channel.id();
            NettyMessage nettyMessage = new NettyMessage(CnccqCommandEnum.SEND_MESSAGE, cnccqDestination.getQueueManager(), cnccqDestination.getQueueName(), this.token, message.getJMSPriority(), message.getJMSMessageID(), message.getContent());
            nettyMessage.setSendTime(message.getJMSDeliveryTime());
            NettyMessage nettyReturnMessage = nettyClientHandler.sendMessage(nettyMessage, this.channel);
            this.token = nettyReturnMessage.getToken();
            if (nettyReturnMessage.getActCode() == 0) {
                return new CnccqResult<Object>(nettyReturnMessage.getActCode(), null);
            }
            return CnccqResult.fail(nettyReturnMessage.getErrorCode());
        }
        catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
            throw cnccqJmsRuntimeException;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new CnccqJmsRuntimeException(e.getMessage());
        }
    }

    @Override
    public CnccqResult<CnccqMessage> receiveMessage(CnccqDestination destination) {
        try {
            this.check();
            log.info("[INFO] Acquire Channel id in channel pool is " + this.channel.id());
            NettyClientHandler nettyClientHandler = this.channel.pipeline().get(NettyClientHandler.class);
            ChannelId id = this.channel.id();
            NettyMessage nettyMessage = new NettyMessage(CnccqCommandEnum.RECEIVE_MESSAGE, destination.getQueueManager(), destination.getQueueName(), this.token, "");
            log.info("[INFO] Receive Message and Channel id " + id);
            NettyMessage nettyReturnMessage = nettyClientHandler.sendMessage(nettyMessage, this.channel);
            this.token = nettyReturnMessage.getToken();
            log.info("[INFO] Receive Message and Channel: " + this.channel.id() + " Receive Code \uff1a" + nettyReturnMessage.getActCode());
            if (nettyReturnMessage.getActCode() == 0) {
                CnccqMessage cnccqMessage = new CnccqMessage();
                cnccqMessage.setJMSMessageID(nettyReturnMessage.getMsgId());
                cnccqMessage.setJMSCorrelationID(nettyReturnMessage.getCmsgId());
                cnccqMessage.setJMSPriority(nettyReturnMessage.getPriority());
                cnccqMessage.setJMSTimestamp(Objects.nonNull(nettyReturnMessage.getTransTime()) ? nettyReturnMessage.getTransTime() : -1L);
                cnccqMessage.setJMSDeliveryTime(Objects.nonNull(nettyReturnMessage.getSendTime()) ? nettyReturnMessage.getSendTime() : -1L);
                cnccqMessage.setContent(nettyReturnMessage.getByteSequence());
                return new CnccqResult<CnccqMessage>(0, cnccqMessage);
            }
            if (nettyReturnMessage.getActCode() == 12) {
                return new CnccqResult<Object>(0, null);
            }
            return CnccqResult.fail(nettyReturnMessage.getActCode());
        }
        catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
            throw cnccqJmsRuntimeException;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new CnccqJmsRuntimeException(e.getMessage());
        }
    }

    @Override
    public CnccqResult<Integer> getMessageNumber(CnccqDestination destination) {
        try {
            this.check();
            log.info("[INFO] Acquire Channel id in channel pool is " + this.channel.id());
            NettyClientHandler nettyClientHandler = this.channel.pipeline().get(NettyClientHandler.class);
            ChannelId id = this.channel.id();
            NettyMessage nettyMessage = new NettyMessage(CnccqCommandEnum.GET_MESSAGE_NUMBER, destination.getQueueManager(), destination.getQueueName(), this.token, "");
            log.info("[INFO] Get Message Number and Channel id " + id);
            NettyMessage nettyReturnMessage = nettyClientHandler.sendMessage(nettyMessage, this.channel);
            this.token = nettyReturnMessage.getToken();
            log.info("[INFO] Get Message Number and Channel: " + this.channel.id() + "Receive Code \uff1a" + nettyReturnMessage.getActCode());
            if (nettyReturnMessage.getActCode() == 0) {
                return new CnccqResult<Integer>(0, nettyReturnMessage.getMsgNum());
            }
            return CnccqResult.fail(nettyReturnMessage.getErrorCode());
        }
        catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
            throw cnccqJmsRuntimeException;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new CnccqJmsRuntimeException(e.getMessage());
        }
    }

    @Override
    public void release() {
        this.isClose = true;
        if (this.channel != null) {
            this.channel.close().awaitUninterruptibly();
        }
        this.group.shutdownGracefully();
        this.channel = null;
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
        log.info("[INFO] Release Channel Success");
    }

    public Channel getChannel() {
        return this.channel;
    }

    private void check() {
        if (this.channel == null) {
            throw new CnccqJmsRuntimeException(CnccqResultEnum.NOT_CONNECT_QUEUEMANAGER.getDesc(), String.valueOf(CnccqResultEnum.NOT_CONNECT_QUEUEMANAGER.getCode()));
        }
    }
}

