/*
 * Decompiled with CFR 0.152.
 */
package cn.cfit.cnccq.jms;

import cn.cfit.cnccq.jms.ByteSequence;
import cn.cfit.cnccq.jms.CnccqMessage;
import java.util.Objects;
import javax.jms.JMSException;
import javax.jms.TextMessage;

public class CnccqTextMessage
extends CnccqMessage
implements TextMessage {
    protected String text;

    public CnccqTextMessage(CnccqMessage message) {
        this.setJMSMessageID(message.getJMSMessageID());
        this.setJMSCorrelationID(message.getJMSCorrelationID());
        this.setContent(message.getContent());
        this.setJMSTimestamp(message.getJMSTimestamp());
        this.setJMSDeliveryTime(message.getJMSDeliveryTime());
        this.setJMSPriority(message.getJMSPriority());
        this.setText(new String(message.getContent().getData()));
    }

    public CnccqTextMessage(byte[] data) {
        this.setText(new String(data));
    }

    public CnccqTextMessage(String text) {
        this.setText(text);
    }

    @Override
    public void setText(String text) {
        this.text = text;
        if (Objects.nonNull(text)) {
            this.setContent(new ByteSequence(text.getBytes()));
        }
    }

    @Override
    public String getText() throws JMSException {
        return this.text;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    @Override
    public String toString() {
        return super.toString() + "-CnccqTextMessage{text='" + this.text + '\'' + '}';
    }
}

