/*
 * Decompiled with CFR 0.152.
 */
package cn.cfit.cnccq.jms;

import cn.cfit.cnccq.commons.CnccqCommandEnum;
import cn.cfit.cnccq.commons.CnccqResultEnum;
import cn.cfit.cnccq.commons.MessagePriorityEnum;
import cn.cfit.cnccq.exceptions.CnccqJmsRuntimeException;
import cn.cfit.cnccq.jms.CnccqDestination;
import cn.cfit.cnccq.jms.CnccqJmsContext;
import cn.cfit.cnccq.jms.CnccqMessage;
import cn.cfit.cnccq.jms.CnccqResult;
import cn.cfit.cnccq.jms.CnccqTextMessage;
import cn.cfit.cnccq.logging.Log;
import cn.cfit.cnccq.logging.LogFactory;
import cn.cfit.cnccq.netty.TcpConnection;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.Message;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class CnccqJmsProducer
implements JMSProducer {
    private static final Log log = LogFactory.getLog(CnccqJmsProducer.class);
    private final CnccqJmsContext context;
    private int result;
    private final boolean autoCommit;
    private final TcpConnection tcpConnection;
    private CnccqDestination destination;

    public CnccqJmsProducer(CnccqJmsContext context, TcpConnection tcpConnection, CnccqDestination cnccqDestination, boolean autoCommit) {
        this.context = context;
        this.tcpConnection = tcpConnection;
        this.autoCommit = autoCommit;
        this.destination = cnccqDestination;
    }

    public CnccqDestination createDestination(String queueName) {
        return this.context.createDestination(queueName);
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public CnccqDestination getDestination() {
        return this.destination;
    }

    public void setDestination(CnccqDestination destination) {
        this.destination = destination;
    }

    @Override
    public JMSProducer send(Destination destination, Message message) {
        log.info("CnccqJmsProducer  send message");
        try {
            CnccqResult result = null;
            result = this.autoCommit ? this.context.send((CnccqDestination)destination, (CnccqMessage)message) : this.context.sendNotCommit((CnccqDestination)destination, (CnccqMessage)message, this.tcpConnection);
            log.info("CnccqJmsProducer send message result:" + result);
            this.setResult(result.getCode());
        }
        catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
            this.context.rollback();
            throw cnccqJmsRuntimeException;
        }
        catch (Exception e) {
            this.context.rollback();
            throw new CnccqJmsRuntimeException(e.getMessage());
        }
        return this;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public JMSProducer send(Destination destination, String text) {
        return null;
    }

    public JMSProducer send(String text) throws JMSException {
        CnccqTextMessage textMessage = new CnccqTextMessage(text);
        textMessage.setJMSTimestamp(System.currentTimeMillis());
        textMessage.setJMSDeliveryTime(System.currentTimeMillis());
        textMessage.setJMSPriority(MessagePriorityEnum.MIDDLE.getValue());
        textMessage.setText(text);
        if (Objects.isNull(this.destination.getQueueName())) {
            throw new JMSException("\u9ed8\u8ba4\u961f\u5217\u540d\u4e3a\u7a7a");
        }
        return this.send((Destination)this.destination, textMessage);
    }

    public void commit() {
        if (Objects.nonNull(this.tcpConnection)) {
            CnccqResult resCommit = this.tcpConnection.sendCmd(CnccqCommandEnum.COMMIT, this.destination);
            log.info("#CnccqJmsProudcer# receive message commit:" + resCommit);
            if (!resCommit.isSuccess()) {
                log.error("#CnccqJmsProudcer# send commit fail actCode:" + resCommit.getCode());
                throw new CnccqJmsRuntimeException("CnccqJmsProudcer# send commit fail actCode:" + resCommit.getCode(), String.valueOf(resCommit.getCode()));
            }
        }
    }

    public void rollback() {
        CnccqResult resRollBack;
        if (Objects.nonNull(this.tcpConnection) && !(resRollBack = this.tcpConnection.sendCmd(CnccqCommandEnum.ROLLBACK, this.destination)).isSuccess()) {
            log.error("#CnccqJmsProudcer# send rollback fail actCode:" + resRollBack.getCode());
            throw new CnccqJmsRuntimeException("CnccqJmsProudcer# send rollback fail actCode:" + resRollBack.getCode(), String.valueOf(resRollBack.getCode()));
        }
    }

    public int getMessageCount(String queueName) {
        if (this.autoCommit) {
            TcpConnection connectionAuto = null;
            GenericObjectPool<TcpConnection> connectPool = this.context.getConnectPool();
            try {
                connectionAuto = connectPool.borrowObject();
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                log.info("CnccqJmsProudcer# getMessageCount fail:" + cnccqJmsRuntimeException.getMessage() + ", ErrorCode:" + cnccqJmsRuntimeException.getErrorCode());
                throw new CnccqJmsRuntimeException("CnccqJmsProudcer# getMessageCount fail:" + cnccqJmsRuntimeException.getMessage(), cnccqJmsRuntimeException.getErrorCode());
            }
            catch (Exception e) {
                log.info("CnccqJmsProudcer# getMessageCount fail:" + e + ", ErrorCode:" + CnccqResultEnum.UNKNOWN_ERROR.getCode());
                throw new CnccqJmsRuntimeException("CnccqJmsProudcer# getMessageCount fail:" + e.getMessage(), String.valueOf(CnccqResultEnum.UNKNOWN_ERROR.getCode()));
            }
            CnccqDestination cnccqDestination = new CnccqDestination(queueName, this.destination.getQueueManager());
            CnccqResult<Integer> result = connectionAuto.getMessageNumber(cnccqDestination);
            if (connectionAuto != null) {
                connectPool.returnObject(connectionAuto);
            }
            if (result.isSuccess()) {
                return result.getData();
            }
            throw new CnccqJmsRuntimeException("get message num fail\uff1aack" + result.getCode(), String.valueOf(result.getCode()));
        }
        CnccqDestination cnccqDestination = new CnccqDestination(queueName, this.destination.getQueueManager());
        CnccqResult<Integer> result = this.tcpConnection.getMessageNumber(cnccqDestination);
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new CnccqJmsRuntimeException("get message num fail\uff1aack" + result.getCode(), String.valueOf(result.getCode()));
    }

    @Override
    public JMSProducer send(Destination destination, Map<String, Object> map) {
        return null;
    }

    public void close() {
        if (this.tcpConnection != null) {
            this.tcpConnection.release();
        }
    }

    @Override
    public JMSProducer send(Destination destination, byte[] bytes) {
        return null;
    }

    @Override
    public JMSProducer send(Destination destination, Serializable serializable) {
        return null;
    }

    @Override
    public JMSProducer setDisableMessageID(boolean b) {
        return null;
    }

    @Override
    public boolean getDisableMessageID() {
        return false;
    }

    @Override
    public JMSProducer setDisableMessageTimestamp(boolean b) {
        return null;
    }

    @Override
    public boolean getDisableMessageTimestamp() {
        return false;
    }

    @Override
    public JMSProducer setDeliveryMode(int i) {
        return null;
    }

    @Override
    public int getDeliveryMode() {
        return 0;
    }

    @Override
    public JMSProducer setPriority(int i) {
        return null;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public JMSProducer setTimeToLive(long l) {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public JMSProducer setDeliveryDelay(long l) {
        return null;
    }

    @Override
    public long getDeliveryDelay() {
        return 0L;
    }

    @Override
    public JMSProducer setAsync(CompletionListener completionListener) {
        return null;
    }

    @Override
    public CompletionListener getAsync() {
        return null;
    }

    @Override
    public JMSProducer setProperty(String s, boolean b) {
        return null;
    }

    @Override
    public JMSProducer setProperty(String s, byte b) {
        return null;
    }

    @Override
    public JMSProducer setProperty(String s, short i) {
        return null;
    }

    @Override
    public JMSProducer setProperty(String s, int i) {
        return null;
    }

    @Override
    public JMSProducer setProperty(String s, long l) {
        return null;
    }

    @Override
    public JMSProducer setProperty(String s, float v) {
        return null;
    }

    @Override
    public JMSProducer setProperty(String s, double v) {
        return null;
    }

    @Override
    public JMSProducer setProperty(String s, String s1) {
        return null;
    }

    @Override
    public JMSProducer setProperty(String s, Object o) {
        return null;
    }

    @Override
    public JMSProducer clearProperties() {
        return null;
    }

    @Override
    public boolean propertyExists(String s) {
        return false;
    }

    @Override
    public boolean getBooleanProperty(String s) {
        return false;
    }

    @Override
    public byte getByteProperty(String s) {
        return 0;
    }

    @Override
    public short getShortProperty(String s) {
        return 0;
    }

    @Override
    public int getIntProperty(String s) {
        return 0;
    }

    @Override
    public long getLongProperty(String s) {
        return 0L;
    }

    @Override
    public float getFloatProperty(String s) {
        return 0.0f;
    }

    @Override
    public double getDoubleProperty(String s) {
        return 0.0;
    }

    @Override
    public String getStringProperty(String s) {
        return null;
    }

    @Override
    public Object getObjectProperty(String s) {
        return null;
    }

    @Override
    public Set<String> getPropertyNames() {
        return null;
    }

    @Override
    public JMSProducer setJMSCorrelationIDAsBytes(byte[] bytes) {
        return null;
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() {
        return new byte[0];
    }

    @Override
    public JMSProducer setJMSCorrelationID(String s) {
        return null;
    }

    @Override
    public String getJMSCorrelationID() {
        return null;
    }

    @Override
    public JMSProducer setJMSType(String s) {
        return null;
    }

    @Override
    public String getJMSType() {
        return null;
    }

    @Override
    public JMSProducer setJMSReplyTo(Destination destination) {
        return null;
    }

    @Override
    public Destination getJMSReplyTo() {
        return null;
    }
}

