/*
 * Decompiled with CFR 0.152.
 */
package cn.cfit.cnccq.jms;

import cn.cfit.cnccq.commons.CnccqCommandEnum;
import cn.cfit.cnccq.commons.CnccqResultEnum;
import cn.cfit.cnccq.exceptions.CnccqJmsRuntimeException;
import cn.cfit.cnccq.jms.CnccqDestination;
import cn.cfit.cnccq.jms.CnccqJmsConsumer;
import cn.cfit.cnccq.jms.CnccqJmsProducer;
import cn.cfit.cnccq.jms.CnccqMessage;
import cn.cfit.cnccq.jms.CnccqResult;
import cn.cfit.cnccq.jms.CnccqTextMessage;
import cn.cfit.cnccq.logging.Log;
import cn.cfit.cnccq.logging.LogFactory;
import cn.cfit.cnccq.netty.TcpConnection;
import java.io.Serializable;
import java.util.Objects;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class CnccqJmsContext
implements JMSContext {
    private static final Log log = LogFactory.getLog(CnccqJmsContext.class);
    private GenericObjectPool<TcpConnection> connectPool;
    private String queueManager;
    private CnccqDestination destination;
    ThreadLocal<TcpConnection> connectionLocal = new ThreadLocal();

    public GenericObjectPool<TcpConnection> getConnectPool() {
        return this.connectPool;
    }

    public CnccqJmsContext(String queueManager, GenericObjectPool<TcpConnection> connectPool) {
        this.connectPool = connectPool;
        this.queueManager = queueManager;
        this.destination = new CnccqDestination(null, queueManager);
    }

    @Override
    public JMSProducer createProducer() {
        return new CnccqJmsProducer(this, null, null, true);
    }

    public JMSProducer createProducer(CnccqDestination destination, boolean autoCommit) {
        TcpConnection connection = null;
        if (!autoCommit) {
            try {
                connection = this.connectPool.borrowObject();
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                log.info("CnccqJmsContext# create producer fail:" + cnccqJmsRuntimeException.getMessage() + ", ErrorCode:" + cnccqJmsRuntimeException.getErrorCode());
                throw new CnccqJmsRuntimeException("CnccqJmsContext# create producer fail:" + cnccqJmsRuntimeException.getMessage(), cnccqJmsRuntimeException.getErrorCode());
            }
            catch (Exception e) {
                log.info("CnccqJmsContext# create producer fail:" + e + ", ErrorCode:" + CnccqResultEnum.UNKNOWN_ERROR.getCode());
                throw new CnccqJmsRuntimeException("CnccqJmsContext# create producer fail:" + e.getMessage(), String.valueOf(CnccqResultEnum.UNKNOWN_ERROR.getCode()));
            }
        }
        return new CnccqJmsProducer(this, connection, destination, autoCommit);
    }

    @Override
    public JMSContext createContext(int i) {
        return this;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void setAutoStart(boolean b) {
    }

    @Override
    public boolean getAutoStart() {
        return false;
    }

    @Override
    public void close() {
        this.connectPool.close();
    }

    public CnccqDestination createDestination(String queueName) {
        return new CnccqDestination(queueName, this.queueManager);
    }

    public CnccqMessage receive(CnccqDestination destination) {
        TcpConnection connection = null;
        try {
            connection = this.connectPool.borrowObject();
            CnccqResult resCreateQueueCon = connection.sendCmd(CnccqCommandEnum.CREATE_QUEUE_CONNECTION, destination);
            if (!resCreateQueueCon.isSuccess()) {
                log.error("#CnccqJmsContext-consumer# create queue connect fail actCode:" + resCreateQueueCon.getCode());
                throw new CnccqJmsRuntimeException("#CnccqJmsContext-consumer# create queue connect fail actCode: " + resCreateQueueCon.getCode(), String.valueOf(resCreateQueueCon.getCode()));
            }
            CnccqResult<CnccqMessage> message = connection.receiveMessage(destination);
            if (!message.isSuccess()) {
                log.error("#CnccqJmsContext-consumer# receive message fail actCode:" + message.getCode());
                throw new CnccqJmsRuntimeException("#CnccqJmsContext-consumer# receive message fail actCode: " + message.getCode(), String.valueOf(message.getCode()));
            }
            CnccqResult resCommit = connection.sendCmd(CnccqCommandEnum.COMMIT, destination);
            if (!resCommit.isSuccess()) {
                log.error("#CnccqJmsContext-consumer# commit message fail actCode:" + resCommit.getCode());
                throw new CnccqJmsRuntimeException("#CnccqJmsContext-consumer# commit message fail actCode: " + resCommit.getCode(), String.valueOf(resCommit.getCode()));
            }
            CnccqMessage cnccqMessage = message.getData();
            return cnccqMessage;
        }
        catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
            log.error("CnccqJmsContext-consumer.receive message fail: " + cnccqJmsRuntimeException.getMessage() + ", ErrorCode:" + cnccqJmsRuntimeException.getErrorCode());
            throw new CnccqJmsRuntimeException("#CnccqJmsContext-consumer# receive message fail:" + cnccqJmsRuntimeException.getMessage(), cnccqJmsRuntimeException.getErrorCode());
        }
        catch (Exception e) {
            log.error("CnccqJmsConsumer-consumer.receive error " + e + ", ErrorCode:" + CnccqResultEnum.UNKNOWN_ERROR.getCode());
            throw new CnccqJmsRuntimeException("#CnccqJmsContext-consumer# receive message error:" + e.getMessage(), String.valueOf(CnccqResultEnum.UNKNOWN_ERROR.getCode()));
        }
        finally {
            if (connection != null) {
                this.connectPool.returnObject(connection);
            }
        }
    }

    public CnccqMessage receiveNotCommit(CnccqDestination destination, TcpConnection connection) {
        try {
            CnccqResult resCreateQueueCon = connection.sendCmd(CnccqCommandEnum.CREATE_QUEUE_CONNECTION, destination);
            if (!resCreateQueueCon.isSuccess()) {
                log.error("#CnccqJmsContext-consumer# create queue connect fail actCode:" + resCreateQueueCon.getCode());
                throw new CnccqJmsRuntimeException("#CnccqJmsContext-consumer# create queue connect fail actCode: " + resCreateQueueCon.getCode(), String.valueOf(resCreateQueueCon.getCode()));
            }
            CnccqResult<CnccqMessage> message = connection.receiveMessage(destination);
            if (!message.isSuccess()) {
                log.error("#CnccqJmsContext-consumer# receive message fail actCode:" + message.getCode());
                throw new CnccqJmsRuntimeException("#CnccqJmsContext-consumer# receive message fail actCode: " + message.getCode(), String.valueOf(message.getCode()));
            }
            return message.getData();
        }
        catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
            log.error("CnccqJmsContext-consumer.receive message fail: " + cnccqJmsRuntimeException.getMessage() + ", ErrorCode:" + cnccqJmsRuntimeException.getErrorCode());
            throw new CnccqJmsRuntimeException("#CnccqJmsContext-consumer# receive message fail:" + cnccqJmsRuntimeException.getMessage(), cnccqJmsRuntimeException.getErrorCode());
        }
        catch (Exception e) {
            log.error("CnccqJmsConsumer-consumer.receive error " + e + ", ErrorCode:" + CnccqResultEnum.UNKNOWN_ERROR.getCode());
            throw new CnccqJmsRuntimeException("#CnccqJmsContext-consumer# receive message error:" + e.getMessage(), String.valueOf(CnccqResultEnum.UNKNOWN_ERROR.getCode()));
        }
    }

    @Override
    public void commit() {
        TcpConnection connection = this.connectionLocal.get();
        if (Objects.nonNull(connection)) {
            CnccqResult resCommit = connection.sendCmd(CnccqCommandEnum.COMMIT, this.destination);
            log.info("#CnccqJmsConsumer# receive message commit:" + resCommit);
            this.connectPool.returnObject(connection);
            this.connectionLocal.remove();
        }
    }

    public CnccqResult send(CnccqDestination destination, CnccqMessage message) {
        CnccqResult sendRes;
        block12: {
            TcpConnection connection = null;
            sendRes = null;
            try {
                this.checkMessage(message);
                connection = this.connectPool.borrowObject();
                log.info("#CnccqJmsContext# send borrowObject,connection " + connection);
                CnccqResult resCreateQueueCon = connection.sendCmd(CnccqCommandEnum.CREATE_QUEUE_CONNECTION, destination);
                if (!resCreateQueueCon.isSuccess()) {
                    log.error("#CnccqJmsContext-producer# create queue connect fail actCode:" + resCreateQueueCon.getCode());
                    throw new CnccqJmsRuntimeException("#CnccqJmsContext-producer# create queue connect fail actCode: " + resCreateQueueCon.getCode(), String.valueOf(resCreateQueueCon.getCode()));
                }
                sendRes = connection.sendMessage(destination, message);
                log.info("#CnccqJmsContext-producer# send message CREATE_QUEUE_CONNECTION sendRes: " + resCreateQueueCon.getCode());
                if (sendRes.isSuccess()) {
                    CnccqResult resCommit = connection.sendCmd(CnccqCommandEnum.COMMIT, destination);
                    log.info("#CnccqJmsContext-producer# send message commit:" + resCommit);
                    if (!resCommit.isSuccess()) {
                        log.error("#CnccqJmsContext-producer# send commit fail actCode:" + resCommit.getCode());
                        throw new CnccqJmsRuntimeException("CnccqJmsContext-producer# send commit fail actCode:" + resCommit.getCode(), String.valueOf(resCommit.getCode()));
                    }
                    break block12;
                }
                log.error("#CnccqJmsContext-producer# send message fail actCode:" + sendRes.getCode());
                throw new CnccqJmsRuntimeException("CnccqJmsContext-producer# send message fail actCode:" + sendRes.getCode(), String.valueOf(sendRes.getCode()));
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                log.error("CnccqJmsContext-producer.send message fail " + cnccqJmsRuntimeException.getMessage() + ", ErrorCode:" + cnccqJmsRuntimeException.getErrorCode());
                if (connection != null) {
                    connection.sendCmd(CnccqCommandEnum.ROLLBACK, destination);
                }
                throw new CnccqJmsRuntimeException("#CnccqJmsContext-producer# send message fail:" + cnccqJmsRuntimeException.getMessage(), cnccqJmsRuntimeException.getErrorCode());
            }
            catch (Exception e) {
                log.error("CnccqJmsContext-producer# send message fail:" + e + ", ErrorCode:" + CnccqResultEnum.UNKNOWN_ERROR.getCode());
                if (connection != null) {
                    connection.sendCmd(CnccqCommandEnum.ROLLBACK, destination);
                }
                throw new CnccqJmsRuntimeException("CnccqJmsContext-producer# send message fail:" + e.getMessage(), String.valueOf(CnccqResultEnum.UNKNOWN_ERROR.getCode()));
            }
            finally {
                log.info("#CnccqJmsContext-producer# send returnObject,connection " + connection);
                if (connection != null) {
                    this.connectPool.returnObject(connection);
                }
                log.info("#CnccqJmsContext-producer# send returnObject,connection " + connection);
            }
        }
        return sendRes;
    }

    public CnccqResult sendNotCommit(CnccqDestination destination, CnccqMessage message, TcpConnection connection) {
        CnccqResult sendRes = null;
        try {
            this.checkMessage(message);
            log.info("#CnccqJmsContext-producer# send borrowObject,connection " + connection);
            CnccqResult resCreateQueueCon = connection.sendCmd(CnccqCommandEnum.CREATE_QUEUE_CONNECTION, destination);
            if (!resCreateQueueCon.isSuccess()) {
                log.error("#CnccqJmsContext-producer# create queue connect fail actCode:" + resCreateQueueCon.getCode());
                throw new CnccqJmsRuntimeException("#CnccqJmsContext-producer# create queue connect fail actCode: " + resCreateQueueCon.getCode(), String.valueOf(resCreateQueueCon.getCode()));
            }
            sendRes = connection.sendMessage(destination, message);
            log.info("#CnccqJmsContext-producer# send message CREATE_QUEUE_CONNECTION sendRes: " + resCreateQueueCon.getCode());
            if (!sendRes.isSuccess()) {
                log.error("#CnccqJmsContext-producer# send message fail actCode:" + sendRes.getCode());
                throw new CnccqJmsRuntimeException("CnccqJmsContext-producer# send message fail actCode:" + sendRes.getCode(), String.valueOf(sendRes.getCode()));
            }
        }
        catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
            connection.sendCmd(CnccqCommandEnum.ROLLBACK, destination);
            log.error("#CnccqJmsContext-producer# send message fail:" + cnccqJmsRuntimeException.getMessage() + ", ErrorCode:" + cnccqJmsRuntimeException.getErrorCode());
            throw new CnccqJmsRuntimeException("#CnccqJmsContext-producer# send message fail:" + cnccqJmsRuntimeException.getMessage(), cnccqJmsRuntimeException.getErrorCode());
        }
        catch (Exception e) {
            connection.sendCmd(CnccqCommandEnum.ROLLBACK, destination);
            log.error("CnccqJmsContext-producer.send message fail:" + e + ", ErrorCode:" + CnccqResultEnum.UNKNOWN_ERROR.getCode());
            throw new CnccqJmsRuntimeException("#CnccqJmsContext-producer# send message fail:" + e.getMessage(), String.valueOf(CnccqResultEnum.UNKNOWN_ERROR.getCode()));
        }
        return sendRes;
    }

    @Override
    public void rollback() {
        TcpConnection connection = this.connectionLocal.get();
        if (Objects.nonNull(connection)) {
            connection.sendCmd(CnccqCommandEnum.ROLLBACK, this.destination);
        }
    }

    @Override
    public void recover() {
    }

    @Override
    public JMSConsumer createConsumer(Destination destination) {
        this.destination = (CnccqDestination)destination;
        return new CnccqJmsConsumer(this, null, (CnccqDestination)destination, true);
    }

    public JMSConsumer createConsumer(Destination destination, boolean autoCommit) {
        this.destination = (CnccqDestination)destination;
        TcpConnection connection = null;
        if (!autoCommit) {
            try {
                connection = this.connectPool.borrowObject();
            }
            catch (CnccqJmsRuntimeException cnccqJmsRuntimeException) {
                log.info("CnccqJmsContext# create producer fail:" + cnccqJmsRuntimeException.getMessage() + ", ErrorCode:" + cnccqJmsRuntimeException.getErrorCode());
                throw new CnccqJmsRuntimeException("CnccqJmsContext# create producer fail:" + cnccqJmsRuntimeException.getMessage(), cnccqJmsRuntimeException.getErrorCode());
            }
            catch (Exception e) {
                log.info("CnccqJmsContext# create consumer fail:" + e + ", ErrorCode:" + CnccqResultEnum.UNKNOWN_ERROR.getCode());
                throw new CnccqJmsRuntimeException("CnccqJmsContext# create consumer fail:" + e.getMessage(), String.valueOf(CnccqResultEnum.UNKNOWN_ERROR.getCode()));
            }
        }
        return new CnccqJmsConsumer(this, connection, (CnccqDestination)destination, autoCommit);
    }

    @Override
    public JMSConsumer createConsumer(Destination destination, String s) {
        return null;
    }

    @Override
    public JMSConsumer createConsumer(Destination destination, String s, boolean b) {
        return null;
    }

    @Override
    public Queue createQueue(String queueName) {
        return null;
    }

    @Override
    public TextMessage createTextMessage() {
        return null;
    }

    @Override
    public TextMessage createTextMessage(String text) {
        return new CnccqTextMessage(text);
    }

    @Override
    public Topic createTopic(String s) {
        return null;
    }

    @Override
    public JMSConsumer createDurableConsumer(Topic topic, String s) {
        return null;
    }

    @Override
    public JMSConsumer createDurableConsumer(Topic topic, String s, String s1, boolean b) {
        return null;
    }

    @Override
    public JMSConsumer createSharedDurableConsumer(Topic topic, String s) {
        return null;
    }

    @Override
    public JMSConsumer createSharedDurableConsumer(Topic topic, String s, String s1) {
        return null;
    }

    @Override
    public JMSConsumer createSharedConsumer(Topic topic, String s) {
        return null;
    }

    @Override
    public JMSConsumer createSharedConsumer(Topic topic, String s, String s1) {
        return null;
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) {
        return null;
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String s) {
        return null;
    }

    @Override
    public TemporaryQueue createTemporaryQueue() {
        return null;
    }

    @Override
    public TemporaryTopic createTemporaryTopic() {
        return null;
    }

    @Override
    public void unsubscribe(String s) {
    }

    @Override
    public void acknowledge() {
    }

    @Override
    public String getClientID() {
        return null;
    }

    @Override
    public void setClientID(String s) {
    }

    @Override
    public ConnectionMetaData getMetaData() {
        return null;
    }

    @Override
    public ExceptionListener getExceptionListener() {
        return null;
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) {
    }

    @Override
    public BytesMessage createBytesMessage() {
        return null;
    }

    @Override
    public MapMessage createMapMessage() {
        return null;
    }

    @Override
    public Message createMessage() {
        return null;
    }

    @Override
    public ObjectMessage createObjectMessage() {
        return null;
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable serializable) {
        return null;
    }

    @Override
    public StreamMessage createStreamMessage() {
        return null;
    }

    @Override
    public boolean getTransacted() {
        return false;
    }

    @Override
    public int getSessionMode() {
        return 0;
    }

    private void checkMessage(CnccqMessage cnccqMessage) {
        if (cnccqMessage.getContent() != null && cnccqMessage.getContent().getLength() > 0x1400000) {
            throw new CnccqJmsRuntimeException("Message Length larger than 20MB", String.valueOf(CnccqResultEnum.MESSAGE_OVER_LENGTH.getCode()));
        }
    }
}

