/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.ParameterMode;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TypedQuery;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributes;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class StoredProcedureJpaQuery
extends AbstractJpaQuery {
    private final StoredProcedureAttributes procedureAttributes;
    private final boolean useNamedParameters;

    public StoredProcedureJpaQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
        this.procedureAttributes = method.getProcedureAttributes();
        this.useNamedParameters = StoredProcedureJpaQuery.useNamedParameters(method);
    }

    private static boolean useNamedParameters(QueryMethod method) {
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.isNamedParameter()) continue;
            return true;
        }
        return false;
    }

    protected StoredProcedureQuery createQuery(Object[] values) {
        return this.applyHints(this.doCreateQuery(values), this.getQueryMethod());
    }

    protected StoredProcedureQuery doCreateQuery(Object[] values) {
        return this.createBinder(values).bind(this.createStoredProcedure());
    }

    protected TypedQuery<Long> doCreateCountQuery(Object[] values) {
        return null;
    }

    Object extractOutputValue(StoredProcedureQuery storedProcedureQuery) {
        Assert.notNull((Object)storedProcedureQuery, (String)"StoredProcedureQuery must not be null!");
        if (!this.procedureAttributes.hasReturnValue()) {
            return null;
        }
        String outputParameterName = this.procedureAttributes.getOutputParameterName();
        JpaParameters parameters = this.getQueryMethod().getParameters();
        return this.useNamedParameters && StringUtils.hasText((String)outputParameterName) ? storedProcedureQuery.getOutputParameterValue(outputParameterName) : storedProcedureQuery.getOutputParameterValue(parameters.getNumberOfParameters() + 1);
    }

    private StoredProcedureQuery createStoredProcedure() {
        return this.procedureAttributes.isNamedStoredProcedure() ? this.newNamedStoredProcedureQuery() : this.newAdhocStoredProcedureQuery();
    }

    private StoredProcedureQuery newNamedStoredProcedureQuery() {
        return this.getEntityManager().createNamedStoredProcedureQuery(this.procedureAttributes.getProcedureName());
    }

    private StoredProcedureQuery newAdhocStoredProcedureQuery() {
        JpaParameters params = this.getQueryMethod().getParameters();
        String procedureName = this.procedureAttributes.getProcedureName();
        StoredProcedureQuery procedureQuery = this.getEntityManager().createStoredProcedureQuery(procedureName);
        Iterator iterator = params.iterator();
        while (iterator.hasNext()) {
            JpaParameters.JpaParameter param = (JpaParameters.JpaParameter)((Object)iterator.next());
            if (!param.isBindable()) continue;
            if (this.useNamedParameters) {
                procedureQuery.registerStoredProcedureParameter(param.getName(), param.getType(), ParameterMode.IN);
                continue;
            }
            procedureQuery.registerStoredProcedureParameter(param.getIndex() + 1, param.getType(), ParameterMode.IN);
        }
        if (this.procedureAttributes.hasReturnValue()) {
            Class<?> outputParameterType = this.procedureAttributes.getOutputParameterType();
            ParameterMode mode = ParameterMode.OUT;
            if (this.useNamedParameters) {
                String outputParameterName = this.procedureAttributes.getOutputParameterName();
                procedureQuery.registerStoredProcedureParameter(outputParameterName, outputParameterType, mode);
            } else {
                procedureQuery.registerStoredProcedureParameter(params.getNumberOfParameters() + 1, outputParameterType, mode);
            }
        }
        return procedureQuery;
    }
}

