/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.endpoint;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;

public class ChannelsEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    private List<Bindable> adapters;
    private BindingServiceProperties properties;

    public ChannelsEndpoint(List<Bindable> adapters, BindingServiceProperties properties) {
        super("channels");
        this.adapters = adapters;
        this.properties = properties;
    }

    public Map<String, Object> invoke() {
        ChannelsMetaData map = new ChannelsMetaData();
        Map<String, BindingProperties> inputs = map.getInputs();
        Map<String, BindingProperties> outputs = map.getOutputs();
        for (Bindable factory : this.adapters) {
            for (String name : factory.getInputs()) {
                inputs.put(name, this.properties.getBindingProperties(name));
            }
            for (String name : factory.getOutputs()) {
                outputs.put(name, this.properties.getBindingProperties(name));
            }
        }
        return (Map)new ObjectMapper().convertValue((Object)map, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class ChannelsMetaData {
        private Map<String, BindingProperties> inputs = new LinkedHashMap<String, BindingProperties>();
        private Map<String, BindingProperties> outputs = new LinkedHashMap<String, BindingProperties>();

        public Map<String, BindingProperties> getInputs() {
            return this.inputs;
        }

        public Map<String, BindingProperties> getOutputs() {
            return this.outputs;
        }
    }
}

