/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.loadbalancer;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.loadbalancer.KubernetesLoadBalancerClientConfiguration;
import org.springframework.cloud.kubernetes.loadbalancer.KubernetesLoadBalancerProperties;
import org.springframework.cloud.kubernetes.loadbalancer.KubernetesServiceInstanceMapper;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={KubernetesLoadBalancerProperties.class})
@ConditionalOnProperty(value={"spring.cloud.kubernetes.loadbalancer.enabled"}, matchIfMissing=true)
@LoadBalancerClients(defaultConfiguration={KubernetesLoadBalancerClientConfiguration.class})
public class KubernetesLoadBalancerAutoConfiguration {
    @Bean
    KubernetesServiceInstanceMapper mapper(KubernetesLoadBalancerProperties properties, KubernetesDiscoveryProperties discoveryProperties) {
        return new KubernetesServiceInstanceMapper(properties, discoveryProperties);
    }
}

