/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.spi.JavaConstantFieldProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public abstract class SharedConstantFieldProvider
extends JavaConstantFieldProvider {
    protected final ClassInitializationSupport classInitializationSupport;

    public SharedConstantFieldProvider(MetaAccessProvider metaAccess, ClassInitializationSupport classInitializationSupport) {
        super(metaAccess);
        this.classInitializationSupport = classInitializationSupport;
    }

    public boolean isFinalField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        if (this.classInitializationSupport.shouldInitializeAtRuntime(field.getDeclaringClass())) {
            return false;
        }
        return super.isFinalField(field, tool);
    }

    protected boolean isFinalFieldValueConstant(ResolvedJavaField field, JavaConstant value, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        if (value.getJavaKind() == JavaKind.Object && SubstrateObjectConstant.asObject((Constant)value) instanceof MethodPointer) {
            return false;
        }
        return super.isFinalFieldValueConstant(field, value, tool);
    }
}

