/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.graal.meta.SubstrateMethod;
import com.oracle.svm.hosted.FeatureImpl;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.MatchStatement;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.debug.GlobalMetrics;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.CompositeValueClass;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.phases.LIRPhase;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class GraalSupport {
    private RuntimeConfiguration runtimeConfig;
    private Suites suites;
    private LIRSuites lirSuites;
    private Suites firstTierSuites;
    private LIRSuites firstTierLirSuites;
    private Providers firstTierProviders;
    private SubstrateMethod[] methodsToCompile;
    private byte[] graphEncoding;
    private Object[] graphObjects;
    private NodeClass<?>[] graphNodeTypes;
    public final Map<Class<?>, NodeClass<?>> nodeClasses = new HashMap();
    public final Map<Class<?>, LIRInstructionClass<?>> instructionClasses = new HashMap();
    public final Map<Class<?>, CompositeValueClass<?>> compositeValueClasses = new HashMap();
    public HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>> matchRuleRegistry;
    protected Map<Class<?>, BasePhase.BasePhaseStatistics> basePhaseStatistics;
    protected Map<Class<?>, LIRPhase.LIRPhaseStatistics> lirPhaseStatistics;
    protected Function<Providers, SubstrateBackend> runtimeBackendProvider;
    protected final GlobalMetrics metricValues = new GlobalMetrics();
    protected final List<DebugHandlersFactory> debugHandlersFactories = new ArrayList<DebugHandlersFactory>();
    protected final DiagnosticsOutputDirectory outputDirectory = new DiagnosticsOutputDirectory((OptionValues)RuntimeOptionValues.singleton());
    protected final Map<CompilationWrapper.ExceptionAction, Integer> compilationProblemsPerAction = new EnumMap<CompilationWrapper.ExceptionAction, Integer>(CompilationWrapper.ExceptionAction.class);
    private static final CGlobalData<Pointer> nextIsolateId = CGlobalDataFactory.createWord((WordBase)((Pointer)WordFactory.unsigned((long)1L)));
    private volatile long isolateId = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIsolateId() {
        if (this.isolateId == 0L) {
            GraalSupport graalSupport = this;
            synchronized (graalSupport) {
                if (this.isolateId == 0L) {
                    long nextValue;
                    long value;
                    Pointer p = nextIsolateId.get();
                    do {
                        if ((nextValue = (value = p.readLong(0)) + 1L) != 0L) continue;
                        nextValue = 1L;
                    } while (p.compareAndSwapLong(0, value, nextValue, LocationIdentity.ANY_LOCATION) != value);
                    this.isolateId = value;
                }
            }
        }
        return this.isolateId;
    }

    public DebugContext openDebugContext(OptionValues options, CompilationIdentifier compilationId, Object compilable, PrintStream logStream) {
        DebugContext.Description description = new DebugContext.Description(compilable, compilationId.toString(CompilationIdentifier.Verbosity.ID));
        return new DebugContext.Builder(options, this.runtimeConfig.getDebugHandlersFactories()).globalMetrics(this.metricValues).description(description).logStream(logStream).build();
    }

    public DiagnosticsOutputDirectory getDebugOutputDirectory() {
        return this.outputDirectory;
    }

    public Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction() {
        return this.compilationProblemsPerAction;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public GraalSupport() {
        this.runtimeBackendProvider = SubstrateBackendFactory.get()::newBackend;
        for (DebugHandlersFactory c : GraalServices.load(DebugHandlersFactory.class)) {
            this.debugHandlersFactories.add(c);
        }
    }

    public HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>> getMatchRuleRegistry() {
        return this.matchRuleRegistry;
    }

    public void setMatchRuleRegistry(HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>> matchRuleRegistry) {
        this.matchRuleRegistry = matchRuleRegistry;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setRuntimeConfig(RuntimeConfiguration runtimeConfig, Suites suites, LIRSuites lirSuites, Suites firstTierSuites, LIRSuites firstTierLirSuites) {
        GraalSupport.get().runtimeConfig = runtimeConfig;
        GraalSupport.get().suites = suites;
        GraalSupport.get().lirSuites = lirSuites;
        GraalSupport.get().firstTierSuites = firstTierSuites;
        GraalSupport.get().firstTierLirSuites = firstTierLirSuites;
        GraalSupport.get().firstTierProviders = runtimeConfig.getBackendForNormalMethod().getProviders();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean setMethodsToCompile(SubstrateMethod[] methodsToCompile) {
        boolean result = false;
        if (!Arrays.equals(GraalSupport.get().methodsToCompile, methodsToCompile)) {
            GraalSupport.get().methodsToCompile = methodsToCompile;
            result = true;
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean setGraphEncoding(byte[] graphEncoding, Object[] graphObjects, NodeClass<?>[] graphNodeTypes) {
        if (GraalSupport.get().graphObjects == null && graphObjects.length == 0) {
            assert (graphEncoding.length == 0);
            assert (graphNodeTypes.length == 0);
            return false;
        }
        boolean result = false;
        if (!Arrays.equals(GraalSupport.get().graphEncoding, graphEncoding)) {
            GraalSupport.get().graphEncoding = graphEncoding;
            result = true;
        }
        if (!Arrays.deepEquals(GraalSupport.get().graphObjects, graphObjects)) {
            GraalSupport.get().graphObjects = graphObjects;
            result = true;
        }
        if (!Arrays.equals(GraalSupport.get().graphNodeTypes, graphNodeTypes)) {
            GraalSupport.get().graphNodeTypes = graphNodeTypes;
            result = true;
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerImmutableObjects(Feature.CompilationAccess access) {
        access.registerAsImmutable((Object)GraalSupport.get().graphEncoding);
        access.registerAsImmutable((Object)GraalSupport.get().graphObjects);
        access.registerAsImmutable(GraalSupport.get().graphNodeTypes);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void allocatePhaseStatisticsCache() {
        GraalSupport.get().basePhaseStatistics = new HashMap();
        GraalSupport.get().lirPhaseStatistics = new HashMap();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerPhaseStatistics(Feature.DuringAnalysisAccess a, Class<?> newlyReachableClass) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        if (!Modifier.isAbstract(newlyReachableClass.getModifiers())) {
            if (BasePhase.class.isAssignableFrom(newlyReachableClass)) {
                GraalSupport.registerStatistics(newlyReachableClass, GraalSupport.get().basePhaseStatistics, new BasePhase.BasePhaseStatistics(newlyReachableClass), access);
            } else if (LIRPhase.class.isAssignableFrom(newlyReachableClass)) {
                GraalSupport.registerStatistics(newlyReachableClass, GraalSupport.get().lirPhaseStatistics, new LIRPhase.LIRPhaseStatistics(newlyReachableClass), access);
            }
        }
    }

    private static <S> void registerStatistics(Class<?> phaseSubClass, Map<Class<?>, S> cache, S newStatistics, FeatureImpl.DuringAnalysisAccessImpl access) {
        assert (!cache.containsKey(phaseSubClass));
        cache.put(phaseSubClass, newStatistics);
        access.requireAnalysisIteration();
    }

    public static GraalSupport get() {
        return (GraalSupport)ImageSingletons.lookup(GraalSupport.class);
    }

    public static RuntimeConfiguration getRuntimeConfig() {
        return GraalSupport.get().runtimeConfig;
    }

    public static Suites getSuites() {
        return GraalSupport.get().suites;
    }

    public static LIRSuites getLIRSuites() {
        return GraalSupport.get().lirSuites;
    }

    public static Suites getFirstTierSuites() {
        return GraalSupport.get().firstTierSuites;
    }

    public static LIRSuites getFirstTierLirSuites() {
        return GraalSupport.get().firstTierLirSuites;
    }

    public static Providers getFirstTierProviders() {
        return GraalSupport.get().firstTierProviders;
    }

    public static SubstrateMethod[] getMethodsToCompile() {
        return GraalSupport.get().methodsToCompile;
    }

    public static EncodedGraph encodedGraph(SharedRuntimeMethod method, boolean trackNodeSourcePosition) {
        int startOffset = method.getEncodedGraphStartOffset();
        if (startOffset == -1) {
            return null;
        }
        return new EncodedGraph(GraalSupport.get().graphEncoding, startOffset, GraalSupport.get().graphObjects, GraalSupport.get().graphNodeTypes, null, null, false, trackNodeSourcePosition);
    }

    public static StructuredGraph decodeGraph(DebugContext debug, String name, CompilationIdentifier compilationId, SharedRuntimeMethod method) {
        EncodedGraph encodedGraph = GraalSupport.encodedGraph(method, false);
        if (encodedGraph == null) {
            return null;
        }
        boolean isSubstitution = method.getAnnotation(Snippet.class) != null || method.getAnnotation(MethodSubstitution.class) != null;
        StructuredGraph graph = new StructuredGraph.Builder(debug.getOptions(), debug).name(name).method((ResolvedJavaMethod)method).compilationId(compilationId).setIsSubstitution(isSubstitution).build();
        GraphDecoder decoder = new GraphDecoder(ConfigurationValues.getTarget().arch, graph);
        decoder.decode(encodedGraph);
        return graph;
    }

    public static Function<Providers, SubstrateBackend> getRuntimeBackendProvider() {
        return GraalSupport.get().runtimeBackendProvider;
    }

    public static void setRuntimeBackendProvider(Function<Providers, SubstrateBackend> backendProvider) {
        GraalSupport.get().runtimeBackendProvider = backendProvider;
    }

    public static class GraalShutdownHook
    implements Runnable {
        @Override
        public void run() {
            GraalSupport graalSupport = GraalSupport.get();
            graalSupport.metricValues.print((OptionValues)RuntimeOptionValues.singleton());
            graalSupport.outputDirectory.close();
        }
    }
}

