/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.versions.utils.ContextualLog;
import org.codehaus.plexus.util.StringUtils;

public class DelegatingContextualLog
implements ContextualLog {
    private final Log delegate;
    private String currentContext = null;
    private boolean currentContextReportedDebug = false;
    private boolean currentContextReportedInfo = false;
    private boolean currentContextReportedWarn = false;
    private boolean currentContextReportedError = false;

    public DelegatingContextualLog(Log delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized void setContext(String context) {
        if (StringUtils.equals((String)this.currentContext, (String)context)) {
            return;
        }
        if (this.currentContext != null) {
            this.clearContext();
        }
        this.currentContext = context;
        this.currentContextReportedDebug = false;
        this.currentContextReportedInfo = false;
        this.currentContextReportedWarn = false;
        this.currentContextReportedError = false;
    }

    @Override
    public synchronized void clearContext() {
        if (this.currentContextReportedError) {
            this.delegate.error((CharSequence)"");
        } else if (this.currentContextReportedWarn) {
            this.delegate.warn((CharSequence)"");
        } else if (this.currentContextReportedInfo) {
            this.delegate.info((CharSequence)"");
        } else if (this.currentContextReportedDebug) {
            this.delegate.debug((CharSequence)"");
        }
        this.currentContextReportedDebug = false;
        this.currentContextReportedInfo = false;
        this.currentContextReportedWarn = false;
        this.currentContextReportedError = false;
    }

    private void enterContextDebug() {
        if (!(this.currentContextReportedDebug || this.currentContextReportedInfo || this.currentContextReportedWarn || this.currentContextReportedError)) {
            this.delegate.debug((CharSequence)this.currentContext);
            this.currentContextReportedDebug = true;
        }
    }

    private void enterContextInfo() {
        if (!(this.currentContextReportedInfo || this.currentContextReportedWarn || this.currentContextReportedError)) {
            this.delegate.info((CharSequence)this.currentContext);
            this.currentContextReportedInfo = true;
        }
    }

    private void enterContextWarn() {
        if (!this.currentContextReportedWarn && !this.currentContextReportedError) {
            this.delegate.warn((CharSequence)this.currentContext);
            this.currentContextReportedWarn = true;
        }
    }

    private void enterContextError() {
        if (!this.currentContextReportedError) {
            this.delegate.error((CharSequence)this.currentContext);
            this.currentContextReportedError = true;
        }
    }

    public void debug(CharSequence charSequence) {
        this.enterContextDebug();
        this.delegate.debug(charSequence);
    }

    public void debug(CharSequence charSequence, Throwable throwable) {
        this.enterContextDebug();
        this.delegate.debug(charSequence, throwable);
    }

    public void debug(Throwable throwable) {
        this.enterContextDebug();
        this.delegate.debug(throwable);
    }

    public void info(CharSequence charSequence) {
        this.enterContextInfo();
        this.delegate.info(charSequence);
    }

    public void info(CharSequence charSequence, Throwable throwable) {
        this.enterContextInfo();
        this.delegate.info(charSequence, throwable);
    }

    public void info(Throwable throwable) {
        this.enterContextInfo();
        this.delegate.info(throwable);
    }

    public void warn(CharSequence charSequence) {
        this.enterContextWarn();
        this.delegate.warn(charSequence);
    }

    public void warn(CharSequence charSequence, Throwable throwable) {
        this.enterContextWarn();
        this.delegate.warn(charSequence, throwable);
    }

    public void warn(Throwable throwable) {
        this.enterContextWarn();
        this.delegate.warn(throwable);
    }

    public void error(CharSequence charSequence) {
        this.enterContextError();
        this.delegate.error(charSequence);
    }

    public void error(CharSequence charSequence, Throwable throwable) {
        this.enterContextError();
        this.delegate.error(charSequence, throwable);
    }

    public void error(Throwable throwable) {
        this.enterContextError();
        this.delegate.error(throwable);
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }
}

