/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.security;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class RestrictionEditor
extends DefaultEditor {
    private final NodeBuilder builder;
    private final TypePredicate isACE;
    private PropertyState glob = null;

    public RestrictionEditor(NodeBuilder builder, TypePredicate isACE) {
        this.builder = builder;
        this.isACE = isACE;
    }

    private RestrictionEditor(RestrictionEditor parent, String name) {
        this.builder = parent.builder.getChildNode(name);
        this.isACE = parent.isACE;
    }

    public void leave(NodeState before, NodeState after) {
        if (this.glob != null && this.isACE.apply(after) && !this.builder.hasChildNode("rep:restrictions")) {
            NodeBuilder restrictions = this.builder.setChildNode("rep:restrictions");
            restrictions.setProperty("jcr:primaryType", (Object)"rep:Restrictions", Type.NAME);
            restrictions.setProperty(this.glob);
            this.builder.removeProperty("rep:glob");
        }
    }

    public void propertyAdded(PropertyState after) {
        if ("rep:glob".equals(after.getName())) {
            this.glob = after;
        }
    }

    public void propertyChanged(PropertyState before, PropertyState after) {
        if ("rep:glob".equals(after.getName())) {
            this.glob = after;
        }
    }

    public Editor childNodeAdded(String name, NodeState after) {
        return new RestrictionEditor(this, name);
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        return new RestrictionEditor(this, name);
    }
}

