/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade;

import com.google.common.base.Function;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;

public class ProgressNotificationEditor
implements Editor {
    private final Editor editor;
    private final String path;
    private final Function<String, Void> onProgress;

    public static ProgressNotificationEditor wrap(Editor editor, final Logger logger, final String message) {
        return new ProgressNotificationEditor(editor, "/", new Function<String, Void>(){
            int count;

            @Nullable
            public Void apply(String path) {
                if (++this.count % 10000 == 0) {
                    logger.info(message + ' ' + path);
                }
                return null;
            }
        });
    }

    private ProgressNotificationEditor(Editor editor, String path, Function<String, Void> onProgress) {
        this.editor = editor;
        this.path = path;
        this.onProgress = onProgress;
    }

    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        this.onProgress.apply((Object)this.path);
        this.editor.enter(before, after);
    }

    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        this.editor.leave(before, after);
    }

    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.editor.propertyAdded(after);
    }

    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        this.editor.propertyChanged(before, after);
    }

    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        this.editor.propertyDeleted(before);
    }

    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        return this.createChildEditor(this.editor.childNodeAdded(name, after), name);
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return this.createChildEditor(this.editor.childNodeChanged(name, before, after), name);
    }

    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        return this.createChildEditor(this.editor.childNodeDeleted(name, before), name);
    }

    private ProgressNotificationEditor createChildEditor(Editor editor, String name) {
        if (editor == null) {
            return null;
        }
        return new ProgressNotificationEditor(editor, PathUtils.concat((String)this.path, (String)name), this.onProgress);
    }
}

