/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.AbstractBlob;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.upgrade.BundleLoader;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JackrabbitNodeState
extends AbstractNodeState {
    private static final Logger log = LoggerFactory.getLogger(JackrabbitNodeState.class);
    private static long count = 0L;
    private final JackrabbitNodeState parent;
    private final String name;
    private String path;
    private final BundleLoader loader;
    private final String workspaceName;
    private final TypePredicate isReferenceable;
    private final TypePredicate isOrderable;
    private final TypePredicate isVersionable;
    private final TypePredicate isVersionHistory;
    private final TypePredicate isFrozenNode;
    private final Map<String, String> uriToPrefix;
    private final Map<String, String> versionablePaths;
    private final boolean useBinaryReferences;
    private final Map<String, NodeId> nodes;
    private final Map<String, PropertyState> properties;

    private static void logNewNode(JackrabbitNodeState state) {
        if (++count % 10000L == 0L) {
            log.info("Migrating node #" + count + ": " + state.getPath());
        }
    }

    private JackrabbitNodeState(JackrabbitNodeState parent, String name, NodePropBundle bundle) {
        this.parent = parent;
        this.name = name;
        this.path = null;
        this.loader = parent.loader;
        this.workspaceName = parent.workspaceName;
        this.isReferenceable = parent.isReferenceable;
        this.isOrderable = parent.isOrderable;
        this.isVersionable = parent.isVersionable;
        this.isVersionHistory = parent.isVersionHistory;
        this.isFrozenNode = parent.isFrozenNode;
        this.uriToPrefix = parent.uriToPrefix;
        this.versionablePaths = parent.versionablePaths;
        this.useBinaryReferences = parent.useBinaryReferences;
        this.properties = this.createProperties(bundle);
        this.nodes = this.createNodes(bundle);
        this.setChildOrder();
        this.setVersionablePaths();
        this.fixFrozenUuid();
        JackrabbitNodeState.logNewNode(this);
    }

    JackrabbitNodeState(PersistenceManager source, NodeState root, Map<String, String> uriToPrefix, NodeId id, String path, String workspaceName, Map<String, String> versionablePaths, boolean useBinaryReferences) {
        this.parent = null;
        this.name = null;
        this.path = path;
        this.loader = new BundleLoader(source);
        this.workspaceName = workspaceName;
        this.isReferenceable = new TypePredicate(root, "mix:referenceable");
        this.isOrderable = TypePredicate.isOrderable((NodeState)root);
        this.isVersionable = new TypePredicate(root, "mix:versionable");
        this.isVersionHistory = new TypePredicate(root, "nt:versionHistory");
        this.isFrozenNode = new TypePredicate(root, "nt:frozenNode");
        this.uriToPrefix = uriToPrefix;
        this.versionablePaths = versionablePaths;
        this.useBinaryReferences = useBinaryReferences;
        try {
            NodePropBundle bundle = this.loader.loadBundle(id);
            this.properties = this.createProperties(bundle);
            this.nodes = this.createNodes(bundle);
            this.setChildOrder();
        }
        catch (ItemStateException e) {
            throw new IllegalStateException("Unable to access node " + id, e);
        }
        JackrabbitNodeState.logNewNode(this);
    }

    public String toString() {
        return this.getPath();
    }

    public boolean exists() {
        return true;
    }

    public long getPropertyCount() {
        return this.properties.size();
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public PropertyState getProperty(String name) {
        return this.properties.get(name);
    }

    public Iterable<PropertyState> getProperties() {
        return this.properties.values();
    }

    public long getChildNodeCount(long max) {
        return this.nodes.size();
    }

    public boolean hasChildNode(String name) {
        return this.nodes.containsKey(name);
    }

    public NodeState getChildNode(String name) {
        NodeId id = this.nodes.get(name);
        if (id != null) {
            try {
                return new JackrabbitNodeState(this, name, this.loader.loadBundle(id));
            }
            catch (ItemStateException e) {
                throw new IllegalStateException("Unable to access child node " + name, e);
            }
        }
        JackrabbitNodeState.checkValidName((String)name);
        return EmptyNodeState.MISSING_NODE;
    }

    public Iterable<String> getChildNodeNames() {
        return this.nodes.keySet();
    }

    public Iterable<MemoryChildNodeEntry> getChildNodeEntries() {
        ArrayList entries = Lists.newArrayList();
        for (Map.Entry<String, NodeId> entry : this.nodes.entrySet()) {
            String name = entry.getKey();
            try {
                JackrabbitNodeState child = new JackrabbitNodeState(this, name, this.loader.loadBundle(entry.getValue()));
                entries.add(new MemoryChildNodeEntry(name, (NodeState)child));
            }
            catch (ItemStateException e) {
                this.warn("Skipping broken child node entry " + name, e);
            }
        }
        return entries;
    }

    public NodeBuilder builder() {
        return new MemoryNodeBuilder((NodeState)this);
    }

    private void setChildOrder() {
        if (this.isOrderable.apply((NodeState)this)) {
            this.properties.put(":childOrder", PropertyStates.createProperty((String)":childOrder", this.nodes.keySet(), (Type)Type.NAMES));
        }
    }

    private void setVersionablePaths() {
        String uuid;
        String path;
        if (this.isVersionable.apply((NodeState)this)) {
            String uuid2 = this.getString("jcr:versionHistory");
            if (uuid2 != null) {
                this.versionablePaths.put(uuid2, this.getPath());
            }
        } else if (this.isVersionHistory.apply((NodeState)this) && (path = this.versionablePaths.get(uuid = this.getString("jcr:uuid"))) != null) {
            this.properties.put(this.workspaceName, PropertyStates.createProperty((String)this.workspaceName, (Object)path, (Type)Type.PATH));
        }
    }

    private Map<String, NodeId> createNodes(NodePropBundle bundle) {
        LinkedHashMap children = Maps.newLinkedHashMap();
        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
            String base;
            String name = base = this.createName(entry.getName());
            int i = 2;
            while (children.containsKey(name)) {
                name = base + '[' + i + ']';
                ++i;
            }
            children.put(name, entry.getId());
        }
        return children;
    }

    private Map<String, PropertyState> createProperties(NodePropBundle bundle) {
        String primary;
        HashMap properties = Maps.newHashMap();
        if (bundle.getNodeTypeName() != null) {
            primary = this.createName(bundle.getNodeTypeName());
        } else {
            this.warn("Missing primary node type; defaulting to nt:unstructured");
            primary = "nt:unstructured";
        }
        properties.put("jcr:primaryType", PropertyStates.createProperty((String)"jcr:primaryType", (Object)primary, (Type)Type.NAME));
        LinkedHashSet mixins = Sets.newLinkedHashSet();
        if (bundle.getMixinTypeNames() != null) {
            for (Name mixin : bundle.getMixinTypeNames()) {
                mixins.add(this.createName(mixin));
            }
        }
        if (!mixins.isEmpty()) {
            properties.put("jcr:mixinTypes", PropertyStates.createProperty((String)"jcr:mixinTypes", (Object)mixins, (Type)Type.NAMES));
        }
        if (bundle.isReferenceable() || this.isReferenceable.apply(primary, (Set)mixins)) {
            properties.put("jcr:uuid", PropertyStates.createProperty((String)"jcr:uuid", (Object)bundle.getId().toString()));
        }
        for (NodePropBundle.PropertyEntry property : bundle.getPropertyEntries()) {
            String name = this.createName(property.getName());
            try {
                int type = property.getType();
                if (property.isMultiValued()) {
                    properties.put(name, this.createProperty(name, type, property.getValues()));
                    continue;
                }
                properties.put(name, this.createProperty(name, type, property.getValues()[0]));
            }
            catch (Exception e) {
                this.warn("Skipping broken property entry " + name, e);
            }
        }
        return properties;
    }

    private void fixFrozenUuid() {
        PropertyState frozenUuid = this.properties.get("jcr:frozenUuid");
        if (frozenUuid != null && frozenUuid.getType() == Type.STRING && this.isFrozenNode.apply((NodeState)this)) {
            String parentFrozenUuid;
            String frozenPrimary = "nt:base";
            HashSet frozenMixins = Sets.newHashSet();
            PropertyState property = this.properties.get("jcr:frozenPrimaryType");
            if (property != null && property.getType() == Type.NAME) {
                frozenPrimary = (String)property.getValue(Type.NAME);
            }
            if ((property = this.properties.get("jcr:frozenMixinTypes")) != null && property.getType() == Type.NAMES) {
                Iterables.addAll((Collection)frozenMixins, (Iterable)((Iterable)property.getValue(Type.NAMES)));
            }
            if (!this.isReferenceable.apply(frozenPrimary, (Set)frozenMixins) && (parentFrozenUuid = this.parent.getString("jcr:frozenUuid")) != null) {
                frozenUuid = PropertyStates.createProperty((String)"jcr:frozenUuid", (Object)(parentFrozenUuid + "/" + this.name));
                this.properties.put("jcr:frozenUuid", frozenUuid);
            }
        }
    }

    private PropertyState createProperty(String name, int type, InternalValue value) throws RepositoryException, IOException {
        switch (type) {
            case 2: {
                return PropertyStates.createProperty((String)name, (Object)this.createBlob(value), (Type)Type.BINARY);
            }
            case 6: {
                return PropertyStates.createProperty((String)name, (Object)value.getBoolean(), (Type)Type.BOOLEAN);
            }
            case 5: {
                return PropertyStates.createProperty((String)name, (Object)value.getString(), (Type)Type.DATE);
            }
            case 12: {
                return PropertyStates.createProperty((String)name, (Object)value.getDecimal(), (Type)Type.DECIMAL);
            }
            case 4: {
                return PropertyStates.createProperty((String)name, (Object)value.getDouble(), (Type)Type.DOUBLE);
            }
            case 3: {
                return PropertyStates.createProperty((String)name, (Object)value.getLong(), (Type)Type.LONG);
            }
            case 7: {
                return PropertyStates.createProperty((String)name, (Object)this.createName(value.getName()), (Type)Type.NAME);
            }
            case 8: {
                return PropertyStates.createProperty((String)name, (Object)this.createPath(value.getPath()), (Type)Type.PATH);
            }
            case 9: {
                return PropertyStates.createProperty((String)name, (Object)value.getNodeId().toString(), (Type)Type.REFERENCE);
            }
            case 1: {
                return PropertyStates.createProperty((String)name, (Object)value.getString(), (Type)Type.STRING);
            }
            case 11: {
                return PropertyStates.createProperty((String)name, (Object)value.getURI().toString(), (Type)Type.URI);
            }
            case 10: {
                return PropertyStates.createProperty((String)name, (Object)value.getNodeId().toString(), (Type)Type.WEAKREFERENCE);
            }
        }
        throw new RepositoryException("Unknown value type: " + type);
    }

    private PropertyState createProperty(String name, int type, InternalValue[] values) throws RepositoryException, IOException {
        switch (type) {
            case 2: {
                ArrayList binaries = Lists.newArrayListWithCapacity((int)values.length);
                for (InternalValue value : values) {
                    binaries.add(this.createBlob(value));
                }
                return PropertyStates.createProperty((String)name, (Object)binaries, (Type)Type.BINARIES);
            }
            case 6: {
                ArrayList booleans = Lists.newArrayListWithCapacity((int)values.length);
                for (InternalValue value : values) {
                    booleans.add(value.getBoolean());
                }
                return PropertyStates.createProperty((String)name, (Object)booleans, (Type)Type.BOOLEANS);
            }
            case 5: {
                ArrayList dates = Lists.newArrayListWithCapacity((int)values.length);
                for (InternalValue value : values) {
                    dates.add(value.getString());
                }
                return PropertyStates.createProperty((String)name, (Object)dates, (Type)Type.DATES);
            }
            case 12: {
                ArrayList decimals = Lists.newArrayListWithCapacity((int)values.length);
                for (InternalValue value : values) {
                    decimals.add(value.getDecimal());
                }
                return PropertyStates.createProperty((String)name, (Object)decimals, (Type)Type.DECIMALS);
            }
            case 4: {
                ArrayList doubles = Lists.newArrayListWithCapacity((int)values.length);
                for (InternalValue value : values) {
                    doubles.add(value.getDouble());
                }
                return PropertyStates.createProperty((String)name, (Object)doubles, (Type)Type.DOUBLES);
            }
            case 3: {
                ArrayList longs = Lists.newArrayListWithCapacity((int)values.length);
                for (InternalValue value : values) {
                    longs.add(value.getLong());
                }
                return PropertyStates.createProperty((String)name, (Object)longs, (Type)Type.LONGS);
            }
            case 7: {
                ArrayList names = Lists.newArrayListWithCapacity((int)values.length);
                for (InternalValue value : values) {
                    names.add(this.createName(value.getName()));
                }
                return PropertyStates.createProperty((String)name, (Object)names, (Type)Type.NAMES);
            }
            case 8: {
                ArrayList paths = Lists.newArrayListWithCapacity((int)values.length);
                for (InternalValue value : values) {
                    paths.add(this.createPath(value.getPath()));
                }
                return PropertyStates.createProperty((String)name, (Object)paths, (Type)Type.PATHS);
            }
            case 9: {
                ArrayList references = Lists.newArrayListWithCapacity((int)values.length);
                for (InternalValue value : values) {
                    references.add(value.getNodeId().toString());
                }
                return PropertyStates.createProperty((String)name, (Object)references, (Type)Type.REFERENCES);
            }
            case 1: {
                ArrayList strings = Lists.newArrayListWithCapacity((int)values.length);
                for (InternalValue value : values) {
                    strings.add(value.getString());
                }
                return PropertyStates.createProperty((String)name, (Object)strings, (Type)Type.STRINGS);
            }
            case 11: {
                ArrayList uris = Lists.newArrayListWithCapacity((int)values.length);
                for (InternalValue value : values) {
                    uris.add(value.getURI().toString());
                }
                return PropertyStates.createProperty((String)name, (Object)uris, (Type)Type.URIS);
            }
            case 10: {
                ArrayList weakreferences = Lists.newArrayListWithCapacity((int)values.length);
                for (InternalValue value : values) {
                    weakreferences.add(value.getNodeId().toString());
                }
                return PropertyStates.createProperty((String)name, (Object)weakreferences, (Type)Type.WEAKREFERENCES);
            }
        }
        throw new RepositoryException("Unknown value type: " + type);
    }

    private Blob createBlob(final InternalValue value) {
        Preconditions.checkArgument((((InternalValue)Preconditions.checkNotNull((Object)value)).getType() == 2 ? 1 : 0) != 0);
        return new AbstractBlob(){

            public long length() {
                try {
                    return value.getLength();
                }
                catch (RepositoryException e) {
                    JackrabbitNodeState.this.warn("Unable to access blob length", e);
                    return 0L;
                }
            }

            public InputStream getNewStream() {
                try {
                    return value.getStream();
                }
                catch (RepositoryException e) {
                    JackrabbitNodeState.this.warn("Unable to access blob contents", e);
                    return new ByteArrayInputStream(new byte[0]);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public String getReference() {
                if (!JackrabbitNodeState.this.useBinaryReferences) {
                    return null;
                }
                try {
                    Binary binary = value.getBinary();
                    try {
                        if (binary instanceof ReferenceBinary) {
                            String string = ((ReferenceBinary)binary).getReference();
                            return string;
                        }
                        String string = null;
                        return string;
                    }
                    finally {
                        binary.dispose();
                    }
                }
                catch (RepositoryException e) {
                    JackrabbitNodeState.this.warn("Unable to get blob reference", e);
                    return null;
                }
            }
        };
    }

    private String createName(Name name) {
        String uri = name.getNamespaceURI();
        String local = name.getLocalName();
        if (uri == null || uri.isEmpty()) {
            return local;
        }
        String prefix = this.uriToPrefix.get(uri);
        if (prefix != null) {
            return prefix + ":" + local;
        }
        this.warn("No prefix mapping found for " + name);
        return "{" + uri + "}" + local;
    }

    private String createPath(Path path) throws RepositoryException {
        StringBuilder builder = new StringBuilder();
        for (Path.Element element : path.getElements()) {
            if (builder.length() > 1 || builder.length() == 1 && !"/".equals(builder.toString())) {
                builder.append('/');
            }
            if (element.denotesRoot()) {
                builder.append('/');
                continue;
            }
            if (element.denotesIdentifier()) {
                builder.append('[').append(element.getIdentifier()).append(']');
                continue;
            }
            if (element.denotesName()) {
                builder.append(this.createName(element.getName()));
                if (element.getIndex() < 1) continue;
                builder.append('[').append(element.getIndex()).append(']');
                continue;
            }
            if (element.denotesParent()) {
                builder.append("..");
                continue;
            }
            if (element.denotesCurrent()) {
                builder.append('.');
                continue;
            }
            this.warn("Unknown element in path: " + path);
            builder.append(element.getString());
        }
        return builder.toString();
    }

    private String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat((String)this.parent.getPath(), (String)this.name);
        }
        return this.path;
    }

    private void warn(String message) {
        log.warn(this.getPath() + ": " + message);
    }

    private void warn(String message, Throwable cause) {
        log.warn(this.getPath() + ": " + message, cause);
    }
}

