/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.jcr2spi.nodetype.BitsetENTCacheImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.DefinitionValidator;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.nodetype.NodeTypeStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeRegistryImpl
implements NodeTypeRegistry,
EffectiveNodeTypeProvider {
    private static Logger log = LoggerFactory.getLogger(NodeTypeRegistryImpl.class);
    private final EffectiveNodeTypeCache entCache;
    private final NodeTypeDefinitionMap registeredNTDefs;
    private final NodeTypeStorage storage;
    private final DefinitionValidator validator;
    private final Map<NodeTypeRegistryListener, NodeTypeRegistryListener> listeners = Collections.synchronizedMap(new ReferenceMap(2, 2));

    public static NodeTypeRegistryImpl create(NodeTypeStorage storage, NamespaceRegistry nsRegistry) {
        NodeTypeRegistryImpl ntRegistry = new NodeTypeRegistryImpl(storage, nsRegistry);
        return ntRegistry;
    }

    public synchronized void dispose() {
        this.entCache.clear();
        this.registeredNTDefs.clear();
        this.listeners.clear();
    }

    private NodeTypeRegistryImpl(NodeTypeStorage storage, NamespaceRegistry nsRegistry) {
        this.storage = storage;
        this.validator = new DefinitionValidator(this, nsRegistry);
        this.entCache = new BitsetENTCacheImpl();
        this.registeredNTDefs = new NodeTypeDefinitionMap();
    }

    @Override
    public void addListener(NodeTypeRegistryListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    @Override
    public void removeListener(NodeTypeRegistryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Name[] getRegisteredNodeTypes() throws RepositoryException {
        Set<Name> qNames = this.registeredNTDefs.keySet();
        return qNames.toArray(new Name[this.registeredNTDefs.size()]);
    }

    @Override
    public boolean isRegistered(Name nodeTypeName) {
        return this.registeredNTDefs.containsKey(nodeTypeName);
    }

    @Override
    public synchronized void registerNodeTypes(Collection<QNodeTypeDefinition> ntDefs, boolean allowUpdate) throws NodeTypeExistsException, InvalidNodeTypeDefinitionException, RepositoryException {
        ArrayList<Name> added = new ArrayList<Name>();
        ArrayList<Name> modified = new ArrayList<Name>();
        for (QNodeTypeDefinition def : ntDefs) {
            Name name = def.getName();
            if (this.isRegistered(name)) {
                modified.add(name);
                continue;
            }
            added.add(name);
        }
        Map<QNodeTypeDefinition, EffectiveNodeType> defMap = this.validator.validateNodeTypeDefs(ntDefs, this.registeredNTDefs);
        this.storage.registerNodeTypes(ntDefs.toArray(new QNodeTypeDefinition[ntDefs.size()]), allowUpdate);
        this.internalUnregister(modified);
        this.internalRegister(defMap);
        for (Name ntName : added) {
            this.notifyRegistered(ntName);
        }
        for (Name ntName : modified) {
            this.notifyReRegistered(ntName);
        }
    }

    @Override
    public synchronized void unregisterNodeTypes(Collection<Name> nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
        for (Name ntName : nodeTypeNames) {
            Set dependents = this.registeredNTDefs.getDependentNodeTypes(ntName);
            dependents.removeAll(nodeTypeNames);
            if (dependents.size() <= 0) continue;
            StringBuffer msg = new StringBuffer();
            msg.append(ntName).append(" can not be removed because the following node types depend on it: ");
            for (Name name : dependents) {
                msg.append(name);
                msg.append(" ");
            }
            throw new RepositoryException(msg.toString());
        }
        this.storage.unregisterNodeTypes(nodeTypeNames.toArray(new Name[nodeTypeNames.size()]));
        this.internalUnregister(nodeTypeNames);
        for (Name ntName : nodeTypeNames) {
            this.notifyUnregistered(ntName);
        }
    }

    @Override
    public QNodeTypeDefinition getNodeTypeDefinition(Name nodeTypeName) throws NoSuchNodeTypeException {
        QNodeTypeDefinition def = this.registeredNTDefs.get(nodeTypeName);
        if (def == null) {
            throw new NoSuchNodeTypeException("Nodetype " + nodeTypeName + " doesn't exist");
        }
        return def;
    }

    @Override
    public synchronized EffectiveNodeType getEffectiveNodeType(Name ntName) throws NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntName, this.entCache, (Map<Name, QNodeTypeDefinition>)this.registeredNTDefs);
    }

    @Override
    public synchronized EffectiveNodeType getEffectiveNodeType(Name[] ntNames) throws ConstraintViolationException, NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntNames, this.entCache, (Map<Name, QNodeTypeDefinition>)this.registeredNTDefs);
    }

    @Override
    public EffectiveNodeType getEffectiveNodeType(Name[] ntNames, Map<Name, QNodeTypeDefinition> ntdMap) throws ConstraintViolationException, NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntNames, this.entCache, ntdMap);
    }

    @Override
    public EffectiveNodeType getEffectiveNodeType(QNodeTypeDefinition ntd, Map<Name, QNodeTypeDefinition> ntdMap) throws ConstraintViolationException, NoSuchNodeTypeException {
        List<QNodeDefinition> defs;
        Name name;
        String msg;
        TreeSet<Name> mergedNodeTypes = new TreeSet<Name>();
        TreeSet<Name> inheritedNodeTypes = new TreeSet<Name>();
        TreeSet<Name> allNodeTypes = new TreeSet<Name>();
        HashMap<Name, List<QItemDefinition>> namedItemDefs = new HashMap<Name, List<QItemDefinition>>();
        ArrayList<QItemDefinition> unnamedItemDefs = new ArrayList<QItemDefinition>();
        HashSet<Name> supportedMixins = null;
        Name ntName = ntd.getName();
        mergedNodeTypes.add(ntName);
        allNodeTypes.add(ntName);
        Name[] smixins = ntd.getSupportedMixinTypes();
        if (smixins != null) {
            supportedMixins = new HashSet<Name>();
            supportedMixins.addAll(Arrays.asList(smixins));
        }
        HashSet<QNodeDefinition> itemDefIds = new HashSet<QNodeDefinition>();
        for (QNodeDefinition qNodeDefinition : ntd.getChildNodeDefs()) {
            if (itemDefIds.contains(qNodeDefinition)) {
                msg = qNodeDefinition.definesResidual() ? ntName + " contains ambiguous residual child node definitions" : ntName + " contains ambiguous definitions for child node named " + qNodeDefinition.getName();
                log.debug(msg);
                throw new ConstraintViolationException(msg);
            }
            itemDefIds.add(qNodeDefinition);
            if (qNodeDefinition.definesResidual()) {
                unnamedItemDefs.add((QItemDefinition)qNodeDefinition);
                continue;
            }
            name = qNodeDefinition.getName();
            defs = (ArrayList<QNodeDefinition>)namedItemDefs.get(name);
            if (defs == null) {
                defs = new ArrayList<QNodeDefinition>();
                namedItemDefs.put(name, defs);
            }
            if (defs.size() > 0) {
                for (QItemDefinition qItemDefinition : defs) {
                    if (!qNodeDefinition.isAutoCreated() && !qItemDefinition.isAutoCreated()) continue;
                    String msg2 = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                    log.debug(msg2);
                    throw new ConstraintViolationException(msg2);
                }
            }
            defs.add(qNodeDefinition);
        }
        for (QNodeDefinition qNodeDefinition : ntd.getPropertyDefs()) {
            if (itemDefIds.contains(qNodeDefinition)) {
                msg = qNodeDefinition.definesResidual() ? ntName + " contains ambiguous residual property definitions" : ntName + " contains ambiguous definitions for property named " + qNodeDefinition.getName();
                log.debug(msg);
                throw new ConstraintViolationException(msg);
            }
            itemDefIds.add(qNodeDefinition);
            if (qNodeDefinition.definesResidual()) {
                unnamedItemDefs.add((QItemDefinition)qNodeDefinition);
                continue;
            }
            name = qNodeDefinition.getName();
            defs = (List)namedItemDefs.get(name);
            if (defs == null) {
                defs = new ArrayList();
                namedItemDefs.put(name, defs);
            }
            if (defs.size() > 0) {
                for (QItemDefinition qItemDefinition : defs) {
                    if (!qNodeDefinition.isAutoCreated() && !qItemDefinition.isAutoCreated()) continue;
                    String msg3 = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                    log.debug(msg3);
                    throw new ConstraintViolationException(msg3);
                }
            }
            defs.add(qNodeDefinition);
        }
        EffectiveNodeTypeImpl ent = new EffectiveNodeTypeImpl(mergedNodeTypes, inheritedNodeTypes, allNodeTypes, namedItemDefs, unnamedItemDefs, supportedMixins);
        Name[] supertypes = ntd.getSupertypes();
        if (supertypes.length > 0) {
            EffectiveNodeTypeImpl effSuperType = (EffectiveNodeTypeImpl)this.getEffectiveNodeType(supertypes, ntdMap);
            ent.internalMerge(effSuperType, true);
        }
        return ent;
    }

    private EffectiveNodeType getEffectiveNodeType(Name ntName, EffectiveNodeTypeCache entCache, Map<Name, QNodeTypeDefinition> ntdCache) throws NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(new Name[]{ntName});
        EffectiveNodeType ent = entCache.get(key);
        if (ent != null) {
            return ent;
        }
        QNodeTypeDefinition ntd = ntdCache.get(ntName);
        if (ntd == null) {
            throw new NoSuchNodeTypeException(ntName.toString());
        }
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            try {
                ent = this.getEffectiveNodeType(ntd, ntdCache);
                entCache.put(ent);
                return ent;
            }
            catch (ConstraintViolationException e) {
                String msg = "Internal error: encountered invalid registered node type " + ntName;
                log.debug(msg);
                throw new NoSuchNodeTypeException(msg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EffectiveNodeType getEffectiveNodeType(Name[] ntNames, EffectiveNodeTypeCache entCache, Map<Name, QNodeTypeDefinition> ntdCache) throws ConstraintViolationException, NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(ntNames);
        if (entCache.contains(key)) {
            return entCache.get(key);
        }
        for (Name ntName : ntNames) {
            if (ntdCache.containsKey(ntName)) continue;
            throw new NoSuchNodeTypeException(ntName.toString());
        }
        EffectiveNodeTypeCache.Key requested = key;
        EffectiveNodeTypeImpl result = null;
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            while (key.getNames().length > 0) {
                EffectiveNodeTypeCache.Key subKey = entCache.findBest(key);
                if (subKey != null) {
                    EffectiveNodeTypeImpl ent = (EffectiveNodeTypeImpl)entCache.get(subKey);
                    if (result == null) {
                        result = ent;
                    } else {
                        result = result.merge(ent);
                        entCache.put(result);
                    }
                    key = key.subtract(subKey);
                    continue;
                }
                for (Name remainder : key.getNames()) {
                    QNodeTypeDefinition ntd = ntdCache.get(remainder);
                    EffectiveNodeType ent = this.getEffectiveNodeType(ntd, ntdCache);
                    entCache.put(ent);
                    if (result == null) {
                        result = (EffectiveNodeTypeImpl)ent;
                        continue;
                    }
                    result = result.merge((EffectiveNodeTypeImpl)ent);
                    entCache.put(result);
                }
            }
        }
        if (!entCache.contains(requested)) {
            entCache.put(requested, result);
        }
        return result;
    }

    private void notifyRegistered(Name ntName) {
        for (NodeTypeRegistryListener ntrl : this.copyListeners()) {
            if (ntrl == null) continue;
            ntrl.nodeTypeRegistered(ntName);
        }
    }

    private void notifyReRegistered(Name ntName) {
        for (NodeTypeRegistryListener ntrl : this.copyListeners()) {
            if (ntrl == null) continue;
            ntrl.nodeTypeReRegistered(ntName);
        }
    }

    private void notifyUnregistered(Name ntName) {
        for (NodeTypeRegistryListener ntrl : this.copyListeners()) {
            if (ntrl == null) continue;
            ntrl.nodeTypeUnregistered(ntName);
        }
    }

    private NodeTypeRegistryListener[] copyListeners() {
        NodeTypeRegistryListener[] lstnrs = new NodeTypeRegistryListener[this.listeners.size()];
        int cnt = 0;
        for (NodeTypeRegistryListener ntrl : this.listeners.values()) {
            lstnrs[cnt++] = ntrl;
        }
        return lstnrs;
    }

    private void internalRegister(Map<QNodeTypeDefinition, EffectiveNodeType> defMap) {
        for (Map.Entry<QNodeTypeDefinition, EffectiveNodeType> entry : defMap.entrySet()) {
            QNodeTypeDefinition ntd = entry.getKey();
            this.internalRegister(ntd, entry.getValue());
        }
    }

    private void internalRegister(QNodeTypeDefinition ntd, EffectiveNodeType ent) {
        if (ent != null) {
            this.entCache.put(ent);
        } else {
            log.debug("Effective node type for " + ntd + " not yet built.");
        }
        this.registeredNTDefs.put(ntd.getName(), ntd);
    }

    private void internalUnregister(Name name) {
        QNodeTypeDefinition ntd = this.registeredNTDefs.remove(name);
        this.entCache.invalidate(name);
    }

    private void internalUnregister(Collection<Name> ntNames) {
        for (Name name : ntNames) {
            this.internalUnregister(name);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NodeTypeRegistry (").append(this).append(")\n");
        builder.append("Known NodeTypes:\n");
        builder.append(this.registeredNTDefs);
        builder.append("\n");
        builder.append(this.entCache);
        return builder.toString();
    }

    private class NodeTypeDefinitionMap
    implements Map<Name, QNodeTypeDefinition> {
        private Map<Name, QNodeTypeDefinition> nodetypeDefinitions = new HashMap<Name, QNodeTypeDefinition>();

        private NodeTypeDefinitionMap() {
        }

        private Collection<QNodeTypeDefinition> getValues() {
            return this.nodetypeDefinitions.values();
        }

        private Set<Name> getKeySet() {
            return this.nodetypeDefinitions.keySet();
        }

        private Set<Name> getDependentNodeTypes(Name nodeTypeName) throws NoSuchNodeTypeException {
            if (!this.nodetypeDefinitions.containsKey(nodeTypeName)) {
                throw new NoSuchNodeTypeException(nodeTypeName.toString());
            }
            HashSet<Name> names = new HashSet<Name>();
            for (QNodeTypeDefinition ntd : this.getValues()) {
                if (!ntd.getDependencies().contains(nodeTypeName)) continue;
                names.add(ntd.getName());
            }
            return names;
        }

        private void updateInternalMap(Iterator<QNodeTypeDefinition> definitions) {
            while (definitions.hasNext()) {
                NodeTypeRegistryImpl.this.internalRegister(definitions.next(), null);
            }
        }

        @Override
        public int size() {
            return this.nodetypeDefinitions.size();
        }

        @Override
        public void clear() {
            this.nodetypeDefinitions.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.nodetypeDefinitions.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof Name)) {
                return false;
            }
            return this.get(key) != null;
        }

        @Override
        public boolean containsValue(Object value) {
            if (!(value instanceof QNodeTypeDefinition)) {
                return false;
            }
            return this.get(((QNodeTypeDefinition)value).getName()) != null;
        }

        @Override
        public Set<Name> keySet() {
            try {
                Iterator it = NodeTypeRegistryImpl.this.storage.getAllDefinitions();
                this.updateInternalMap(it);
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
            return this.getKeySet();
        }

        @Override
        public Collection<QNodeTypeDefinition> values() {
            this.keySet();
            return this.getValues();
        }

        @Override
        public QNodeTypeDefinition put(Name key, QNodeTypeDefinition value) {
            return this.nodetypeDefinitions.put(key, value);
        }

        @Override
        public void putAll(Map<? extends Name, ? extends QNodeTypeDefinition> t) {
            throw new UnsupportedOperationException("Implementation missing");
        }

        @Override
        public Set<Map.Entry<Name, QNodeTypeDefinition>> entrySet() {
            this.keySet();
            return this.nodetypeDefinitions.entrySet();
        }

        @Override
        public QNodeTypeDefinition get(Object key) {
            if (!(key instanceof Name)) {
                throw new IllegalArgumentException();
            }
            QNodeTypeDefinition def = this.nodetypeDefinitions.get(key);
            if (def == null) {
                try {
                    Iterator it = NodeTypeRegistryImpl.this.storage.getDefinitions(new Name[]{(Name)key});
                    this.updateInternalMap(it);
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            def = this.nodetypeDefinitions.get(key);
            return def;
        }

        @Override
        public QNodeTypeDefinition remove(Object key) {
            return this.nodetypeDefinitions.remove(key);
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (QNodeTypeDefinition ntd : this.getValues()) {
                void var8_9;
                QNodeDefinition[] nd;
                builder.append(ntd.getName());
                Name[] supertypes = ntd.getSupertypes();
                builder.append("\n\tSupertypes");
                for (Name name : ntd.getSupertypes()) {
                    builder.append("\n\t\t").append(name);
                }
                builder.append("\n\tMixin\t").append(ntd.isMixin());
                builder.append("\n\tOrderableChildNodes\t").append(ntd.hasOrderableChildNodes());
                builder.append("\n\tPrimaryItemName\t").append(ntd.getPrimaryItemName() == null ? "<null>" : ntd.getPrimaryItemName().toString());
                for (Name name : ntd.getPropertyDefs()) {
                    builder.append("\n\tPropertyDefinition");
                    builder.append(" (declared in ").append(name.getDeclaringNodeType()).append(") ");
                    builder.append("\n\t\tName\t\t").append(name.definesResidual() ? "*" : name.getName().toString());
                    String type = "null";
                    if (name.getRequiredType() != 0) {
                        type = PropertyType.nameFromValue((int)name.getRequiredType());
                    }
                    builder.append("\n\t\tRequiredType\t").append(type);
                    builder.append("\n\t\tValueConstraints\t");
                    QValueConstraint[] vca = name.getValueConstraints();
                    if (vca == null) {
                        builder.append("<null>");
                    } else {
                        for (int n = 0; n < vca.length; ++n) {
                            if (n > 0) {
                                builder.append(", ");
                            }
                            builder.append(vca[n].getString());
                        }
                    }
                    QValue[] defVals = name.getDefaultValues();
                    StringBuffer defaultValues = new StringBuffer();
                    if (defVals == null) {
                        defaultValues.append("<null>");
                    } else {
                        for (QValue defVal : defVals) {
                            if (defaultValues.length() > 0) {
                                defaultValues.append(", ");
                            }
                            try {
                                defaultValues.append(defVal.getString());
                            }
                            catch (RepositoryException e) {
                                defaultValues.append(defVal.toString());
                            }
                        }
                    }
                    builder.append("\n\t\tDefaultValue\t").append(defaultValues.toString());
                    builder.append("\n\t\tAutoCreated\t").append(name.isAutoCreated());
                    builder.append("\n\t\tMandatory\t").append(name.isMandatory());
                    builder.append("\n\t\tOnVersion\t").append(OnParentVersionAction.nameFromValue((int)name.getOnParentVersion()));
                    builder.append("\n\t\tProtected\t").append(name.isProtected());
                    builder.append("\n\t\tMultiple\t").append(name.isMultiple());
                }
                QNodeDefinition[] arr$ = nd = ntd.getChildNodeDefs();
                int len$ = arr$.length;
                boolean bl = false;
                while (var8_9 < len$) {
                    Name defPrimaryType;
                    QNodeDefinition aNd = arr$[var8_9];
                    builder.append("\n\tNodeDefinition");
                    builder.append(" (declared in ").append(aNd.getDeclaringNodeType()).append(") ");
                    builder.append("\n\t\tName\t\t").append(aNd.definesResidual() ? "*" : aNd.getName().toString());
                    Name[] reqPrimaryTypes = aNd.getRequiredPrimaryTypes();
                    if (reqPrimaryTypes != null && reqPrimaryTypes.length > 0) {
                        for (Name reqPrimaryType : reqPrimaryTypes) {
                            builder.append("\n\t\tRequiredPrimaryType\t").append(reqPrimaryType);
                        }
                    }
                    if ((defPrimaryType = aNd.getDefaultPrimaryType()) != null) {
                        builder.append("\n\t\tDefaultPrimaryType\t").append(defPrimaryType);
                    }
                    builder.append("\n\t\tAutoCreated\t").append(aNd.isAutoCreated());
                    builder.append("\n\t\tMandatory\t").append(aNd.isMandatory());
                    builder.append("\n\t\tOnVersion\t").append(OnParentVersionAction.nameFromValue((int)aNd.getOnParentVersion()));
                    builder.append("\n\t\tProtected\t").append(aNd.isProtected());
                    builder.append("\n\t\tAllowsSameNameSiblings\t").append(aNd.allowsSameNameSiblings());
                    ++var8_9;
                }
            }
            return builder.toString();
        }
    }
}

