/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import javax.jcr.RangeIterator;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.test.api.query.AbstractQueryLevel2Test;
import org.apache.jackrabbit.test.api.query.Statement;

public class SQLQueryLevel2Test
extends AbstractQueryLevel2Test {
    public void testScoreColumn() throws Exception {
        this.setUpFullTextTest();
        QueryResult result = this.execute(this.getFullTextStatement());
        RowIterator rows = result.getRows();
        rows.nextRow().getValue(this.jcrScore);
    }

    public void testFullTextSearch() throws Exception {
        this.setUpFullTextTest();
        QueryResult result = this.execute(this.getFullTextStatement());
        this.checkResult(result, 1);
        RowIterator itr = result.getRows();
        while (itr.hasNext()) {
            String fullText;
            Row row = itr.nextRow();
            Value value = row.getValue(this.propertyName1);
            if (value == null || (fullText = value.getString()).indexOf("cat") <= 0) continue;
            SQLQueryLevel2Test.fail((String)"Search Text: full text search not correct, returned prohibited text");
        }
    }

    public void testRange() throws Exception {
        this.setUpRangeTest();
        QueryResult result = this.execute(this.getRangeStatement());
        this.checkResult(result, 1);
        this.checkValue(result.getRows(), this.propertyName1, "b");
    }

    public void testMultiValueSearch() throws Exception {
        this.setUpMultiValueTest();
        QueryResult result = this.execute(this.getMultiValueStatement());
        this.checkResult(result, 1);
        this.checkValue(result.getRows(), this.propertyName1, "existence");
    }

    public void testPathColumn() throws Exception {
        this.setUpFullTextTest();
        QueryResult result = this.execute(this.getFullTextStatement());
        RowIterator rows = result.getRows();
        if (this.getSize((RangeIterator)rows) < 1L) {
            SQLQueryLevel2Test.fail((String)"Query result did not return any nodes");
        }
        rows = result.getRows();
        rows.nextRow().getValue(this.jcrPath);
    }

    private Statement getFullTextStatement() {
        StringBuffer tmp = new StringBuffer("SELECT ");
        tmp.append(this.escapeIdentifierForSQL(this.propertyName1));
        tmp.append(" FROM ").append(this.escapeIdentifierForSQL(this.testNodeType));
        tmp.append(" WHERE CONTAINS(., '\"quick brown\" -cat')");
        tmp.append(" AND ").append(this.jcrPath).append(" LIKE '");
        tmp.append(this.testRoot).append("/%'");
        return new Statement(tmp.toString(), this.qsSQL);
    }

    private Statement getMultiValueStatement() {
        StringBuffer tmp = new StringBuffer("SELECT ");
        tmp.append(this.escapeIdentifierForSQL(this.propertyName1));
        tmp.append(" FROM ").append(this.escapeIdentifierForSQL(this.testNodeType));
        tmp.append(" WHERE 'two' IN ");
        tmp.append(this.escapeIdentifierForSQL(this.propertyName2));
        tmp.append(" AND 'existence' IN ");
        tmp.append(this.escapeIdentifierForSQL(this.propertyName1));
        tmp.append(" AND ").append(this.jcrPath).append(" LIKE '");
        tmp.append(this.testRoot).append("/%'");
        return new Statement(tmp.toString(), this.qsSQL);
    }

    private Statement getRangeStatement() {
        StringBuffer tmp = new StringBuffer("SELECT ");
        tmp.append(this.escapeIdentifierForSQL(this.propertyName1));
        tmp.append(" FROM ").append(this.escapeIdentifierForSQL(this.testNodeType));
        tmp.append(" WHERE ");
        tmp.append(this.escapeIdentifierForSQL(this.propertyName1));
        tmp.append(" <= 'b' AND ");
        tmp.append(this.escapeIdentifierForSQL(this.propertyName1));
        tmp.append(" > 'a'");
        tmp.append(" AND ").append(this.jcrPath).append(" LIKE '");
        tmp.append(this.testRoot).append("/%'");
        return new Statement(tmp.toString(), this.qsSQL);
    }
}

