/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class GetSupportedQueryLanguagesTest
extends AbstractQueryTest {
    private Session session;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.testRootNode = this.session.getRootNode().getNode(this.testPath);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testGetSupportedQueryLanguages() throws RepositoryException {
        List<String> langs = Arrays.asList(this.session.getWorkspace().getQueryManager().getSupportedQueryLanguages());
        GetSupportedQueryLanguagesTest.assertTrue((String)("JCR_SQL2 not returnd with QueryManager.getSupportedQueryLanguages(), got: " + langs), (boolean)langs.contains("JCR-SQL2"));
        if (this.isSupported("option.query.sql.supported")) {
            GetSupportedQueryLanguagesTest.assertTrue((String)("SQL not returned with QueryManager.getSupportedQueryLanguages(), got: " + langs), (boolean)langs.contains(this.qsSQL));
        }
    }
}

