/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.lock;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.lock.AbstractLockTest;

public class SessionScopedLockTest
extends AbstractLockTest {
    @Override
    protected boolean isSessionScoped() {
        return true;
    }

    @Override
    protected boolean isDeep() {
        return false;
    }

    public void testGetLockToken() {
        SessionScopedLockTest.assertNull((String)"A session scoped lock may never expose the token.", (Object)this.lock.getLockToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImplicitUnlock() throws RepositoryException, NotExecutableException {
        Session other = this.getHelper().getReadWriteSession();
        try {
            Node testNode = (Node)other.getItem(this.testRootNode.getPath());
            Node lockedNode = testNode.addNode(this.nodeName1, this.testNodeType);
            other.save();
            this.assertLockable(lockedNode);
            Lock lock = SessionScopedLockTest.getLockManager(other).lock(lockedNode.getPath(), this.isDeep(), this.isSessionScoped(), this.getTimeoutHint(), this.getLockOwner());
            other.logout();
            SessionScopedLockTest.assertFalse((boolean)lock.isLive());
        }
        finally {
            if (other.isLive()) {
                other.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImplicitUnlock2() throws RepositoryException, NotExecutableException {
        Session other = this.getHelper().getReadWriteSession();
        try {
            Node testNode = (Node)other.getItem(this.testRootNode.getPath());
            Node lockedNode = testNode.addNode(this.nodeName1, this.testNodeType);
            other.save();
            this.assertLockable(lockedNode);
            LockManager lMgr = SessionScopedLockTest.getLockManager(other);
            Lock lock = lMgr.lock(lockedNode.getPath(), this.isDeep(), this.isSessionScoped(), this.getTimeoutHint(), this.getLockOwner());
            this.testRootNode.refresh(false);
            Node n = (Node)this.superuser.getItem(lockedNode.getPath());
            other.logout();
            SessionScopedLockTest.assertFalse((boolean)n.isLocked());
            SessionScopedLockTest.assertFalse((boolean)n.holdsLock());
            try {
                n.getLock();
                SessionScopedLockTest.fail((String)"Upon logout of the session a session-scoped lock must be gone.");
            }
            catch (LockException lockException) {
                // empty catch block
            }
        }
        finally {
            if (other.isLive()) {
                other.logout();
            }
        }
    }
}

