/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceCopyTest;

public class WorkspaceCopyTest
extends AbstractWorkspaceCopyTest {
    public void testCopyNodes() throws RepositoryException {
        String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
        this.workspace.copy(this.node1.getPath(), dstAbsPath);
        WorkspaceCopyTest.assertFalse((boolean)this.superuser.hasPendingChanges());
    }

    public void testCopyNodesAbsolutePath() {
        try {
            String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName() + "[2]";
            this.workspace.copy(this.node1.getPath(), dstAbsPath);
            WorkspaceCopyTest.fail((String)"Copying a node to an absolute path containing index should not be possible.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testCopyNodesConstraintViolationException() throws RepositoryException {
        String nodetype = this.testNodeTypeNoChildren == null ? this.ntBase : this.testNodeTypeNoChildren;
        Node subNodesNotAllowedNode = this.testRootNode.addNode(this.nodeName3, nodetype);
        this.testRootNode.getSession().save();
        try {
            String dstAbsPath = subNodesNotAllowedNode.getPath() + "/" + this.node2.getName();
            this.workspace.copy(this.node2.getPath(), dstAbsPath);
            WorkspaceCopyTest.fail((String)"Copying a node below a node which can not have any sub nodes should throw a ConstraintViolationException.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyNodesAccessDenied() throws RepositoryException {
        Session readOnlySuperuser = this.getHelper().getReadOnlySession();
        try {
            String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
            try {
                readOnlySuperuser.getWorkspace().copy(this.node1.getPath(), dstAbsPath);
                WorkspaceCopyTest.fail((String)"Copy in a read-only session should throw an AccessDeniedException.");
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
        }
        finally {
            readOnlySuperuser.logout();
        }
    }

    public void testCopyNodesPathNotExisting() throws RepositoryException {
        String srcAbsPath = this.node1.getPath();
        String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
        String invalidSrcPath = srcAbsPath + "invalid";
        try {
            this.workspace.copy(invalidSrcPath, dstAbsPath);
            WorkspaceCopyTest.fail((String)("Not existing source path '" + invalidSrcPath + "' should throw PathNotFoundException."));
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        String invalidDstParentPath = this.node2.getPath() + "invalid/" + this.node1.getName();
        try {
            this.workspace.copy(srcAbsPath, invalidDstParentPath);
            WorkspaceCopyTest.fail((String)("Not existing destination parent path '" + invalidDstParentPath + "' should throw PathNotFoundException."));
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyNodesLocked() throws RepositoryException, NotExecutableException {
        String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
        Session otherSession = this.getHelper().getReadWriteSession();
        try {
            Node lockTarget = (Node)otherSession.getItem(this.node2.getPath());
            this.ensureMixinType(lockTarget, this.mixLockable);
            lockTarget.getParent().save();
            lockTarget.lock(true, true);
            try {
                this.workspace.copy(this.node1.getPath(), dstAbsPath);
                WorkspaceCopyTest.fail((String)"LockException was expected.");
                return;
            }
            catch (LockException lockException) {
                return;
            }
            finally {
                lockTarget.unlock();
            }
        }
        finally {
            otherSession.logout();
        }
    }
}

