/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.math.BigDecimal;
import javax.jcr.Node;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetPropertyDecimalTest
extends AbstractJCRTest {
    private Node testNode;
    private BigDecimal b1 = new BigDecimal("-123545678901234567890123545678901234567890.123545678901234567890");
    private BigDecimal b2 = new BigDecimal("123545678901234567890123545678901234567890.123545678901234567890");

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureCanSetProperty(this.testNode, this.propertyName1, this.testNode.getSession().getValueFactory().createValue(new BigDecimal(0)));
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testNewDecimalPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.b1);
        this.superuser.save();
        SetPropertyDecimalTest.assertEquals((String)"Setting property with Node.setProperty(String, double) and Session.save() not working", (Object)this.b1, (Object)this.testNode.getProperty(this.propertyName1).getDecimal());
    }

    public void testModifyDecimalPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.b1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, this.b2);
        this.superuser.save();
        SetPropertyDecimalTest.assertEquals((String)"Modifying property with Node.setProperty(String, double) and Session.save() not working", (Object)this.b2, (Object)this.testNode.getProperty(this.propertyName1).getDecimal());
    }

    public void testRemoveDecimalPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.b1);
        this.testRootNode.getSession().save();
        this.testNode.setProperty(this.propertyName1, (Value)null);
        this.testRootNode.getSession().save();
        SetPropertyDecimalTest.assertFalse((String)"Removing decimal property with Node.setProperty(String, null) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }
}

