/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.NoSuchElementException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import junit.framework.Assert;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.PropertyUtil;

public class PropertyReadMethodsTest
extends AbstractJCRTest {
    private Session session;
    private Property property;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.testRootNode = this.session.getRootNode().getNode(this.testPath);
        PropertyIterator properties = this.testRootNode.getProperties();
        try {
            this.property = properties.nextProperty();
        }
        catch (NoSuchElementException e) {
            PropertyReadMethodsTest.fail((String)"Any node must have at least one property set: jcr:primaryType");
        }
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.property = null;
        super.tearDown();
    }

    public void testGetPath() throws NotExecutableException, RepositoryException {
        PropertyReadMethodsTest.assertEquals((String)"getPath returns wrong result", (String)(this.testRoot + "/" + this.property.getName()), (String)this.property.getPath());
    }

    public void testGetName() throws RepositoryException {
        String path = this.property.getPath();
        String name = path.substring(path.lastIndexOf("/") + 1);
        PropertyReadMethodsTest.assertEquals((String)"getName() must be the same as the last item in the path", (String)name, (String)this.property.getName());
    }

    public void testGetAncestorOfItemDepth() throws RepositoryException {
        Property propertyAtDepth = (Property)this.property.getAncestor(this.property.getDepth());
        PropertyReadMethodsTest.assertTrue((String)"The ancestor of depth = n, where n is the depth of this Property must be the item itself.", (boolean)this.property.isSame((Item)propertyAtDepth));
    }

    public void testGetAncestorOfGreaterDepth() throws RepositoryException {
        try {
            int greaterDepth = this.property.getDepth() + 1;
            this.property.getAncestor(greaterDepth);
            PropertyReadMethodsTest.fail((String)"Getting ancestor of depth n, where n is greater than depth ofthis Property must throw an ItemNotFoundException");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testGetAncestorOfNegativeDepth() throws RepositoryException {
        try {
            this.property.getAncestor(-1);
            PropertyReadMethodsTest.fail((String)"Getting ancestor of depth < 0 must throw an ItemNotFoundException.");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testGetParent() throws RepositoryException {
        PropertyReadMethodsTest.assertTrue((String)"getParent() of a property must return the parent node.", (boolean)this.testRootNode.isSame((Item)this.property.getParent()));
    }

    public void testGetDepth() throws RepositoryException {
        PropertyReadMethodsTest.assertEquals((String)"getDepth() of a property of root must be 1", (int)(this.testRootNode.getDepth() + 1), (int)this.property.getDepth());
    }

    public void testGetSession() throws RepositoryException {
        PropertyReadMethodsTest.assertSame((String)"getSession must return the Session through which the Property was acquired.", (Object)this.property.getSession(), (Object)this.session);
    }

    public void testIsMultiple() throws RepositoryException {
        PropertyReadMethodsTest.assertEquals((String)"Property.isMultiple() must be consistent with PropertyDefinition.isMultiple()", (boolean)this.property.isMultiple(), (boolean)this.property.getDefinition().isMultiple());
    }

    public void testIsNode() {
        PropertyReadMethodsTest.assertFalse((String)"isNode() must return false.", (boolean)this.property.isNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSame() throws RepositoryException {
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Property otherProperty = otherSession.getRootNode().getNode(this.testPath).getProperty(this.property.getName());
            PropertyReadMethodsTest.assertTrue((String)"isSame must return true for the same property retrieved through different sessions.", (boolean)this.property.isSame((Item)otherProperty));
        }
        finally {
            otherSession.logout();
        }
    }

    public void testAccept() throws RepositoryException {
        final Property p = this.property;
        ItemVisitor itemVisitor = new ItemVisitor(){

            public void visit(Property property) throws RepositoryException {
                Assert.assertTrue((String)"Visited Property is not the same as the one returned by visit(Property).", (boolean)p.isSame((Item)property));
            }

            public void visit(Node node) {
                Assert.fail((String)"Wrong accept method executed.");
            }
        };
        p.accept(itemVisitor);
    }

    public void testNoNullValue() throws RepositoryException {
        PropertyReadMethodsTest.assertFalse((String)"Single property with null value found.", (boolean)PropertyUtil.nullValues(this.testRootNode));
    }

    public void testMultiValueType() throws RepositoryException, NotExecutableException {
        Property multiValProp = PropertyUtil.searchMultivalProp(this.testRootNode);
        if (multiValProp != null) {
            Value[] vals = multiValProp.getValues();
            if (vals.length > 0) {
                int type = vals[0].getType();
                for (int i = 1; i < vals.length; ++i) {
                    PropertyReadMethodsTest.assertEquals((String)"Multivalue property has values with different types.", (int)type, (int)vals[i].getType());
                }
            }
        } else {
            throw new NotExecutableException();
        }
    }

    public void testGetValue() throws RepositoryException, NotExecutableException {
        Property multiValProp = PropertyUtil.searchMultivalProp(this.testRootNode);
        if (multiValProp != null) {
            try {
                multiValProp.getValue();
                PropertyReadMethodsTest.fail((String)"Property.getValue() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {}
        } else {
            throw new NotExecutableException();
        }
    }

    public void testGetValues() throws RepositoryException, NotExecutableException {
        Property singleProp = PropertyUtil.searchSingleValuedProperty(this.testRootNode);
        if (singleProp == null) {
            throw new NotExecutableException("No single valued property found.");
        }
        try {
            singleProp.getValues();
            PropertyReadMethodsTest.fail((String)"Property.getValues() called on a single property should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetValueCopyStoredValues() throws NotExecutableException, RepositoryException {
        Property prop = PropertyUtil.searchMultivalProp(this.testRootNode);
        if (prop == null) {
            throw new NotExecutableException("No multivalued property found.");
        }
        Value[] values = prop.getValues();
        if (values.length == 0) {
            throw new NotExecutableException("No testable property found.");
        }
        values[0] = null;
        Value[] values2 = prop.getValues();
        PropertyReadMethodsTest.assertNotNull((String)"Changes on the array returned by Property.getValues() must not be reflected in the internal storage.", (Object)values2[0]);
    }

    public void testGetNode() throws RepositoryException, NotExecutableException {
        Property prop = PropertyUtil.searchMultivalProp(this.testRootNode);
        if (prop == null) {
            throw new NotExecutableException("Test Property.getNode is throwing a ValueFormaException not executable in case of a multivalued property.");
        }
        try {
            prop.getNode();
            PropertyReadMethodsTest.fail((String)"Property.getNode should throw a ValueFormatException in case of a multivalued property.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }
}

