/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.jdbc.rowset.OracleWebRowSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class OracleWebRowSetXmlReaderContHandler
extends DefaultHandler {
    private OracleWebRowSet wrset;
    private RowSetMetaData rsetMetaData;
    private Vector updatesToRowSet;
    private Vector keyCols;
    private String columnValue;
    private String propertyValue;
    private String metadataValue;
    private boolean isNullValue;
    private int columnIndex;
    private Hashtable propertyNameTagMap;
    private Hashtable metadataNameTagMap;
    private Hashtable dataNameTagMap;
    protected static final String WEBROWSET_ELEMENT_NAME = "webRowSet";
    protected static final String PROPERTIES_ELEMENT_NAME = "properties";
    protected static final String METADATA_ELEMENT_NAME = "metadata";
    protected static final String DATA_ELEMENT_NAME = "data";
    private int state;
    private static final int INITIAL_STATE = 0;
    private static final int PROPERTIES_STATE = 1;
    private static final int METADATA_STATE = 2;
    private static final int DATA_STATE = 3;
    private int tag;
    private static final int NO_TAG = -1;
    private String[] propertyNames = new String[]{"command", "concurrency", "datasource", "escape-processing", "fetch-direction", "fetch-size", "isolation-level", "key-columns", "map", "max-field-size", "max-rows", "query-timeout", "read-only", "rowset-type", "show-deleted", "table-name", "url", "sync-provider", "null", "column", "type", "class", "sync-provider-name", "sync-provider-vendor", "sync-provider-version", "sync-provider-grade", "data-source-lock"};
    private boolean readReadOnlyValue;
    private static final int PROPERTY_COMMAND_TAG = 0;
    private static final int PROPERTY_CONCURRENCY_TAG = 1;
    private static final int PROPERTY_DATASOURCETAG = 2;
    private static final int PROPERTY_ESCAPEPROCESSING_TAG = 3;
    private static final int PROPERTY_FETCHDIRECTION_TAG = 4;
    private static final int PROPERTY_FETCHSIZE_TAG = 5;
    private static final int PROPERTY_ISOLATIONLEVEL_TAG = 6;
    private static final int PROPERTY_KEYCOLUMNS_TAG = 7;
    private static final int PROPERTY_MAP_TAG = 8;
    private static final int PROPERTY_MAXFIELDSIZE_TAG = 9;
    private static final int PROPERTY_MAXROWS_TAG = 10;
    private static final int PROPERTY_QUERYTIMEOUT_TAG = 11;
    private static final int PROPERTY_READONLY_TAG = 12;
    private static final int PROPERTY_ROWSETTYPE_TAG = 13;
    private static final int PROPERTY_SHOWDELETED_TAG = 14;
    private static final int PROPERTY_TABLENAME_TAG = 15;
    private static final int PROPERTY_URL_TAG = 16;
    private static final int PROPERTY_SYNCPROVIDER_TAG = 17;
    private static final int PROPERTY_NULL_TAG = 18;
    private static final int PROPERTY_COLUMN_TAG = 19;
    private static final int PROPERTY_TYPE_TAG = 20;
    private static final int PROPERTY_CLASS_TAG = 21;
    private static final int PROPERTY_SYNCPROVIDERNAME_TAG = 22;
    private static final int PROPERTY_SYNCPROVIDERVENDOR_TAG = 23;
    private static final int PROPERTY_SYNCPROVIDERVERSION_TAG = 24;
    private static final int PROPERTY_SYNCPROVIDERGRADE_TAG = 25;
    private static final int PROPERTY_DATASOURCELOCK_TAG = 26;
    private String[] metadataNames = new String[]{"column-count", "column-definition", "column-index", "auto-increment", "case-sensitive", "currency", "nullable", "signed", "searchable", "column-display-size", "column-label", "column-name", "schema-name", "column-precision", "column-scale", "table-name", "catalog-name", "column-type", "column-type-name", "null"};
    private static final int METADATA_COLUMNCOUNT_TAG = 0;
    private static final int METADATA_COLUMNDEFINITION_TAG = 1;
    private static final int METADATA_COLUMNINDEX_TAG = 2;
    private static final int METADATA_AUTOINCREMENT_TAG = 3;
    private static final int METADATA_CASESENSITIVE_TAG = 4;
    private static final int METADATA_CURRENCY_TAG = 5;
    private static final int METADATA_NULLABLE_TAG = 6;
    private static final int METADATA_SIGNED_TAG = 7;
    private static final int METADATA_SEARCHABLE_TAG = 8;
    private static final int METADATA_COLUMNDISPLAYSIZE_TAG = 9;
    private static final int METADATA_COLUMNLABEL_TAG = 10;
    private static final int METADATA_COLUMNNAME_TAG = 11;
    private static final int METADATA_SCHEMANAME_TAG = 12;
    private static final int METADATA_COLUMNPRECISION_TAG = 13;
    private static final int METADATA_COLUMNSCALE_TAG = 14;
    private static final int METADATA_TABLENAME_TAG = 15;
    private static final int METADATA_CATALOGNAME_TAG = 16;
    private static final int METADATA_COLUMNTYPE_TAG = 17;
    private static final int METADATA_COLUMNTYPENAME_TAG = 18;
    private static final int METADATA_NULL_TAG = 19;
    private String[] dataNames = new String[]{"currentRow", "insertRow", "deleteRow", "modifyRow", "columnValue", "updateValue", "null"};
    private static final int DATA_CURRENTROW_TAG = 0;
    private static final int DATA_INSERTROW_TAG = 1;
    private static final int DATA_DELETEROW_TAG = 2;
    private static final int DATA_MODIFYROW_TAG = 3;
    private static final int DATA_COLUMNVALUE_TAG = 4;
    private static final int DATA_UPDATEVALUE_TAG = 5;
    private static final int DATA_NULL_TAG = 6;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    OracleWebRowSetXmlReaderContHandler(RowSet rowSet) {
        this.wrset = (OracleWebRowSet)rowSet;
        this.initialize();
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        String string = new String(cArray, n2, n3);
        this.processElement(string);
    }

    public void endDocument() throws SAXException {
        try {
            if (this.readReadOnlyValue) {
                this.wrset.setReadOnly(this.readReadOnlyValue);
            }
        }
        catch (SQLException sQLException) {
            throw new SAXException(sQLException.getMessage());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2 == null || string2.equals("") ? string3 : string2;
        block8 : switch (this.getState()) {
            case 1: {
                if (string4.equals(PROPERTIES_ELEMENT_NAME)) {
                    this.state = 0;
                    break;
                }
                try {
                    int n2 = (Integer)this.propertyNameTagMap.get(string4);
                    switch (n2) {
                        case 7: {
                            if (this.keyCols == null) break;
                            int[] nArray = new int[this.keyCols.size()];
                            for (int i2 = 0; i2 < nArray.length; ++i2) {
                                nArray[i2] = Integer.parseInt((String)this.keyCols.elementAt(i2));
                            }
                            this.wrset.setKeyColumns(nArray);
                        }
                    }
                    this.setPropertyValue(this.propertyValue);
                }
                catch (SQLException sQLException) {
                    throw new SAXException(sQLException.getMessage());
                }
                this.propertyValue = "";
                this.setNullValue(false);
                this.setTag(-1);
                break;
            }
            case 2: {
                if (string4.equals(METADATA_ELEMENT_NAME)) {
                    try {
                        this.wrset.setMetaData(this.rsetMetaData);
                        this.state = 0;
                        break;
                    }
                    catch (SQLException sQLException) {
                        throw new SAXException("Error setting metadata in WebRowSet: " + sQLException.getMessage());
                    }
                }
                try {
                    this.setMetaDataValue(this.metadataValue);
                }
                catch (SQLException sQLException) {
                    throw new SAXException("Error setting metadata value: " + sQLException.getMessage());
                }
                this.metadataValue = "";
                this.setNullValue(false);
                this.setTag(-1);
                break;
            }
            case 3: {
                if (string4.equals(DATA_ELEMENT_NAME)) {
                    this.state = 0;
                    return;
                }
                int n3 = (Integer)this.dataNameTagMap.get(string4);
                switch (n3) {
                    default: {
                        break block8;
                    }
                    case 4: {
                        try {
                            ++this.columnIndex;
                            this.insertValue(this.columnValue);
                            this.columnValue = "";
                            this.setNullValue(false);
                            this.setTag(-1);
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error inserting column values: " + sQLException.getMessage());
                        }
                    }
                    case 0: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            OracleRow oracleRow = this.wrset.getCurrentRow();
                            oracleRow.setInsertedFlag(false);
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing current row: " + sQLException.getMessage());
                        }
                    }
                    case 2: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            OracleRow oracleRow = this.wrset.getCurrentRow();
                            oracleRow.setInsertedFlag(false);
                            oracleRow.setRowDeleted(true);
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing deleted row: " + sQLException.getMessage());
                        }
                    }
                    case 1: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing inserted row: " + sQLException.getMessage());
                        }
                    }
                    case 3: 
                }
                try {
                    this.wrset.insertRow();
                    this.wrset.moveToCurrentRow();
                    this.wrset.next();
                    OracleRow oracleRow = this.wrset.getCurrentRow();
                    oracleRow.setRowDeleted(true);
                    this.applyUpdates();
                    break;
                }
                catch (SQLException sQLException) {
                    throw new SAXException("Error constructing modified row: " + sQLException.getMessage());
                }
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2 == null || string2.equals("") ? string3 : string2;
        switch (this.getState()) {
            case 1: {
                int n2 = (Integer)this.propertyNameTagMap.get(string4);
                if (n2 == 18) {
                    this.setNullValue(true);
                    this.propertyValue = null;
                    break;
                }
                this.setTag(n2);
                break;
            }
            case 2: {
                int n3 = (Integer)this.metadataNameTagMap.get(string4);
                if (n3 == 19) {
                    this.setNullValue(true);
                    this.metadataValue = null;
                    break;
                }
                this.setTag(n3);
                break;
            }
            case 3: {
                int n4 = (Integer)this.dataNameTagMap.get(string4);
                if (n4 == 6) {
                    this.setNullValue(true);
                    this.columnValue = null;
                    break;
                }
                this.setTag(n4);
                if (n4 != 0 && n4 != 1 && n4 != 2 && n4 != 3) break;
                this.columnIndex = 0;
                try {
                    this.wrset.moveToInsertRow();
                }
                catch (SQLException sQLException) {}
                break;
            }
            default: {
                this.setState(string4);
            }
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private void initialize() {
        int n2;
        this.propertyNameTagMap = new Hashtable(30);
        int n3 = this.propertyNames.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.propertyNameTagMap.put(this.propertyNames[n2], n2);
        }
        this.metadataNameTagMap = new Hashtable(30);
        n3 = this.metadataNames.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.metadataNameTagMap.put(this.metadataNames[n2], n2);
        }
        this.dataNameTagMap = new Hashtable(10);
        n3 = this.dataNames.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.dataNameTagMap.put(this.dataNames[n2], n2);
        }
        this.updatesToRowSet = new Vector();
        this.columnValue = "";
        this.propertyValue = "";
        this.metadataValue = "";
        this.isNullValue = false;
        this.columnIndex = 0;
        this.readReadOnlyValue = false;
    }

    protected void processElement(String string) throws SAXException {
        try {
            switch (this.getState()) {
                case 1: {
                    this.propertyValue = string;
                    break;
                }
                case 2: {
                    this.metadataValue = string;
                    break;
                }
                case 3: {
                    this.setDataValue(string);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SAXException("processElement: " + sQLException.getMessage());
        }
    }

    private BigDecimal getBigDecimalValue(String string) {
        return new BigDecimal(string);
    }

    private byte[] getBinaryValue(String string) {
        return string.getBytes();
    }

    private boolean getBooleanValue(String string) {
        return Boolean.valueOf(string);
    }

    private byte getByteValue(String string) {
        return Byte.parseByte(string);
    }

    private Date getDateValue(String string) {
        return new Date(this.getLongValue(string));
    }

    private double getDoubleValue(String string) {
        return Double.parseDouble(string);
    }

    private float getFloatValue(String string) {
        return Float.parseFloat(string);
    }

    private int getIntegerValue(String string) {
        return Integer.parseInt(string);
    }

    private long getLongValue(String string) {
        return Long.parseLong(string);
    }

    private boolean getNullValue() {
        return this.isNullValue;
    }

    private short getShortValue(String string) {
        return Short.parseShort(string);
    }

    private String getStringValue(String string) {
        return string;
    }

    private Time getTimeValue(String string) {
        return new Time(this.getLongValue(string));
    }

    private Timestamp getTimestampValue(String string) {
        return new Timestamp(this.getLongValue(string));
    }

    private Blob getBlobValue(String string) throws SQLException {
        return new OracleSerialBlob(string.getBytes());
    }

    private Clob getClobValue(String string) throws SQLException {
        return new OracleSerialClob(string.toCharArray());
    }

    private void applyUpdates() throws SAXException {
        if (this.updatesToRowSet.size() > 0) {
            try {
                for (Object[] objectArray : this.updatesToRowSet) {
                    this.columnIndex = (Integer)objectArray[0];
                    this.insertValue((String)objectArray[1]);
                }
                this.wrset.updateRow();
            }
            catch (SQLException sQLException) {
                throw new SAXException("Error updating row: " + sQLException.getMessage());
            }
            this.updatesToRowSet.removeAllElements();
        }
    }

    private void insertValue(String string) throws SQLException {
        if (this.getNullValue() || string == null) {
            this.wrset.updateNull(this.columnIndex);
            return;
        }
        int n2 = this.wrset.getMetaData().getColumnType(this.columnIndex);
        switch (n2) {
            case -7: {
                this.wrset.updateByte(this.columnIndex, this.getByteValue(string));
                break;
            }
            case 5: {
                this.wrset.updateShort(this.columnIndex, this.getShortValue(string));
                break;
            }
            case 4: {
                this.wrset.updateInt(this.columnIndex, this.getIntegerValue(string));
                break;
            }
            case -5: {
                this.wrset.updateLong(this.columnIndex, this.getLongValue(string));
                break;
            }
            case 6: 
            case 7: {
                this.wrset.updateFloat(this.columnIndex, this.getFloatValue(string));
                break;
            }
            case 8: {
                this.wrset.updateDouble(this.columnIndex, this.getDoubleValue(string));
                break;
            }
            case 2: 
            case 3: {
                this.wrset.updateObject(this.columnIndex, (Object)this.getBigDecimalValue(string));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.wrset.updateBytes(this.columnIndex, this.getBinaryValue(string));
                break;
            }
            case 91: {
                this.wrset.updateDate(this.columnIndex, this.getDateValue(string));
                break;
            }
            case 92: {
                this.wrset.updateTime(this.columnIndex, this.getTimeValue(string));
                break;
            }
            case 93: {
                this.wrset.updateTimestamp(this.columnIndex, this.getTimestampValue(string));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.wrset.updateString(this.columnIndex, this.getStringValue(string));
                break;
            }
            case 2004: {
                this.wrset.updateBlob(this.columnIndex, this.getBlobValue(string));
                break;
            }
            case 2005: {
                this.wrset.updateClob(this.columnIndex, this.getClobValue(string));
                break;
            }
            default: {
                throw new SQLException("The type " + n2 + " is not supported currently.");
            }
        }
    }

    private void setPropertyValue(String string) throws SQLException {
        boolean bl = this.getNullValue();
        switch (this.getTag()) {
            default: {
                break;
            }
            case 0: {
                if (bl) {
                    this.wrset.setCommand(null);
                    break;
                }
                this.wrset.setCommand(string);
                break;
            }
            case 1: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.wrset.setConcurrency(this.getIntegerValue(string));
                break;
            }
            case 2: {
                if (bl) {
                    this.wrset.setDataSourceName(null);
                    break;
                }
                this.wrset.setDataSourceName(string);
                break;
            }
            case 3: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.wrset.setEscapeProcessing(this.getBooleanValue(string));
                break;
            }
            case 4: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n2 = this.wrset.getType();
                if (n2 == 1005) break;
                this.wrset.setFetchDirection(this.getIntegerValue(string));
                break;
            }
            case 5: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.wrset.setFetchSize(this.getIntegerValue(string));
                break;
            }
            case 6: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.wrset.setTransactionIsolation(this.getIntegerValue(string));
                break;
            }
            case 19: {
                if (this.keyCols == null) {
                    this.keyCols = new Vector();
                }
                this.keyCols.add(string);
                break;
            }
            case 9: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.wrset.setMaxFieldSize(this.getIntegerValue(string));
                break;
            }
            case 10: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.wrset.setMaxRows(this.getIntegerValue(string));
                break;
            }
            case 11: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.wrset.setQueryTimeout(this.getIntegerValue(string));
                break;
            }
            case 12: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.readReadOnlyValue = this.getBooleanValue(string);
                break;
            }
            case 13: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.wrset.setType(this.getIntegerValue(string));
                break;
            }
            case 14: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.wrset.setShowDeleted(this.getBooleanValue(string));
                break;
            }
            case 15: {
                if (bl) {
                    this.wrset.setTableName(null);
                    break;
                }
                this.wrset.setTableName(string);
                break;
            }
            case 16: {
                if (bl) {
                    this.wrset.setUrl(null);
                    break;
                }
                this.wrset.setUrl(string);
                break;
            }
            case 22: {
                if (bl) {
                    this.wrset.setSyncProvider(null);
                    break;
                }
                this.wrset.setSyncProvider(string);
            }
        }
    }

    private void setMetaDataValue(String string) throws SQLException {
        boolean bl = this.getNullValue();
        switch (this.getTag()) {
            default: {
                break;
            }
            case 0: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n2 = this.getIntegerValue(string);
                this.rsetMetaData = new OracleRowSetMetaData(n2);
                this.columnIndex = 0;
                break;
            }
            case 2: {
                ++this.columnIndex;
                break;
            }
            case 3: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.rsetMetaData.setAutoIncrement(this.columnIndex, this.getBooleanValue(string));
                break;
            }
            case 4: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.rsetMetaData.setCaseSensitive(this.columnIndex, this.getBooleanValue(string));
                break;
            }
            case 5: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.rsetMetaData.setCurrency(this.columnIndex, this.getBooleanValue(string));
                break;
            }
            case 6: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.rsetMetaData.setNullable(this.columnIndex, this.getIntegerValue(string));
                break;
            }
            case 7: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.rsetMetaData.setSigned(this.columnIndex, this.getBooleanValue(string));
                break;
            }
            case 8: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.rsetMetaData.setSearchable(this.columnIndex, this.getBooleanValue(string));
                break;
            }
            case 9: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.rsetMetaData.setColumnDisplaySize(this.columnIndex, this.getIntegerValue(string));
                break;
            }
            case 10: {
                if (bl) {
                    this.rsetMetaData.setColumnLabel(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setColumnLabel(this.columnIndex, string);
                break;
            }
            case 11: {
                if (bl) {
                    this.rsetMetaData.setColumnName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setColumnName(this.columnIndex, string);
                break;
            }
            case 12: {
                if (bl) {
                    this.rsetMetaData.setSchemaName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setSchemaName(this.columnIndex, string);
                break;
            }
            case 13: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.rsetMetaData.setPrecision(this.columnIndex, this.getIntegerValue(string));
                break;
            }
            case 14: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.rsetMetaData.setScale(this.columnIndex, this.getIntegerValue(string));
                break;
            }
            case 15: {
                if (bl) {
                    this.rsetMetaData.setTableName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setTableName(this.columnIndex, string);
                break;
            }
            case 16: {
                if (bl) {
                    this.rsetMetaData.setCatalogName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setCatalogName(this.columnIndex, string);
                break;
            }
            case 17: {
                if (bl) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.rsetMetaData.setColumnType(this.columnIndex, this.getIntegerValue(string));
                break;
            }
            case 18: {
                if (bl) {
                    this.rsetMetaData.setColumnTypeName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setColumnTypeName(this.columnIndex, string);
            }
        }
    }

    private void setDataValue(String string) throws SQLException {
        switch (this.getTag()) {
            default: {
                break;
            }
            case 4: {
                this.columnValue = string;
                break;
            }
            case 5: {
                Object[] objectArray = new Object[2];
                objectArray[1] = string;
                objectArray[0] = this.columnIndex;
                this.updatesToRowSet.add(objectArray);
            }
        }
    }

    protected void setNullValue(boolean bl) {
        this.isNullValue = bl;
    }

    private int getState() {
        return this.state;
    }

    private int getTag() {
        return this.tag;
    }

    private void setState(String string) throws SAXException {
        if (string.equals(WEBROWSET_ELEMENT_NAME)) {
            this.state = 0;
        } else if (string.equals(PROPERTIES_ELEMENT_NAME)) {
            this.state = this.state != 1 ? 1 : 0;
        } else if (string.equals(METADATA_ELEMENT_NAME)) {
            this.state = this.state != 2 ? 2 : 0;
        } else if (string.equals(DATA_ELEMENT_NAME)) {
            this.state = this.state != 3 ? 3 : 0;
        }
    }

    private void setTag(int n2) {
        this.tag = n2;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

