/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;

public class OracleTypeTIMESTAMPTZ
extends OracleType
implements Serializable {
    static final long serialVersionUID = 5643686037837085645L;
    int precision = 0;
    transient OracleConnection connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    protected OracleTypeTIMESTAMPTZ() {
    }

    public OracleTypeTIMESTAMPTZ(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public int getTypeCode() {
        return -101;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.precision = tDSReader.readByte();
    }

    public int getScale() throws SQLException {
        return 0;
    }

    public int getPrecision() throws SQLException {
        return this.precision;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.precision = objectInputStream.readByte();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.precision);
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                return new TIMESTAMPTZ(byArray);
            }
            case 2: {
                return TIMESTAMPTZ.toTimestamp(this.connection, byArray);
            }
            case 3: {
                return byArray;
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        block10: {
            tIMESTAMPTZ = null;
            if (object != null) {
                try {
                    if (object instanceof TIMESTAMPTZ) {
                        tIMESTAMPTZ = (TIMESTAMPTZ)object;
                        break block10;
                    }
                    if (object instanceof byte[]) {
                        tIMESTAMPTZ = new TIMESTAMPTZ((byte[])object);
                        break block10;
                    }
                    if (object instanceof Timestamp) {
                        tIMESTAMPTZ = new TIMESTAMPTZ((Connection)oracleConnection, (Timestamp)object);
                        break block10;
                    }
                    if (object instanceof DATE) {
                        tIMESTAMPTZ = new TIMESTAMPTZ((Connection)oracleConnection, (DATE)object);
                        break block10;
                    }
                    if (object instanceof String) {
                        tIMESTAMPTZ = new TIMESTAMPTZ((Connection)oracleConnection, (String)object);
                        break block10;
                    }
                    if (object instanceof Date) {
                        tIMESTAMPTZ = new TIMESTAMPTZ((Connection)oracleConnection, (Date)object);
                        break block10;
                    }
                    if (object instanceof Time) {
                        tIMESTAMPTZ = new TIMESTAMPTZ((Connection)oracleConnection, (Time)object);
                        break block10;
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                catch (Exception exception) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        }
        return tIMESTAMPTZ;
    }

    protected Object unpickle81rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

