/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BLOB;

class OracleBlobOutputStream
extends OutputStream {
    long lobOffset;
    BLOB blob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleBlobOutputStream(BLOB bLOB, int n2) throws SQLException {
        this(bLOB, n2, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleBlobOutputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        PhysicalConnection physicalConnection;
        if (bLOB == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.blob = bLOB;
        this.lobOffset = l2;
        PhysicalConnection physicalConnection2 = physicalConnection = (PhysicalConnection)bLOB.getInternalConnection();
        synchronized (physicalConnection2) {
            this.buf = physicalConnection.getByteBuffer(n2);
        }
        this.count = 0;
        this.bufSize = n2;
        this.isClosed = false;
    }

    public void write(int n2) throws IOException {
        this.ensureOpen();
        if (this.count >= this.bufSize) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)n2;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        int n4 = n2;
        int n5 = Math.min(n3, byArray.length - n2);
        if (n5 >= 2 * this.bufSize) {
            if (this.count > 0) {
                this.flushBuffer();
            }
            try {
                this.lobOffset += (long)this.blob.setBytes(this.lobOffset, byArray, n2, n5);
            }
            catch (SQLException sQLException) {
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        } else {
            int n6 = n4 + n5;
            while (n4 < n6) {
                int n7 = Math.min(this.bufSize - this.count, n6 - n4);
                System.arraycopy(byArray, n4, this.buf, this.count, n7);
                n4 += n7;
                this.count += n7;
                if (this.count < this.bufSize) continue;
                this.flushBuffer();
            }
        }
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            this.flushBuffer();
        }
        finally {
            try {
                PhysicalConnection physicalConnection;
                PhysicalConnection physicalConnection2 = physicalConnection = (PhysicalConnection)this.blob.getInternalConnection();
                synchronized (physicalConnection2) {
                    if (this.buf != null) {
                        physicalConnection.cacheBuffer(this.buf);
                        this.buf = null;
                    }
                }
            }
            catch (SQLException sQLException) {
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
    }

    private void flushBuffer() throws IOException {
        try {
            if (this.count > 0) {
                this.lobOffset += (long)this.blob.setBytes(this.lobOffset, this.buf, 0, this.count);
                this.count = 0;
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = DatabaseError.createIOException(sQLException);
            iOException.fillInStackTrace();
            throw iOException;
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = DatabaseError.createIOException(sQLException);
            iOException.fillInStackTrace();
            throw iOException;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.blob.getInternalConnection();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

