/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.processor;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.x52im.mobileimsdk.server.network.Gateway;
import net.x52im.mobileimsdk.server.utils.LocalSendHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineProcessor {
    public static final AttributeKey<String> ATTRIBUTE_KEY_USER_ID = AttributeKey.newInstance((String)"__user_id__");
    public static final AttributeKey<Long> ATTRIBUTE_KEY_FIRST_LOGIN_TIME = AttributeKey.newInstance((String)"__first_login_time__");
    public static final AttributeKey<Integer> ATTRIBUTE_KEY_BE_KICKOUT_CODE = AttributeKey.newInstance((String)"__be_keickout_code__");
    public static boolean DEBUG = false;
    private static Logger logger = LoggerFactory.getLogger(OnlineProcessor.class);
    private static volatile OnlineProcessor instance = null;
    private ConcurrentMap<String, Channel> onlineSessions = new ConcurrentHashMap<String, Channel>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OnlineProcessor getInstance() {
        if (instance != null) return instance;
        Class<OnlineProcessor> clazz = OnlineProcessor.class;
        synchronized (OnlineProcessor.class) {
            if (instance != null) return instance;
            instance = new OnlineProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private OnlineProcessor() {
    }

    public boolean putUser(String user_id, long firstLoginTime, Channel newSession) {
        boolean putOk = true;
        Channel oldSession = (Channel)this.onlineSessions.get(user_id);
        if (oldSession != null) {
            boolean isTheSame = oldSession.compareTo((Object)newSession) == 0;
            logger.debug("[IMCORE-{}]\u3010\u6ce8\u610f\u3011\u7528\u6237id={}\u5df2\u7ecf\u5728\u5728\u7ebf\u5217\u8868\u4e2d\u4e86\uff0csession\u4e5f\u662f\u540c\u4e00\u4e2a\u5417\uff1f{}", new Object[]{Gateway.$(newSession), user_id, isTheSame});
            if (!isTheSame) {
                if (firstLoginTime <= 0L) {
                    logger.debug("[IMCORE-{}]\u3010\u6ce8\u610f\u3011\u7528\u6237id={}\u63d0\u4ea4\u8fc7\u6765\u7684firstLoginTime\u672a\u8bbe\u7f6e(\u503c={}, \u5e94\u8be5\u662f\u771f\u7684\u9996\u6b21\u767b\u9646\uff1f\uff01)\uff0c\u5c06\u65e0\u6761\u4ef6\u8e22\u51fa\u524d\u9762\u7684\u4f1a\u8bdd\uff01", new Object[]{Gateway.$(newSession), user_id, firstLoginTime});
                    this.sendKickoutDuplicateLogin(oldSession, user_id);
                    this.onlineSessions.put(user_id, newSession);
                } else {
                    long firstLoginTimeForOld = OnlineProcessor.getFirstLoginTimeFromChannel(oldSession);
                    if (firstLoginTime >= firstLoginTimeForOld) {
                        logger.debug("[IMCORE-{}]\u3010\u63d0\u793a\u3011\u7528\u6237id={}\u63d0\u4ea4\u8fc7\u6765\u7684firstLoginTime\u4e3a{}\u3001firstLoginTimeForOld\u4e3a{}\uff0c\u65b0\u7684\u201c\u9996\u6b21\u767b\u9646\u65f6\u95f4\u201d\u3010\u665a\u4e8e\u3011\u5217\u8868\u4e2d\u7684\u201c\u8001\u7684\u201d\u3001\u6b63\u5e38\u8e22\u51fa\u8001\u7684\u5373\u53ef\uff01", new Object[]{Gateway.$(newSession), user_id, firstLoginTime, firstLoginTimeForOld});
                        this.sendKickoutDuplicateLogin(oldSession, user_id);
                        this.onlineSessions.put(user_id, newSession);
                    } else {
                        logger.debug("[IMCORE-{}]\u3010\u6ce8\u610f\u3011\u7528\u6237id={}\u63d0\u4ea4\u8fc7\u6765\u7684firstLoginTime\u4e3a{}\u3001firstLoginTimeForOld\u4e3a{}\uff0c\u65b0\u7684\u201c\u9996\u6b21\u767b\u9646\u65f6\u95f4\u201d\u3010\u65e9\u4e8e\u3011\u5217\u8868\u4e2d\u7684\u201c\u8001\u7684\u201d\uff0c\u8868\u793a\u201c\u65b0\u201d\u7684\u4f1a\u8bdd\u5e94\u8be5\u662f\u672a\u88ab\u6b63\u5e38\u901a\u77e5\u7684\u201c\u5df2\u8e22\u201d\u4f1a\u8bdd\uff0c\u5e94\u518d\u6b21\u5411\u201c\u65b0\u201d\u4f1a\u8bdd\u53d1\u51fa\u88ab\u8e22\u901a\u77e5\uff01\uff01", new Object[]{Gateway.$(newSession), user_id, firstLoginTime, firstLoginTimeForOld});
                        this.sendKickoutDuplicateLogin(newSession, user_id);
                        putOk = false;
                    }
                }
            } else {
                this.onlineSessions.put(user_id, newSession);
            }
        } else {
            this.onlineSessions.put(user_id, newSession);
        }
        this.__printOnline();
        return putOk;
    }

    private void sendKickoutDuplicateLogin(Channel sessionBeKick, String to_user_id) {
        try {
            LocalSendHelper.sendKickout(sessionBeKick, to_user_id, 1, null);
            logger.debug("[IMCORE-{}]\u3010\u63d0\u793a\u3011\u670d\u52a1\u7aef\u6b63\u5728\u5411\u7528\u6237id={}\u53d1\u9001\u88ab\u8e22\u6307\u4ee4\uff01", (Object)Gateway.$(sessionBeKick), (Object)to_user_id);
        }
        catch (Exception e) {
            logger.warn("[IMCORE-" + Gateway.$(sessionBeKick) + "] sendKickoutDuplicate\u7684\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e86\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void __printOnline() {
        logger.debug("\u3010@\u3011\u5f53\u524d\u5728\u7ebf\u7528\u6237\u5171(" + this.onlineSessions.size() + ")\u4eba------------------->");
        if (DEBUG) {
            for (String key : this.onlineSessions.keySet()) {
                logger.debug("      > user_id=" + key + ",session=" + ((Channel)this.onlineSessions.get(key)).remoteAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUser(String user_id) {
        ConcurrentMap<String, Channel> concurrentMap = this.onlineSessions;
        synchronized (concurrentMap) {
            block4: {
                if (this.onlineSessions.containsKey(user_id)) break block4;
                logger.warn("[IMCORE]\uff01\u7528\u6237id={}\u4e0d\u5b58\u5728\u5728\u7ebf\u5217\u8868\u4e2d\uff0c\u672c\u6b21removeUser\u6ca1\u6709\u7ee7\u7eed.", (Object)user_id);
                this.__printOnline();
                return false;
            }
            return this.onlineSessions.remove(user_id) != null;
        }
    }

    public Channel getOnlineSession(String user_id) {
        if (user_id == null) {
            logger.warn("[IMCORE][CAUTION] getOnlineSession\u65f6\uff0c\u4f5c\u4e3akey\u7684user_id== null.");
            return null;
        }
        return (Channel)this.onlineSessions.get(user_id);
    }

    public ConcurrentMap<String, Channel> getOnlineSessions() {
        return this.onlineSessions;
    }

    public static boolean isLogined(Channel session) {
        return session != null && OnlineProcessor.getUserIdFromChannel(session) != null;
    }

    public static boolean isOnline(String userId) {
        return OnlineProcessor.getInstance().getOnlineSession(userId) != null;
    }

    public static void setUserIdForChannel(Channel session, String userId) {
        session.attr(ATTRIBUTE_KEY_USER_ID).set((Object)userId);
    }

    public static void setFirstLoginTimeForChannel(Channel session, long firstLoginTime) {
        session.attr(ATTRIBUTE_KEY_FIRST_LOGIN_TIME).set((Object)firstLoginTime);
    }

    public static void setBeKickoutCodeForChannel(Channel session, int beKickoutCode) {
        session.attr(ATTRIBUTE_KEY_BE_KICKOUT_CODE).set((Object)beKickoutCode);
    }

    public static String getUserIdFromChannel(Channel session) {
        return session != null ? (String)session.attr(ATTRIBUTE_KEY_USER_ID).get() : null;
    }

    public static long getFirstLoginTimeFromChannel(Channel session) {
        if (session != null) {
            Long attr = (Long)session.attr(ATTRIBUTE_KEY_FIRST_LOGIN_TIME).get();
            return attr != null ? attr : -1L;
        }
        return -1L;
    }

    public static int getBeKickoutCodeFromChannel(Channel session) {
        if (session != null) {
            Integer attr = (Integer)session.attr(ATTRIBUTE_KEY_BE_KICKOUT_CODE).get();
            return attr != null ? attr : -1;
        }
        return -1;
    }

    public static void removeAttributesForChannel(Channel session) {
        session.attr(ATTRIBUTE_KEY_USER_ID).set(null);
        session.attr(ATTRIBUTE_KEY_FIRST_LOGIN_TIME).set(null);
        session.attr(ATTRIBUTE_KEY_BE_KICKOUT_CODE).set(null);
    }
}

