/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.network.udp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioMessageChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.ServerSocketChannelConfig;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.LinkedHashMap;
import java.util.List;
import net.x52im.mobileimsdk.server.network.udp.MBUDPChannel;
import net.x52im.mobileimsdk.server.network.udp.MBUDPServerChannelConfig;

public class MBUDPServerChannel
extends AbstractNioMessageChannel
implements ServerSocketChannel {
    private final ChannelMetadata METADATA = new ChannelMetadata(true);
    private final MBUDPServerChannelConfig config;
    protected final LinkedHashMap<InetSocketAddress, MBUDPChannel> channels = new LinkedHashMap();

    public MBUDPServerChannel() throws IOException {
        this(SelectorProvider.provider().openDatagramChannel(StandardProtocolFamily.INET));
    }

    protected MBUDPServerChannel(DatagramChannel datagramChannel) {
        super(null, (SelectableChannel)datagramChannel, 1);
        this.config = new MBUDPServerChannelConfig((Channel)this, datagramChannel);
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    protected SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    public InetSocketAddress remoteAddress() {
        return null;
    }

    protected SocketAddress remoteAddress0() {
        return null;
    }

    public ChannelMetadata metadata() {
        return this.METADATA;
    }

    public ServerSocketChannelConfig config() {
        return this.config;
    }

    public boolean isActive() {
        return this.javaChannel().isOpen() && this.javaChannel().socket().isBound();
    }

    protected DatagramChannel javaChannel() {
        return (DatagramChannel)super.javaChannel();
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
        this.javaChannel().socket().bind(localAddress);
    }

    protected void doClose() throws Exception {
        for (MBUDPChannel channel : this.channels.values()) {
            channel.close();
        }
        this.javaChannel().close();
    }

    public void removeChannel(final Channel channel) {
        this.eventLoop().submit(new Runnable(){

            @Override
            public void run() {
                InetSocketAddress remote = (InetSocketAddress)channel.remoteAddress();
                if (MBUDPServerChannel.this.channels.get(remote) == channel) {
                    MBUDPServerChannel.this.channels.remove(remote);
                }
            }
        });
    }

    protected int doReadMessages(List<Object> list) throws Exception {
        DatagramChannel javaChannel = this.javaChannel();
        RecvByteBufAllocator.Handle allocatorHandle = this.unsafe().recvBufAllocHandle();
        ByteBuf buffer = allocatorHandle.allocate(this.config.getAllocator());
        allocatorHandle.attemptedBytesRead(buffer.writableBytes());
        boolean freeBuffer = true;
        try {
            ByteBuffer nioBuffer = buffer.internalNioBuffer(buffer.writerIndex(), buffer.writableBytes());
            int nioPos = nioBuffer.position();
            InetSocketAddress inetSocketAddress = (InetSocketAddress)javaChannel.receive(nioBuffer);
            if (inetSocketAddress == null) {
                return 0;
            }
            allocatorHandle.lastBytesRead(nioBuffer.position() - nioPos);
            buffer.writerIndex(buffer.writerIndex() + allocatorHandle.lastBytesRead());
            MBUDPChannel udpchannel = this.channels.get(inetSocketAddress);
            if (udpchannel == null || !udpchannel.isOpen()) {
                udpchannel = new MBUDPChannel(this, inetSocketAddress);
                this.channels.put(inetSocketAddress, udpchannel);
                list.add((Object)udpchannel);
                udpchannel.addBuffer(buffer);
                freeBuffer = false;
                return 1;
            }
            udpchannel.addBuffer(buffer);
            freeBuffer = false;
            if (udpchannel.isRegistered()) {
                udpchannel.read();
            }
            return 0;
        }
        catch (Throwable t) {
            PlatformDependent.throwException((Throwable)t);
            return -1;
        }
        finally {
            if (freeBuffer) {
                buffer.release();
            }
        }
    }

    protected boolean doWriteMessage(Object msg, ChannelOutboundBuffer buffer) throws Exception {
        DatagramPacket dpacket = (DatagramPacket)msg;
        InetSocketAddress recipient = (InetSocketAddress)dpacket.recipient();
        ByteBuf byteBuf = (ByteBuf)dpacket.content();
        int readableBytes = byteBuf.readableBytes();
        if (readableBytes == 0) {
            return true;
        }
        ByteBuffer internalNioBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), readableBytes);
        return this.javaChannel().send(internalNioBuffer, recipient) > 0;
    }

    protected boolean doConnect(SocketAddress addr1, SocketAddress addr2) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doFinishConnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doDisconnect() throws Exception {
        throw new UnsupportedOperationException();
    }
}

