/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.network.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import net.x52im.mobileimsdk.server.ServerCoreHandler;
import net.x52im.mobileimsdk.server.network.Gateway;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import net.x52im.mobileimsdk.server.utils.ServerToolKits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBTCPClientInboundHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static Logger logger = LoggerFactory.getLogger(MBTCPClientInboundHandler.class);
    private ServerCoreHandler serverCoreHandler = null;

    public MBTCPClientInboundHandler(ServerCoreHandler serverCoreHandler) {
        this.serverCoreHandler = serverCoreHandler;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        try {
            if (e instanceof ReadTimeoutException) {
                logger.info("[IMCORE-tcp]\u5ba2\u6237\u7aef{}\u7684\u4f1a\u8bdd\u5df2\u8d85\u65f6\u5931\u6548\uff0c\u5f88\u53ef\u80fd\u662f\u5bf9\u65b9\u975e\u6b63\u5e38\u901a\u51fa\u6216\u7f51\u7edc\u6545\u969c\uff0c\u5373\u5c06\u4ee5\u4f1a\u8bdd\u5f02\u5e38\u7684\u65b9\u5f0f\u6267\u884c\u5173\u95ed\u6d41\u7a0b ...", (Object)ServerToolKits.clientInfoToString(ctx.channel()));
            }
            this.serverCoreHandler.exceptionCaught(ctx.channel(), e);
        }
        catch (Exception e2) {
            logger.warn(e2.getMessage(), e);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        Gateway.setSocketType(ctx.channel(), 2);
        this.serverCoreHandler.sessionCreated(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        Gateway.removeSocketType(ctx.channel());
        this.serverCoreHandler.sessionClosed(ctx.channel());
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf bytebuf) throws Exception {
        Protocal pFromClient = ServerToolKits.fromIOBuffer(bytebuf);
        this.serverCoreHandler.messageReceived(ctx.channel(), pFromClient);
    }
}

