/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.amqp;

import com.google.auto.value.AutoValue;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.internal.Platform;
import zipkin2.reporter.BytesMessageEncoder;
import zipkin2.reporter.Sender;
import zipkin2.reporter.amqp.AutoValue_RabbitMQSender;
import zipkin2.reporter.internal.BaseCall;

@AutoValue
public abstract class RabbitMQSender
extends Sender {
    volatile boolean provisioned;
    volatile boolean closeCalled;
    final ThreadLocal<Channel> localChannel = new ThreadLocal<Channel>(){

        @Override
        protected Channel initialValue() {
            try {
                return RabbitMQSender.this.get().createChannel();
            }
            catch (IOException e) {
                throw Platform.get().uncheckedIOException(e);
            }
        }
    };

    public static RabbitMQSender create(String addresses) {
        return RabbitMQSender.newBuilder().addresses(addresses).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public final Builder toBuilder() {
        return new Builder().connectionFactory(this.connectionFactory().clone()).addresses(this.addresses()).queue(this.queue()).encoding(this.encoding());
    }

    abstract List<Address> addresses();

    abstract String queue();

    abstract ConnectionFactory connectionFactory();

    abstract BytesMessageEncoder encoder();

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding().listSizeInBytes(encodedSpans);
    }

    public int messageSizeInBytes(int encodedSizeInBytes) {
        return this.encoding().listSizeInBytes(encodedSizeInBytes);
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closeCalled) {
            throw new IllegalStateException("closed");
        }
        byte[] message = this.encoder().encode(encodedSpans);
        return new RabbitMQCall(message);
    }

    public CheckResult check() {
        try {
            if (this.get().isOpen()) {
                return CheckResult.OK;
            }
            throw new IllegalStateException("Not Open");
        }
        catch (RuntimeException e) {
            return CheckResult.failed((Throwable)e);
        }
    }

    public final String toString() {
        return "RabbitMQSender{addresses=" + this.addresses() + ", queue=" + this.queue() + "}";
    }

    Connection get() {
        Connection result;
        try {
            result = this.connectionFactory().newConnection(this.addresses());
        }
        catch (IOException | TimeoutException e) {
            throw new IllegalStateException("Unable to establish connection to RabbitMQ server", e);
        }
        this.provisioned = true;
        return result;
    }

    public synchronized void close() throws IOException {
        if (this.closeCalled) {
            return;
        }
        if (this.provisioned) {
            this.get().close();
        }
        this.closeCalled = true;
    }

    static List<Address> convertAddresses(String addresses) {
        String[] addressStrings = addresses.split(",");
        Address[] addressArray = new Address[addressStrings.length];
        for (int i = 0; i < addressStrings.length; ++i) {
            String[] splitAddress = addressStrings[i].split(":");
            String host = splitAddress[0];
            Integer port = null;
            try {
                if (splitAddress.length == 2) {
                    port = Integer.parseInt(splitAddress[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            addressArray[i] = port != null ? new Address(host, port.intValue()) : new Address(host);
        }
        return Arrays.asList(addressArray);
    }

    class RabbitMQCall
    extends BaseCall<Void> {
        private final byte[] message;

        RabbitMQCall(byte[] message) {
            this.message = message;
        }

        protected Void doExecute() throws IOException {
            this.publish();
            return null;
        }

        void publish() throws IOException {
            RabbitMQSender.this.localChannel.get().basicPublish("", RabbitMQSender.this.queue(), null, this.message);
        }

        protected void doEnqueue(Callback<Void> callback) {
            try {
                this.publish();
                callback.onSuccess(null);
            }
            catch (IOException | Error | RuntimeException e) {
                callback.onError(e);
            }
        }

        public Call<Void> clone() {
            return new RabbitMQCall(this.message);
        }
    }

    public static final class Builder {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        List<Address> addresses;
        String queue = "zipkin";
        Encoding encoding = Encoding.JSON;
        int messageMaxBytes = 100000;

        public Builder connectionFactory(ConnectionFactory connectionFactory) {
            if (connectionFactory == null) {
                throw new NullPointerException("connectionFactory == null");
            }
            this.connectionFactory = connectionFactory;
            return this;
        }

        public Builder addresses(List<Address> addresses) {
            if (addresses == null) {
                throw new NullPointerException("addresses == null");
            }
            this.addresses = addresses;
            return this;
        }

        public Builder addresses(String addresses) {
            if (addresses == null) {
                throw new NullPointerException("addresses == null");
            }
            this.addresses = RabbitMQSender.convertAddresses(addresses);
            return this;
        }

        public Builder queue(String queue) {
            if (queue == null) {
                throw new NullPointerException("queue == null");
            }
            this.queue = queue;
            return this;
        }

        public Builder encoding(Encoding encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding == null");
            }
            this.encoding = encoding;
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionFactory.setConnectionTimeout(connectionTimeout);
            return this;
        }

        public Builder virtualHost(String virtualHost) {
            this.connectionFactory.setVirtualHost(virtualHost);
            return this;
        }

        public Builder username(String username) {
            this.connectionFactory.setUsername(username);
            return this;
        }

        public Builder password(String password) {
            this.connectionFactory.setPassword(password);
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public final RabbitMQSender build() {
            return new AutoValue_RabbitMQSender(this.encoding, this.messageMaxBytes, this.addresses, this.queue, this.connectionFactory.clone(), BytesMessageEncoder.forEncoding((Encoding)this.encoding));
        }
    }
}

