/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.spring.boot;

import io.shardingsphere.transaction.aspect.ShardingTransactionalAspect;
import java.util.Arrays;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ClassUtils;

@Configuration
public class ShardingTransactionConfiguration {
    @Bean
    public ShardingTransactionalAspect shardingTransactionalAspect() {
        return new ShardingTransactionalAspect();
    }

    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    @Conditional(value={HibernateEntityManagerCondition.class})
    public PlatformTransactionManager jpaTransactionManager(ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        JpaTransactionManager result = new JpaTransactionManager();
        if (null != transactionManagerCustomizers.getIfAvailable()) {
            ((TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable()).customize((PlatformTransactionManager)result);
        }
        return result;
    }

    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    public PlatformTransactionManager dataSourceTransactionManager(DataSource dataSource, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        DataSourceTransactionManager result = new DataSourceTransactionManager(dataSource);
        if (null != transactionManagerCustomizers.getIfAvailable()) {
            ((TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable()).customize((PlatformTransactionManager)result);
        }
        return result;
    }

    static class HibernateEntityManagerCondition
    extends SpringBootCondition {
        private static final String[] CLASS_NAMES = new String[]{"org.hibernate.ejb.HibernateEntityManager", "org.hibernate.jpa.HibernateEntityManager"};

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"HibernateEntityManager", (Object[])new Object[0]);
            for (String each : CLASS_NAMES) {
                if (!ClassUtils.isPresent((String)each, (ClassLoader)context.getClassLoader())) continue;
                return ConditionOutcome.match((ConditionMessage)message.found("class").items(ConditionMessage.Style.QUOTE, new Object[]{each}));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("class", "classes").items(ConditionMessage.Style.QUOTE, Arrays.asList(CLASS_NAMES)));
        }
    }
}

