/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.strategy;

import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.routing.strategy.ShardingAlgorithm;

public final class ShardingAlgorithmFactory {
    public static <T extends ShardingAlgorithm> T newInstance(String shardingAlgorithmClassName, Class<T> superShardingAlgorithmClass) {
        try {
            Class<?> result = Class.forName(shardingAlgorithmClassName);
            if (!superShardingAlgorithmClass.isAssignableFrom(result)) {
                throw new ShardingException("Class %s should be implement %s", shardingAlgorithmClassName, superShardingAlgorithmClass.getName());
            }
            return (T)((ShardingAlgorithm)result.newInstance());
        }
        catch (ReflectiveOperationException ex) {
            throw new ShardingException(ex);
        }
    }

    private ShardingAlgorithmFactory() {
    }
}

