/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.clause;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.OrderDirection;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.dialect.oracle.OracleKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingsphere.core.parsing.parser.context.orderby.OrderItem;
import io.shardingsphere.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.expression.SQLExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLIdentifierExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLIgnoreExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLNumberExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLPlaceholderExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLPropertyExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLTextExpression;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.util.SQLUtil;
import java.util.LinkedList;

public abstract class OrderByClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public OrderByClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public final void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.ORDER)) {
            return;
        }
        LinkedList<Object> result = new LinkedList<Object>();
        this.lexerEngine.skipIfEqual(OracleKeyword.SIBLINGS);
        this.lexerEngine.accept(DefaultKeyword.BY);
        do {
            Optional<OrderItem> orderItem;
            if (!(orderItem = this.parseSelectOrderByItem(selectStatement)).isPresent()) continue;
            result.add(orderItem.get());
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        selectStatement.getOrderByItems().addAll(result);
    }

    private Optional<OrderItem> parseSelectOrderByItem(SelectStatement selectStatement) {
        SQLExpression sqlExpression = this.basicExpressionParser.parse(selectStatement);
        OrderDirection orderDirection = OrderDirection.ASC;
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.ASC)) {
            orderDirection = OrderDirection.ASC;
        } else if (this.lexerEngine.skipIfEqual(DefaultKeyword.DESC)) {
            orderDirection = OrderDirection.DESC;
        }
        if (sqlExpression instanceof SQLTextExpression) {
            return Optional.of((Object)new OrderItem(SQLUtil.getExactlyValue(((SQLTextExpression)sqlExpression).getText()), orderDirection, this.getNullOrderDirection()));
        }
        if (sqlExpression instanceof SQLNumberExpression) {
            return Optional.of((Object)new OrderItem(((SQLNumberExpression)sqlExpression).getNumber().intValue(), orderDirection, this.getNullOrderDirection()));
        }
        if (sqlExpression instanceof SQLIdentifierExpression) {
            OrderItem result = new OrderItem(SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName()), orderDirection, this.getNullOrderDirection());
            Optional<String> alias = selectStatement.getAlias(SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName()));
            if (alias.isPresent()) {
                result.setAlias((String)alias.get());
            }
            return Optional.of((Object)result);
        }
        if (sqlExpression instanceof SQLPropertyExpression) {
            SQLPropertyExpression sqlPropertyExpression = (SQLPropertyExpression)sqlExpression;
            OrderItem result = new OrderItem(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()), SQLUtil.getExactlyValue(sqlPropertyExpression.getName()), orderDirection, this.getNullOrderDirection());
            Optional<String> alias = selectStatement.getAlias(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()) + "." + SQLUtil.getExactlyValue(sqlPropertyExpression.getName()));
            if (alias.isPresent()) {
                result.setAlias((String)alias.get());
            }
            return Optional.of((Object)result);
        }
        if (sqlExpression instanceof SQLIgnoreExpression) {
            SQLIgnoreExpression sqlIgnoreExpression = (SQLIgnoreExpression)sqlExpression;
            OrderItem result = new OrderItem(sqlIgnoreExpression.getExpression(), orderDirection, this.getNullOrderDirection());
            Optional<String> alias = selectStatement.getAlias(sqlIgnoreExpression.getExpression());
            if (alias.isPresent()) {
                result.setAlias((String)alias.get());
            }
            return Optional.of((Object)result);
        }
        if (sqlExpression instanceof SQLPlaceholderExpression) {
            return Optional.absent();
        }
        throw new SQLParsingException(this.lexerEngine);
    }

    protected abstract OrderDirection getNullOrderDirection();

    public LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }
}

