/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.sql.statement.ddl;

import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.TokenType;
import io.shardingsphere.core.parsing.parser.sql.AbstractSQLStatement;
import java.util.Arrays;
import java.util.Collection;

public class DDLStatement
extends AbstractSQLStatement {
    private static final Collection<Keyword> PRIMARY_STATEMENT_PREFIX = Arrays.asList(DefaultKeyword.CREATE, DefaultKeyword.ALTER, DefaultKeyword.DROP, DefaultKeyword.TRUNCATE);
    private static final Collection<Keyword> NOT_SECONDARY_STATEMENT_PREFIX = Arrays.asList(DefaultKeyword.LOGIN, DefaultKeyword.USER, DefaultKeyword.ROLE);

    public DDLStatement() {
        super(SQLType.DDL);
    }

    public static boolean isDDL(TokenType primaryTokenType, TokenType secondaryTokenType) {
        return PRIMARY_STATEMENT_PREFIX.contains(primaryTokenType) && !NOT_SECONDARY_STATEMENT_PREFIX.contains(secondaryTokenType);
    }
}

