/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.cache.ParsingResultCache;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.LexerEngineFactory;
import io.shardingsphere.core.parsing.parser.sql.SQLParserFactory;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;

public final class SQLParsingEngine {
    private final DatabaseType dbType;
    private final String sql;
    private final ShardingRule shardingRule;
    private final ShardingTableMetaData shardingTableMetaData;

    public SQLStatement parse(boolean useCache) {
        Optional<SQLStatement> cachedSQLStatement = this.getSQLStatementFromCache(useCache);
        if (cachedSQLStatement.isPresent()) {
            return (SQLStatement)cachedSQLStatement.get();
        }
        LexerEngine lexerEngine = LexerEngineFactory.newInstance(this.dbType, this.sql);
        SQLStatement result = SQLParserFactory.newInstance(this.dbType, this.shardingRule, lexerEngine, this.shardingTableMetaData, this.sql).parse();
        if (useCache) {
            ParsingResultCache.getInstance().put(this.sql, result);
        }
        return result;
    }

    private Optional<SQLStatement> getSQLStatementFromCache(boolean useCache) {
        return useCache ? Optional.fromNullable((Object)ParsingResultCache.getInstance().getSQLStatement(this.sql)) : Optional.absent();
    }

    @ConstructorProperties(value={"dbType", "sql", "shardingRule", "shardingTableMetaData"})
    public SQLParsingEngine(DatabaseType dbType, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        this.dbType = dbType;
        this.sql = sql;
        this.shardingRule = shardingRule;
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

